/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ruleunit.command.pmml;

import org.drools.core.command.impl.ContextImpl;
import org.drools.core.command.runtime.pmml.ApplyPmmlModelCommand;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.KnowledgeBaseFactory;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.pmml.PMML4Result;
import org.kie.api.pmml.PMMLConstants;
import org.kie.api.pmml.PMMLRequestData;
import org.kie.api.runtime.Context;

public class ApplyPmmlModelCommandTest {
    @Test(expected=IllegalStateException.class)
    public void testMissingRequestDataWithLegacy() {
        ApplyPmmlModelCommandTester cmd = new ApplyPmmlModelCommandTester(PMMLConstants.LEGACY);
        ContextImpl ctx = new ContextImpl();
        cmd.execute((Context)ctx);
    }

    @Test
    public void testHasRequestDataAndKieBaseWithLegacy() {
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase((String)"defaultKieBase");
        ApplyPmmlModelCommandTester cmd = new ApplyPmmlModelCommandTester(PMMLConstants.LEGACY);
        PMMLRequestData data = new PMMLRequestData("123", "Sample Score");
        data.addRequestParam("age", (Object)33.0);
        data.addRequestParam("occupation", (Object)"SKYDIVER");
        data.addRequestParam("residenceState", (Object)"KN");
        data.addRequestParam("validLicense", (Object)true);
        cmd.setRequestData(data);
        cmd.setPackageName("org.drools.scorecards.example");
        ContextImpl ctx = new ContextImpl().register(KieBase.class, (Object)kbase);
        PMML4Result resultHolder = cmd.execute((Context)ctx);
        Assert.assertNotNull((Object)resultHolder);
        String invoked = (String)resultHolder.getResultVariables().get("TYPE");
        Assert.assertEquals((Object)"LEGACY", (Object)invoked);
        String resultCode = resultHolder.getResultCode();
        Assert.assertEquals((Object)"ERROR-2", (Object)resultCode);
    }

    @Test
    public void testHasRequestDataWithLegacy() {
        ApplyPmmlModelCommandTester cmd = new ApplyPmmlModelCommandTester(PMMLConstants.LEGACY);
        PMMLRequestData data = new PMMLRequestData("123", "Sample Score");
        data.addRequestParam("age", (Object)33.0);
        data.addRequestParam("occupation", (Object)"SKYDIVER");
        data.addRequestParam("residenceState", (Object)"KN");
        data.addRequestParam("validLicense", (Object)true);
        cmd.setRequestData(data);
        cmd.setPackageName("org.drools.scorecards.example");
        ContextImpl ctx = new ContextImpl();
        PMML4Result resultHolder = cmd.execute((Context)ctx);
        Assert.assertNotNull((Object)resultHolder);
        String invoked = (String)resultHolder.getResultVariables().get("TYPE");
        Assert.assertEquals((Object)"LEGACY", (Object)invoked);
        String resultCode = resultHolder.getResultCode();
        Assert.assertEquals((Object)"ERROR-1", (Object)resultCode);
    }

    @Test(expected=IllegalStateException.class)
    public void testMissingRequestDataWithTrusty() {
        ApplyPmmlModelCommandTester cmd = new ApplyPmmlModelCommandTester(PMMLConstants.NEW);
        ContextImpl ctx = new ContextImpl();
        cmd.execute((Context)ctx);
    }

    @Test
    public void testHasRequestDataAndSourceWithNew() {
        ApplyPmmlModelCommandTester cmd = new ApplyPmmlModelCommandTester(PMMLConstants.NEW);
        PMMLRequestData data = new PMMLRequestData("123", "Sample Score");
        data.addRequestParam("age", (Object)33.0);
        data.addRequestParam("occupation", (Object)"SKYDIVER");
        data.addRequestParam("residenceState", (Object)"KN");
        data.addRequestParam("validLicense", (Object)true);
        data.setSource("SOURCE");
        cmd.setRequestData(data);
        cmd.setPackageName("org.drools.scorecards.example");
        ContextImpl ctx = new ContextImpl();
        PMML4Result resultHolder = cmd.execute((Context)ctx);
        Assert.assertNotNull((Object)resultHolder);
        String invoked = (String)resultHolder.getResultVariables().get("TYPE");
        Assert.assertEquals((Object)"TRUSTY", (Object)invoked);
    }

    @Test(expected=IllegalArgumentException.class)
    public void executeInvalid() {
        ApplyPmmlModelCommandTester cmd = new ApplyPmmlModelCommandTester(PMMLConstants.KIE_PMML_IMPLEMENTATION);
        PMMLRequestData data = new PMMLRequestData("123", "Sample Score");
        cmd.setRequestData(data);
        cmd.execute((Context)new ContextImpl());
    }

    @Test
    public void testIsMining() {
        ApplyPmmlModelCommand cmd = new ApplyPmmlModelCommand();
        Assert.assertNull((Object)cmd.getHasMining());
        Assert.assertFalse((boolean)cmd.isMining());
        cmd.setHasMining(Boolean.valueOf(false));
        Assert.assertFalse((boolean)cmd.isMining());
        cmd.setHasMining(Boolean.valueOf(true));
        Assert.assertTrue((boolean)cmd.isMining());
    }

    private class ApplyPmmlModelCommandTester
    extends ApplyPmmlModelCommand {
        private final PMMLConstants IMPLEMENTATION;

        public ApplyPmmlModelCommandTester(PMMLConstants implementation) {
            this.IMPLEMENTATION = implementation;
        }

        protected PMMLConstants getToInvoke(Context context) {
            return this.IMPLEMENTATION;
        }

        protected PMML4Result executePMMLLegacy(Context context) {
            PMML4Result toReturn = super.executePMMLLegacy(context);
            toReturn.addResultVariable("TYPE", (Object)"LEGACY");
            return toReturn;
        }

        protected PMML4Result executePMMLTrusty(Context context) {
            PMML4Result toReturn = super.executePMMLTrusty(context);
            toReturn.addResultVariable("TYPE", (Object)"TRUSTY");
            return toReturn;
        }
    }
}

