/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ruleunit;

import java.math.BigDecimal;
import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectArrayAssert;
import org.assertj.core.api.ObjectAssert;
import org.drools.ruleunit.DataSource;
import org.drools.ruleunit.RuleUnit;
import org.drools.ruleunit.RuleUnitWithDataSource;
import org.drools.ruleunit.TestRuleUnit;
import org.drools.ruleunit.datasources.CursoredDataSource;
import org.drools.ruleunit.datasources.InternalDataSource;
import org.drools.ruleunit.executor.InternalRuleUnitExecutor;
import org.drools.ruleunit.impl.RuleUnitFactory;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class RuleUnitFactoryTest {
    private RuleUnitFactory factory;

    @Before
    public void prepareRuleUnitFactory() {
        this.factory = new RuleUnitFactory();
    }

    @Test
    public void getOrCreateRuleUnitWithClass() {
        InternalRuleUnitExecutor ruleUnitExecutor = (InternalRuleUnitExecutor)Mockito.mock(InternalRuleUnitExecutor.class);
        TestRuleUnit testRuleUnit = (TestRuleUnit)this.factory.getOrCreateRuleUnit(ruleUnitExecutor, TestRuleUnit.class);
        Assertions.assertThat((Object)testRuleUnit).isNotNull();
        Assertions.assertThat((Object)((TestRuleUnit)this.factory.getOrCreateRuleUnit(ruleUnitExecutor, TestRuleUnit.class))).isSameAs((Object)testRuleUnit);
        Mockito.verifyZeroInteractions((Object[])new Object[]{ruleUnitExecutor});
    }

    @Test
    public void getOrCreateRuleUnitWithClassName() {
        InternalRuleUnitExecutor ruleUnitExecutor = (InternalRuleUnitExecutor)Mockito.mock(InternalRuleUnitExecutor.class);
        RuleUnit testRuleUnit = this.factory.getOrCreateRuleUnit(ruleUnitExecutor, TestRuleUnit.class.getCanonicalName(), this.getClass().getClassLoader());
        ((ObjectAssert)Assertions.assertThat((Object)testRuleUnit).isNotNull()).isInstanceOf(TestRuleUnit.class);
        Assertions.assertThat((Object)((TestRuleUnit)this.factory.getOrCreateRuleUnit(ruleUnitExecutor, TestRuleUnit.class))).isSameAs((Object)testRuleUnit);
        Mockito.verifyZeroInteractions((Object[])new Object[]{ruleUnitExecutor});
    }

    @Test
    public void registerUnit() {
        TestRuleUnit testRuleUnit = new TestRuleUnit(new Integer[0], BigDecimal.ZERO);
        InternalRuleUnitExecutor ruleUnitExecutor = (InternalRuleUnitExecutor)Mockito.mock(InternalRuleUnitExecutor.class);
        Assertions.assertThat((Object)this.factory.registerUnit(ruleUnitExecutor, (RuleUnit)testRuleUnit)).isSameAs((Object)testRuleUnit);
        Mockito.verifyZeroInteractions((Object[])new Object[]{ruleUnitExecutor});
        Assertions.assertThat((Object)((TestRuleUnit)this.factory.getOrCreateRuleUnit(ruleUnitExecutor, TestRuleUnit.class))).isSameAs((Object)testRuleUnit);
        Mockito.verifyZeroInteractions((Object[])new Object[]{ruleUnitExecutor});
    }

    @Test
    public void injectUnitVariablesNoDataSourceInUnit() {
        this.factory.bindVariable("numberVariable", (Object)BigDecimal.ONE);
        this.factory.bindVariable("stringList", Collections.singletonList("test"));
        TestRuleUnit testRuleUnit = new TestRuleUnit(new Integer[0], BigDecimal.ZERO);
        testRuleUnit.getStringList().add("bla");
        InternalRuleUnitExecutor ruleUnitExecutor = (InternalRuleUnitExecutor)Mockito.mock(InternalRuleUnitExecutor.class);
        this.factory.injectUnitVariables(ruleUnitExecutor, (RuleUnit)testRuleUnit);
        Assertions.assertThat((BigDecimal)testRuleUnit.getNumber()).isEqualTo((Object)BigDecimal.ONE);
        Assertions.assertThat((boolean)testRuleUnit.bound).isFalse();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])testRuleUnit.getNumbersArray()).isNotNull()).isEmpty();
        ((ListAssert)Assertions.assertThat(testRuleUnit.getSimpleFactList()).isNotNull()).isEmpty();
        ((ListAssert)((ListAssert)Assertions.assertThat(testRuleUnit.getStringList()).isNotNull()).hasSize(1)).containsExactly((Object[])new String[]{"bla"});
        Mockito.verifyZeroInteractions((Object[])new Object[]{ruleUnitExecutor});
    }

    @Test
    public void injectUnitVariablesDataSourceInUnit() {
        CursoredDataSource dataSource = (CursoredDataSource)Mockito.mock(CursoredDataSource.class);
        RuleUnitWithDataSource testRuleUnit = new RuleUnitWithDataSource((DataSource<Object>)dataSource);
        InternalRuleUnitExecutor ruleUnitExecutor = (InternalRuleUnitExecutor)Mockito.mock(InternalRuleUnitExecutor.class);
        this.factory.injectUnitVariables(ruleUnitExecutor, (RuleUnit)testRuleUnit);
        ((InternalRuleUnitExecutor)Mockito.verify((Object)ruleUnitExecutor)).bindDataSource((InternalDataSource)dataSource);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{ruleUnitExecutor});
    }
}

