/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ruleunits.dsl;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.drools.model.Index;
import org.drools.model.functions.Block3;
import org.drools.model.functions.Block4;
import org.drools.model.functions.Function1;
import org.drools.ruleunits.api.DataSource;
import org.drools.ruleunits.api.DataStore;
import org.drools.ruleunits.api.SingletonStore;
import org.drools.ruleunits.dsl.Accumulators;
import org.drools.ruleunits.dsl.RuleUnitDefinition;
import org.drools.ruleunits.dsl.RulesFactory;
import org.drools.ruleunits.dsl.domain.Person;

public class GroupByUnit
implements RuleUnitDefinition {
    private final DataStore<Person> persons;
    private final SingletonStore<Integer> threshold;
    private final Map<String, Object> results = new HashMap<String, Object>();

    public GroupByUnit() {
        this((DataStore<Person>)DataSource.createStore(), (SingletonStore<Integer>)DataSource.createSingleton());
    }

    public GroupByUnit(DataStore<Person> persons, SingletonStore<Integer> threshold) {
        this.persons = persons;
        this.threshold = threshold;
    }

    public DataStore<Person> getPersons() {
        return this.persons;
    }

    public SingletonStore<Integer> getThreshold() {
        return this.threshold;
    }

    public Map<String, Object> getResults() {
        return this.results;
    }

    public void defineRules(RulesFactory rulesFactory) {
        rulesFactory.rule("Sum adults ages grouped by initial").groupBy((Function1 & Serializable)rule -> rule.on(this.persons).filter("age", Person::getAge, Index.ConstraintType.GREATER_OR_EQUAL, (Object)18), (Function1 & Serializable)p -> p.getName().substring(0, 1), Accumulators.sum(Person::getAge)).execute(this.results, (Block3 & Serializable)(r, initial, sum) -> r.put(initial, sum));
        rulesFactory.rule("Collect persons name with ages above threshold grouped by initial").on(this.threshold).groupBy((Function1 & Serializable)rule -> rule.on(this.persons).filter("age", Person::getAge, Index.ConstraintType.GREATER_OR_EQUAL, Function1.identity()), (Function1 & Serializable)p -> p.getName().substring(0, 1), Accumulators.collect(Person::getName)).execute(this.results, (Block4 & Serializable)(r, t, initial, sum) -> r.put(initial, sum));
    }
}

