/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ruleunits.dsl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.drools.model.Index;
import org.drools.model.functions.Block1;
import org.drools.model.functions.Block2;
import org.drools.model.functions.Function1;
import org.drools.ruleunits.api.DataSource;
import org.drools.ruleunits.api.DataStore;
import org.drools.ruleunits.api.SingletonStore;
import org.drools.ruleunits.dsl.RuleUnitDefinition;
import org.drools.ruleunits.dsl.RulesFactory;

public class ExistentialUnit
implements RuleUnitDefinition {
    private final DataStore<String> strings;
    private final SingletonStore<Integer> threshold;
    private final List<String> results = new ArrayList<String>();

    public ExistentialUnit() {
        this((DataStore<String>)DataSource.createStore(), (SingletonStore<Integer>)DataSource.createSingleton());
    }

    public ExistentialUnit(DataStore<String> strings, SingletonStore<Integer> threshold) {
        this.strings = strings;
        this.threshold = threshold;
    }

    public DataStore<String> getStrings() {
        return this.strings;
    }

    public SingletonStore<Integer> getThreshold() {
        return this.threshold;
    }

    public List<String> getResults() {
        return this.results;
    }

    public void defineRules(RulesFactory rulesFactory) {
        rulesFactory.rule("Not exists string 'Hello World'").not((Function1 & Serializable)rule -> rule.on(this.strings).filter(Index.ConstraintType.EQUAL, (Object)"Hello World")).execute(this.results, (Block1 & Serializable)r -> r.add("There's no Hello World"));
        rulesFactory.rule("Exists string 'Hello World'").exists((Function1 & Serializable)rule -> rule.on(this.strings).filter(Index.ConstraintType.EQUAL, (Object)"Hello World")).execute(this.results, (Block1 & Serializable)r -> r.add("There is at least one Hello World"));
        rulesFactory.rule("Exists string longer than threshold").on(this.threshold).exists((Function1 & Serializable)rule -> rule.on(this.strings).filter(String::length, Index.ConstraintType.GREATER_THAN, Function1.identity())).execute(this.results, (Block2 & Serializable)(r, t) -> r.add("There is at least a String longer than threshold " + t));
    }
}

