/*
 * Decompiled with CFR 0.152.
 */
package org.drools.tms;

import org.drools.core.common.ReteEvaluator;
import org.drools.core.common.TruthMaintenanceSystem;
import org.drools.core.common.TruthMaintenanceSystemFactory;
import org.drools.core.reteoo.ObjectTypeConf;
import org.drools.core.rule.consequence.Activation;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.kiesession.rulebase.KnowledgeBaseFactory;
import org.drools.kiesession.session.StatefulKnowledgeSessionImpl;
import org.drools.tms.TMSMockActivation;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LazyTMSEnablingTest {
    private StatefulKnowledgeSessionImpl ksession;
    private TruthMaintenanceSystem tms;

    @Before
    public void setUp() {
        InternalKnowledgeBase kBase = KnowledgeBaseFactory.newKnowledgeBase();
        this.ksession = (StatefulKnowledgeSessionImpl)kBase.newKieSession();
        this.tms = TruthMaintenanceSystemFactory.get().getOrCreateTruthMaintenanceSystem((ReteEvaluator)this.ksession);
    }

    @Test
    public void shouldLazilyAdd() throws Exception {
        String fact1 = "logical";
        this.ksession.insert((Object)"logical");
        Assert.assertEquals((String)"Shouldn't have anything, since no logical insert was performed.", (long)0L, (long)this.tms.getEqualityKeyMap().size());
        String fact2 = "logical";
        TruthMaintenanceSystemFactory.get().getOrCreateTruthMaintenanceSystem((ReteEvaluator)this.ksession).insert((Object)"logical", null, (Activation)new TMSMockActivation());
        Assert.assertEquals((String)"Now that a logical insert was done, it should have an element.", (long)1L, (long)this.tms.getEqualityKeyMap().size());
        ObjectTypeConf typeConf = this.ksession.getObjectTypeConfigurationRegistry().getOrCreateObjectTypeConf(this.ksession.getEntryPoint(), (Object)"logical");
        Assert.assertTrue((String)"Should have enabled TMS", (boolean)typeConf.isTMSEnabled());
    }

    @Test
    public void shouldEnableTMSForSpecificType() throws Exception {
        String stringFact1 = "toto";
        String stringFact2 = "toto";
        String anotherString = "tata";
        Integer intFact1 = 99;
        Integer intFact2 = 99;
        Double doubleFact = 77.8;
        ObjectTypeConf stringTypeConf = this.ksession.getObjectTypeConfigurationRegistry().getOrCreateObjectTypeConf(this.ksession.getEntryPoint(), (Object)"toto");
        ObjectTypeConf intTypeConf = this.ksession.getObjectTypeConfigurationRegistry().getOrCreateObjectTypeConf(this.ksession.getEntryPoint(), (Object)intFact1);
        this.ksession.insert((Object)"toto");
        this.ksession.insert((Object)"tata");
        this.ksession.insert((Object)intFact1);
        this.ksession.insert((Object)doubleFact);
        for (ObjectTypeConf conf : this.ksession.getObjectTypeConfigurationRegistry().values()) {
            Assert.assertFalse((String)"TMS shouldn't be enabled for any type, since no logical insert was done.", (boolean)conf.isTMSEnabled());
        }
        TruthMaintenanceSystem tms = TruthMaintenanceSystemFactory.get().getOrCreateTruthMaintenanceSystem((ReteEvaluator)this.ksession);
        tms.insert((Object)"toto", null, (Activation)new TMSMockActivation());
        Assert.assertTrue((String)"Should have enabled TMS for Strings.", (boolean)stringTypeConf.isTMSEnabled());
        Assert.assertFalse((String)"Shouldn't have enabled TMS for Integers.", (boolean)intTypeConf.isTMSEnabled());
        tms.insert((Object)intFact2, null, (Activation)new TMSMockActivation());
        Assert.assertTrue((String)"Now it should have enabled TMS for Integers!.", (boolean)intTypeConf.isTMSEnabled());
    }
}

