/*
 * Decompiled with CFR 0.152.
 */
package org.drools.traits.compiler.integrationtests;

import java.util.ArrayList;
import java.util.Arrays;
import org.drools.core.beliefsystem.abductive.Abducible;
import org.drools.core.factmodel.traits.Thing;
import org.drools.core.factmodel.traits.Traitable;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.KnowledgeBaseFactory;
import org.drools.core.io.impl.ByteArrayResource;
import org.drools.traits.compiler.CommonTraitTest;
import org.drools.traits.compiler.Person;
import org.drools.traits.core.factmodel.Entity;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.Message;
import org.kie.api.definition.type.FactField;
import org.kie.api.definition.type.FactType;
import org.kie.api.definition.type.PropertyReactive;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.utils.KieHelper;

public class TraitTypeGenerationTest
extends CommonTraitTest {
    @Test(timeout=10000L)
    public void testWithDeclaredTypeAndTraitInDifferentPackages() {
        String str1 = "package org.pkg1;\ndeclare trait Trait     @propertyReactive\n    a : int\nend";
        String str2 = "package org.pkg2;\ndeclare Bean     @propertyReactive\n    @Traitable\n    a : int\n    b : int\nend";
        String str3 = "package org.pkg3;\nimport org.pkg1.Trait;\nimport org.pkg2.Bean;\nrule Init\nwhen\nthen\n    insert(new Bean(1, 2));\nend\nrule R\nwhen\n   $b : Bean( b == 2)then\n   Trait t = don( $b, Trait.class, true );\n   modify(t) { setA(2) };\nend";
        KieBase kbase = this.loadKnowledgeBaseFromString("package org.pkg1;\ndeclare trait Trait     @propertyReactive\n    a : int\nend", "package org.pkg2;\ndeclare Bean     @propertyReactive\n    @Traitable\n    a : int\n    b : int\nend", "package org.pkg3;\nimport org.pkg1.Trait;\nimport org.pkg2.Bean;\nrule Init\nwhen\nthen\n    insert(new Bean(1, 2));\nend\nrule R\nwhen\n   $b : Bean( b == 2)then\n   Trait t = don( $b, Trait.class, true );\n   modify(t) { setA(2) };\nend");
        KieSession ksession = kbase.newKieSession();
        ksession.fireAllRules();
    }

    @Test
    public void testWithBeanAndTraitInDifferentPackages() {
        String str1 = "package org.drools.compiler.integrationtests;\ndeclare trait Trait     @propertyReactive\n    a : int\nend";
        String str2 = "package org.drools.test;\nimport org.drools.compiler.integrationtests.Trait;\nimport " + Bean.class.getCanonicalName() + ";\nrule Init\nwhen\nthen\n    insert(new Bean(1, 2));\nend\nrule R\nwhen\n   $b : Bean( b == 2)then\n   Trait t = don( $b, Trait.class, true );\n   modify(t) { setA(2) };\nend";
        KieBase kbase = this.loadKnowledgeBaseFromString("package org.drools.compiler.integrationtests;\ndeclare trait Trait     @propertyReactive\n    a : int\nend", str2);
        KieSession ksession = kbase.newKieSession();
        ksession.fireAllRules();
    }

    @Test
    public void testIsAWith2KContainers() {
        String str = "import org.drools.traits.compiler.Person\n\nglobal java.util.List students\n\ndeclare trait Student\n    school : String\nend\n\nrule \"create student\" \n    when\n        $student : Person( age < 26, this not isA Student )\n    then\n        Student s = don( $student, Student.class );\n        s.setSchool(\"Masaryk University\");\n        update( $student );\nend\n\nrule \"found student\"\n    salience 10\n    when\n        student : Person( this isA Student )\n    then\n        students.add(student);\nend";
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem();
        kfs.write("src/main/resources/isA.drl", str);
        KieBuilder kbuilder = ks.newKieBuilder(kfs);
        kbuilder.buildAll();
        Assert.assertEquals((long)0L, (long)kbuilder.getResults().getMessages().size());
        ks.newKieContainer(kbuilder.getKieModule().getReleaseId()).getKieBase();
        KieSession ksession = ks.newKieContainer(kbuilder.getKieModule().getReleaseId()).newKieSession();
        Assert.assertNotNull((Object)ksession);
        ArrayList students = new ArrayList();
        ksession.setGlobal("students", students);
        ksession.insert((Object)new Person("tom", 20));
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)students.size());
    }

    @Test
    public void testMvelJittingWithTraitProxies() throws Exception {
        String drl = "package org.drools.test; \nimport " + FooIntf.class.getCanonicalName() + ";\nimport " + BarKlass.class.getCanonicalName() + ";\ndeclare BarKlass end \ndeclare FooIntf end \ndeclare trait ExtFoo extends FooIntf end \ndeclare Kore @Traitable safe : boolean end \nrule \"Test2\" when FooIntf( safe == true ) then end \nrule \"In1\" when $s : String() then don( new Kore( true ), ExtFoo.class ); end \nrule \"In2\" when $s : Integer() then insert( new BarKlass() ); end \n";
        KieBase kb = this.loadKnowledgeBaseFromString(drl);
        KieSession ks = kb.newKieSession();
        for (int j = 0; j < 21; ++j) {
            ks.insert((Object)("x" + j));
            ks.fireAllRules();
        }
        Thread.sleep(100L);
        ks.insert((Object)0);
        ks.fireAllRules();
    }

    @Test
    public void testNeeds() {
        String droolsSource = "package org.drools.abductive.test; \nimport " + Entity.class.getPackage().getName() + ".*;import " + Thing.class.getPackage().getName() + ".*;import " + Abducible.class.getName() + "; \nglobal java.util.List list; \ndeclare Goal \n   entity : Thing \n   property : String \n   value : Object \nend \nquery check( Thing $thing, String $prop, Object $val )    Thing( this == $thing, fields[ $prop ] == $val )    or   (      need( $thing, $prop, $val ; )      and     Thing( this == $thing, fields[ $prop ] == $val )    ) end \n query need( Thing $thing, String $prop, Object $val )    @Abductive( target=Goal.class ) \n   Thing( this == $thing, fields[ $prop ] != $val ) end \n rule HandleGoal when    $g : Goal( $m : entity, $prop : property, $val : value ) then    System.out.println( 'Satisfy ' + $g ); \n   modify ( $m ) { getFields().put( $prop, $val ); } \nend declare trait Monkey\n   position : Integer = 1 \n end \nrule Main\nwhen \nthen \n   System.out.println( 'Don MONKEY ' );    Entity e = new Entity(); \n   Monkey monkey = don( e, Monkey.class );end \nrule MoveAround when    $m : Monkey( $pos : position )    ?check( $m, \"position\", 4 ; ) then    System.out.println( 'Monkey madness' + $m );    list.add( $m.getPosition() ); end ";
        KieSession session = this.loadKnowledgeBaseFromString(droolsSource).newKieSession();
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        session.fireAllRules();
        for (Object o : session.getObjects()) {
            System.out.println(">>> " + o);
        }
        Assert.assertEquals(Arrays.asList(4), list);
    }

    @Test
    public void testRedeclareClassAsTrait() {
        String s1 = "package test; global java.util.List list; declare trait " + SomeClass.class.getCanonicalName() + " end ";
        KieHelper kh = new KieHelper();
        kh.addContent(s1, ResourceType.DRL);
        Assert.assertEquals((long)1L, (long)kh.verify().getMessages(new Message.Level[]{Message.Level.ERROR}).size());
    }

    @Test
    public void testMultipleInheritanceWithPosition1() throws Exception {
        String drl = "package org.drools.test\ndeclare trait PosTrait\n@propertyReactive\n field0 : int = 100 //@position(0)\n field1 : int = 101 //@position(1)\n field2 : int = 102 //@position(0)\nend\n\ndeclare trait MultiInhPosTrait extends PosTrait\n@propertyReactive\n mfield0 : int = 200 //@position(0)\n mfield1 : int = 201 @position(2)\nend";
        KnowledgeBuilder kBuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kBuilder.add((Resource)new ByteArrayResource(drl.getBytes()), ResourceType.DRL);
        if (kBuilder.hasErrors()) {
            System.err.println(kBuilder.getErrors());
        }
        Assert.assertFalse((boolean)kBuilder.hasErrors());
        InternalKnowledgeBase knowledgeBase = KnowledgeBaseFactory.newKnowledgeBase();
        knowledgeBase.addPackages(kBuilder.getKnowledgePackages());
        FactType sw = knowledgeBase.getFactType("org.drools.test", "MultiInhPosTrait");
        Assert.assertEquals((long)5L, (long)sw.getFields().size());
        Assert.assertEquals((Object)"field0", (Object)((FactField)sw.getFields().get(0)).getName());
        Assert.assertEquals((Object)"field1", (Object)((FactField)sw.getFields().get(1)).getName());
        Assert.assertEquals((Object)"mfield1", (Object)((FactField)sw.getFields().get(2)).getName());
        Assert.assertEquals((Object)"field2", (Object)((FactField)sw.getFields().get(3)).getName());
        Assert.assertEquals((Object)"mfield0", (Object)((FactField)sw.getFields().get(4)).getName());
    }

    @Test
    public void testMultipleInheritanceWithPosition2() throws Exception {
        String drl = "package org.drools.test\ndeclare trait PosTrait\n@propertyReactive\n field0 : int = 100 //@position(0)\n field1 : int = 101 //@position(1)\n field2 : int = 102 //@position(0)\nend\n\ndeclare trait MultiInhPosTrait extends PosTrait\n@propertyReactive\n mfield0 : int = 200 @position(0)\n mfield1 : int = 201 @position(2)\nend";
        KnowledgeBuilder kBuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kBuilder.add((Resource)new ByteArrayResource(drl.getBytes()), ResourceType.DRL);
        if (kBuilder.hasErrors()) {
            System.err.println(kBuilder.getErrors());
        }
        Assert.assertFalse((boolean)kBuilder.hasErrors());
        InternalKnowledgeBase knowledgeBase = KnowledgeBaseFactory.newKnowledgeBase();
        knowledgeBase.addPackages(kBuilder.getKnowledgePackages());
        FactType sw = knowledgeBase.getFactType("org.drools.test", "MultiInhPosTrait");
        Assert.assertEquals((long)5L, (long)sw.getFields().size());
        Assert.assertEquals((Object)"mfield0", (Object)((FactField)sw.getFields().get(0)).getName());
        Assert.assertEquals((Object)"field0", (Object)((FactField)sw.getFields().get(1)).getName());
        Assert.assertEquals((Object)"mfield1", (Object)((FactField)sw.getFields().get(2)).getName());
        Assert.assertEquals((Object)"field1", (Object)((FactField)sw.getFields().get(3)).getName());
        Assert.assertEquals((Object)"field2", (Object)((FactField)sw.getFields().get(4)).getName());
    }

    @Test
    public void testMultipleInheritanceWithPosition3() throws Exception {
        String drl = "package org.drools.test\ndeclare trait PosTrait\n@propertyReactive\n field0 : int = 100 @position(0)\n field1 : int = 101 @position(1)\n field2 : int = 102 @position(0)\nend\n\ndeclare trait MultiInhPosTrait extends PosTrait\n@propertyReactive\n mfield0 : int = 200 //@position(0)\n mfield1 : int = 201 @position(2)\nend";
        KnowledgeBuilder kBuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kBuilder.add((Resource)new ByteArrayResource(drl.getBytes()), ResourceType.DRL);
        if (kBuilder.hasErrors()) {
            System.err.println(kBuilder.getErrors());
        }
        Assert.assertFalse((boolean)kBuilder.hasErrors());
        InternalKnowledgeBase knowledgeBase = KnowledgeBaseFactory.newKnowledgeBase();
        knowledgeBase.addPackages(kBuilder.getKnowledgePackages());
        FactType sw = knowledgeBase.getFactType("org.drools.test", "MultiInhPosTrait");
        Assert.assertEquals((long)5L, (long)sw.getFields().size());
        Assert.assertEquals((Object)"field0", (Object)((FactField)sw.getFields().get(0)).getName());
        Assert.assertEquals((Object)"field2", (Object)((FactField)sw.getFields().get(1)).getName());
        Assert.assertEquals((Object)"field1", (Object)((FactField)sw.getFields().get(2)).getName());
        Assert.assertEquals((Object)"mfield1", (Object)((FactField)sw.getFields().get(3)).getName());
        Assert.assertEquals((Object)"mfield0", (Object)((FactField)sw.getFields().get(4)).getName());
    }

    @Test
    public void testMultipleInheritanceWithPosition4() throws Exception {
        String drl = "package org.drools.test\ndeclare trait PosTrait\n@propertyReactive\n field0 : int = 100 @position(1)\n field1 : int = 101 @position(0)\n field2 : int = 102 @position(0)\nend\n\ndeclare trait MultiInhPosTrait extends PosTrait\n@propertyReactive\n mfield0 : int = 200 @position(0)\n mfield1 : int = 201 @position(2)\nend";
        KnowledgeBuilder kBuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kBuilder.add((Resource)new ByteArrayResource(drl.getBytes()), ResourceType.DRL);
        if (kBuilder.hasErrors()) {
            System.err.println(kBuilder.getErrors());
        }
        Assert.assertFalse((boolean)kBuilder.hasErrors());
        InternalKnowledgeBase knowledgeBase = KnowledgeBaseFactory.newKnowledgeBase();
        knowledgeBase.addPackages(kBuilder.getKnowledgePackages());
        FactType sw = knowledgeBase.getFactType("org.drools.test", "MultiInhPosTrait");
        Assert.assertEquals((long)5L, (long)sw.getFields().size());
        Assert.assertEquals((Object)"field1", (Object)((FactField)sw.getFields().get(0)).getName());
        Assert.assertEquals((Object)"field2", (Object)((FactField)sw.getFields().get(1)).getName());
        Assert.assertEquals((Object)"mfield0", (Object)((FactField)sw.getFields().get(2)).getName());
        Assert.assertEquals((Object)"field0", (Object)((FactField)sw.getFields().get(3)).getName());
        Assert.assertEquals((Object)"mfield1", (Object)((FactField)sw.getFields().get(4)).getName());
    }

    @Test
    public void testMultipleInheritanceWithPosition5() throws Exception {
        String drl = "package org.drools.test\ndeclare trait PosTrait\n@propertyReactive\n field0 : int = 100 @position(2)\n field1 : int = 101 @position(1)\n field2 : int = 102 @position(8)\nend\n\ndeclare trait MultiInhPosTrait extends PosTrait\n@propertyReactive\n mfield0 : int = 200 @position(7)\n mfield1 : int = 201 @position(2)\nend";
        KnowledgeBuilder kBuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kBuilder.add((Resource)new ByteArrayResource(drl.getBytes()), ResourceType.DRL);
        if (kBuilder.hasErrors()) {
            System.err.println(kBuilder.getErrors());
        }
        Assert.assertFalse((boolean)kBuilder.hasErrors());
        InternalKnowledgeBase knowledgeBase = KnowledgeBaseFactory.newKnowledgeBase();
        knowledgeBase.addPackages(kBuilder.getKnowledgePackages());
        FactType sw = knowledgeBase.getFactType("org.drools.test", "MultiInhPosTrait");
        Assert.assertEquals((long)5L, (long)sw.getFields().size());
        Assert.assertEquals((Object)"field1", (Object)((FactField)sw.getFields().get(0)).getName());
        Assert.assertEquals((Object)"field0", (Object)((FactField)sw.getFields().get(1)).getName());
        Assert.assertEquals((Object)"mfield1", (Object)((FactField)sw.getFields().get(2)).getName());
        Assert.assertEquals((Object)"mfield0", (Object)((FactField)sw.getFields().get(3)).getName());
        Assert.assertEquals((Object)"field2", (Object)((FactField)sw.getFields().get(4)).getName());
    }

    @Test
    public void testMultipleInheritanceWithPosition6() throws Exception {
        String drl = "package org.drools.test\ndeclare trait PosTrait\n@propertyReactive\n field0 : int = 100 //@position(0)\n field1 : int = 101 //@position(1)\n field2 : int = 102 //@position(0)\nend\n\ndeclare trait SecPosTrait\n@propertyReactive\n field3 : int = 100 //@position(0)\n field1 : int = 101 //@position(1)\nend\n\ndeclare trait MultiInhPosTrait extends PosTrait, SecPosTrait\n@propertyReactive\n mfield0 : int = 200 //@position(0)\n mfield1 : int = 201 //@position(2)\nend";
        KnowledgeBuilder kBuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kBuilder.add((Resource)new ByteArrayResource(drl.getBytes()), ResourceType.DRL);
        if (kBuilder.hasErrors()) {
            System.err.println(kBuilder.getErrors());
        }
        Assert.assertFalse((boolean)kBuilder.hasErrors());
        InternalKnowledgeBase knowledgeBase = KnowledgeBaseFactory.newKnowledgeBase();
        knowledgeBase.addPackages(kBuilder.getKnowledgePackages());
        FactType sw = knowledgeBase.getFactType("org.drools.test", "MultiInhPosTrait");
        Assert.assertEquals((long)6L, (long)sw.getFields().size());
        Assert.assertEquals((Object)"field0", (Object)((FactField)sw.getFields().get(0)).getName());
        Assert.assertEquals((Object)"field1", (Object)((FactField)sw.getFields().get(1)).getName());
        Assert.assertEquals((Object)"field2", (Object)((FactField)sw.getFields().get(2)).getName());
        Assert.assertEquals((Object)"field3", (Object)((FactField)sw.getFields().get(3)).getName());
        Assert.assertEquals((Object)"mfield0", (Object)((FactField)sw.getFields().get(4)).getName());
        Assert.assertEquals((Object)"mfield1", (Object)((FactField)sw.getFields().get(5)).getName());
    }

    @Test
    public void testMultipleInheritanceWithPosition7() throws Exception {
        String drl = "package org.drools.test\ndeclare trait PosTrait\n@propertyReactive\n field0 : int = 100 @position(0)\n field1 : int = 101 @position(1)\n field2 : int = 102 @position(0)\nend\n\ndeclare trait SecPosTrait\n@propertyReactive\n field3 : int = 100 @position(2)\n field1 : int = 101 //@position(1)\nend\n\ndeclare trait MultiInhPosTrait extends PosTrait, SecPosTrait\n@propertyReactive\n mfield0 : int = 200 @position(0)\n mfield1 : int = 201 @position(2)\nend";
        KnowledgeBuilder kBuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kBuilder.add((Resource)new ByteArrayResource(drl.getBytes()), ResourceType.DRL);
        if (kBuilder.hasErrors()) {
            System.err.println(kBuilder.getErrors());
        }
        Assert.assertFalse((boolean)kBuilder.hasErrors());
        InternalKnowledgeBase knowledgeBase = KnowledgeBaseFactory.newKnowledgeBase();
        knowledgeBase.addPackages(kBuilder.getKnowledgePackages());
        FactType sw = knowledgeBase.getFactType("org.drools.test", "MultiInhPosTrait");
        Assert.assertEquals((long)6L, (long)sw.getFields().size());
        Assert.assertEquals((Object)"field0", (Object)((FactField)sw.getFields().get(0)).getName());
        Assert.assertEquals((Object)"field2", (Object)((FactField)sw.getFields().get(1)).getName());
        Assert.assertEquals((Object)"mfield0", (Object)((FactField)sw.getFields().get(2)).getName());
        Assert.assertEquals((Object)"field1", (Object)((FactField)sw.getFields().get(3)).getName());
        Assert.assertEquals((Object)"field3", (Object)((FactField)sw.getFields().get(4)).getName());
        Assert.assertEquals((Object)"mfield1", (Object)((FactField)sw.getFields().get(5)).getName());
    }

    public static class SomeClass {
    }

    public static class BarKlass
    implements FooIntf {
        @Override
        public boolean isSafe() {
            return true;
        }

        @Override
        public void setSafe(boolean safe) {
        }
    }

    public static interface FooIntf {
        public boolean isSafe();

        public void setSafe(boolean var1);
    }

    @PropertyReactive
    @Traitable
    public static class Bean {
        private int a;
        private int b;

        public Bean() {
        }

        public Bean(int a, int b) {
            this.a = a;
            this.b = b;
        }

        public int getA() {
            return this.a;
        }

        public void setA(int a) {
            this.a = a;
        }

        public int getB() {
            return this.b;
        }

        public void setB(int b) {
            this.b = b;
        }
    }
}

