/*
 * Decompiled with CFR 0.152.
 */
package org.drools.traits.core.factmodel;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.drools.core.factmodel.ClassDefinition;
import org.drools.core.factmodel.FieldDefinition;
import org.drools.core.factmodel.traits.CoreWrapper;
import org.drools.core.factmodel.traits.Thing;
import org.drools.core.factmodel.traits.Trait;
import org.drools.core.factmodel.traits.TraitableBean;
import org.drools.core.rule.TypeDeclaration;
import org.drools.core.util.ClassUtils;
import org.drools.traits.core.factmodel.Entity;
import org.drools.traits.core.factmodel.HierarchyEncoder;
import org.drools.traits.core.factmodel.LogicalMapCore;
import org.drools.traits.core.factmodel.MapCore;
import org.drools.traits.core.factmodel.TraitRegistry;
import org.drools.traits.core.util.HierNode;
import org.drools.traits.core.util.HierarchyEncoderImpl;
import org.kie.api.definition.type.FactField;

public class TraitRegistryImpl
implements Externalizable,
TraitRegistry {
    private Map<String, ClassDefinition> traits;
    private Map<String, ClassDefinition> traitables;
    private Map<String, Set<String>> staticTraitTypes;
    private int codeSize = 0;
    private Map<String, BitSet> masks;
    private HierarchyEncoder<String> hierarchy;

    public TraitRegistryImpl() {
        this.init();
    }

    private void init() {
        TypeDeclaration thingType = new TypeDeclaration(Thing.class.getName());
        thingType.setKind(TypeDeclaration.Kind.TRAIT);
        thingType.setTypeClass(Thing.class);
        ClassDefinition def = new ClassDefinition();
        def.setClassName(thingType.getTypeClass().getName());
        def.setDefinedClass(Thing.class);
        this.addTrait(def);
        ClassDefinition individualDef = new ClassDefinition();
        individualDef.setClassName(Entity.class.getName());
        individualDef.setDefinedClass(Entity.class);
        individualDef.setInterfaces(new String[]{Serializable.class.getName(), TraitableBean.class.getName()});
        individualDef.setTraitable(true);
        this.addTraitable(individualDef);
        ClassDefinition mapcoreDef = new ClassDefinition();
        mapcoreDef.setClassName(MapCore.class.getName());
        mapcoreDef.setDefinedClass(MapCore.class);
        mapcoreDef.setInterfaces(new String[]{Serializable.class.getName(), TraitableBean.class.getName(), CoreWrapper.class.getName()});
        mapcoreDef.setTraitable(true);
        this.addTraitable(mapcoreDef);
        ClassDefinition logicalMapcoreDef = new ClassDefinition();
        logicalMapcoreDef.setClassName(LogicalMapCore.class.getName());
        logicalMapcoreDef.setDefinedClass(LogicalMapCore.class);
        logicalMapcoreDef.setInterfaces(new String[]{Serializable.class.getName(), TraitableBean.class.getName(), CoreWrapper.class.getName()});
        logicalMapcoreDef.setTraitable(true, true);
        this.addTraitable(logicalMapcoreDef);
    }

    @Override
    public void merge(TraitRegistry otherRegistry) {
        TraitRegistryImpl other = (TraitRegistryImpl)otherRegistry;
        if (this.staticTraitTypes == null && other.staticTraitTypes != null) {
            this.staticTraitTypes = new HashMap<String, Set<String>>();
            this.staticTraitTypes.putAll(other.staticTraitTypes);
        }
        if (this.traits == null) {
            this.traits = new HashMap<String, ClassDefinition>();
        }
        if (other.traits != null) {
            this.traits.putAll(other.traits);
        }
        if (this.traitables == null) {
            this.traitables = new HashMap<String, ClassDefinition>();
        }
        if (other.traitables != null) {
            this.traitables.putAll(other.traitables);
        }
        if (this.masks == null) {
            this.masks = new HashMap<String, BitSet>();
        }
        if (other.masks != null) {
            this.masks.putAll(other.masks);
        }
        if (this.hierarchy == null || this.hierarchy.size() <= 1) {
            this.hierarchy = other.hierarchy;
        } else if (other.traits != null) {
            this.hierarchy = TraitRegistryImpl.mergeHierarchy(other, this);
        }
    }

    private static HierarchyEncoder<String> mergeHierarchy(TraitRegistryImpl first, TraitRegistryImpl second) {
        for (String traitName : second.getHierarchy().getSortedMembers()) {
            ClassDefinition trait = second.traits.get(traitName);
            ArrayList<String> parentTraits = new ArrayList<String>();
            for (String candidateIntf : trait.getInterfaces()) {
                if (first.getHierarchy().getCode(candidateIntf) == null) continue;
                parentTraits.add(candidateIntf);
            }
            first.getHierarchy().encode(traitName, parentTraits);
        }
        return first.getHierarchy();
    }

    public Map<String, ClassDefinition> getTraits() {
        return this.traits;
    }

    protected ClassDefinition getTrait(String key) {
        ClassDefinition traitDef;
        if (key.endsWith("_Trait__Extension")) {
            key = key.replace("_Trait__Extension", "");
        }
        ClassDefinition classDefinition = traitDef = this.traits != null ? this.traits.get(key) : null;
        if (traitDef == null) {
            // empty if block
        }
        return traitDef;
    }

    public Map<String, ClassDefinition> getTraitables() {
        return this.traitables;
    }

    protected ClassDefinition getTraitable(String key) {
        return this.traitables != null ? this.traitables.get(key) : null;
    }

    public void addTrait(ClassDefinition trait) {
        this.addTrait(trait.getClassName(), trait);
    }

    public void addTrait(String className, ClassDefinition trait) {
        if (this.traits == null) {
            this.traits = new HashMap<String, ClassDefinition>();
        }
        this.traits.put(className, trait);
        this.getHierarchy().encode(className, this.getTraitInterfaces(trait));
    }

    private Collection<String> getTraitInterfaces(ClassDefinition trait) {
        ArrayList<String> intfs = new ArrayList<String>();
        for (String s : trait.getInterfaces()) {
            if (!this.traits.containsKey(s)) continue;
            intfs.add(s);
        }
        return intfs;
    }

    public void addTraitable(ClassDefinition traitable) {
        if (this.traitables == null) {
            this.traitables = new HashMap<String, ClassDefinition>();
        }
        this.traitables.put(traitable.getClassName(), traitable);
        Set<String> staticTraits = this.detectStaticallyImplementedTraits(traitable);
        if (!staticTraits.isEmpty()) {
            if (this.staticTraitTypes == null) {
                this.staticTraitTypes = new HashMap<String, Set<String>>();
            }
            this.staticTraitTypes.put(traitable.getClassName(), staticTraits);
        }
    }

    public static boolean isSoftField(FieldDefinition field, int index, BitSet mask) {
        return !mask.get(index);
    }

    public BitSet getFieldMask(String trait, String traitable) {
        if (this.masks == null) {
            this.masks = new HashMap<String, BitSet>();
        }
        String key = trait + traitable;
        return this.masks.computeIfAbsent(key, k -> this.bind(trait, traitable));
    }

    private BitSet bind(String trait, String traitable) throws UnsupportedOperationException {
        ClassDefinition traitDef = this.getTrait(trait);
        if (traitDef == null) {
            throw new UnsupportedOperationException(" Unable to apply trait " + trait + " to class " + traitable + " : not a trait ");
        }
        ClassDefinition traitableDef = this.getTraitable(traitable);
        if (traitableDef == null) {
            throw new UnsupportedOperationException(" Unable to apply trait " + trait + " to class " + traitable + " : not a traitable ");
        }
        int j = 0;
        BitSet bitmask = new BitSet(traitDef.getFields().size());
        for (FactField field : traitDef.getFields()) {
            String alias = ((FieldDefinition)field).resolveAlias();
            FieldDefinition concreteField = traitableDef.getFieldByAlias(alias);
            if (concreteField != null) {
                if (!traitableDef.isFullTraiting() && !concreteField.getType().isAssignableFrom(field.getType())) {
                    throw new UnsupportedOperationException(" Unable to apply trait " + trait + " to class " + traitable + " : trait field " + field.getName() + ":" + ((FieldDefinition)field).getTypeName() + " is incompatible with concrete hard field " + concreteField.getName() + ":" + concreteField.getTypeName() + ". Consider enabling logical traiting mode using @Traitable( logical = true )");
                }
                bitmask.set(j);
            }
            ++j;
        }
        return bitmask;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.traits);
        objectOutput.writeObject(this.traitables);
        objectOutput.writeObject(this.masks);
        objectOutput.writeObject(this.hierarchy);
        objectOutput.writeInt(this.codeSize);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.traits = (Map)objectInput.readObject();
        this.traitables = (Map)objectInput.readObject();
        this.masks = (Map)objectInput.readObject();
        this.hierarchy = (HierarchyEncoderImpl)objectInput.readObject();
        this.codeSize = objectInput.readInt();
        this.init();
    }

    @Override
    public HierarchyEncoder<String> getHierarchy() {
        if (this.hierarchy == null) {
            this.hierarchy = new CachingHierarcyEncoderImpl();
        }
        return this.hierarchy;
    }

    protected Set<String> detectStaticallyImplementedTraits(ClassDefinition traitable) {
        HashSet<String> traitInterfaces = new HashSet<String>(3);
        for (Class intf : ClassUtils.getAllImplementedInterfaceNames((Class)traitable.getDefinedClass())) {
            if (!Thing.class.isAssignableFrom(intf) && intf.getAnnotation(Trait.class) == null) continue;
            traitInterfaces.add(intf.getName());
        }
        return traitInterfaces;
    }

    public BitSet getStaticTypeCode(String className) {
        if (this.staticTraitTypes != null && this.staticTraitTypes.containsKey(className)) {
            CachingHierarcyEncoderImpl cachingHierarcyEncoder = (CachingHierarcyEncoderImpl)this.hierarchy;
            if (cachingHierarcyEncoder.hasCodeForClass(className)) {
                return cachingHierarcyEncoder.getCodeForClass(className);
            }
            return cachingHierarcyEncoder.cacheAndGetCode(className, this.staticTraitTypes.get(className));
        }
        return null;
    }

    public Set<String> getStaticTypes(String name) {
        return this.staticTraitTypes.get(name);
    }

    public static class CachingHierarcyEncoderImpl
    extends HierarchyEncoderImpl<String> {
        private Map<String, BitSet> cache;

        @Override
        protected void encode(HierNode<String> node) {
            super.encode(node);
            this.invalidateCache();
        }

        private void invalidateCache() {
            if (this.cache != null) {
                this.cache.clear();
            }
        }

        public boolean hasCodeForClass(String className) {
            return this.cache != null && this.cache.containsKey(className);
        }

        public BitSet getCodeForClass(String className) {
            return this.cache.get(className);
        }

        public BitSet cacheAndGetCode(String className, Set<String> parents) {
            BitSet bitSet = new BitSet(this.getBottom().length());
            for (String parent : parents) {
                bitSet.or(this.getCode(parent));
            }
            if (this.cache == null) {
                this.cache = new HashMap<String, BitSet>();
            }
            this.cache.put(className, bitSet);
            return bitSet;
        }
    }
}

