/*
 * Decompiled with CFR 0.152.
 */
package org.drools.traits.core.reteoo;

import java.util.BitSet;
import java.util.Collection;
import org.drools.core.base.ObjectType;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.PropagationContext;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.factmodel.traits.Thing;
import org.drools.core.factmodel.traits.TraitType;
import org.drools.core.reteoo.EntryPointNode;
import org.drools.core.reteoo.ModifyPreviousTuples;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.RuntimeComponentFactory;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.util.bitmask.BitMask;
import org.drools.traits.core.base.TraitUtils;
import org.drools.traits.core.factmodel.TraitProxyImpl;
import org.drools.traits.core.factmodel.TraitTypeMapImpl;
import org.drools.traits.core.reteoo.TraitRuntimeComponentFactory;

public class TraitObjectTypeNode
extends ObjectTypeNode {
    private BitSet typeMask;

    public TraitObjectTypeNode() {
    }

    public TraitObjectTypeNode(int id, EntryPointNode source, ObjectType objectType, BuildContext context) {
        super(id, source, objectType, context);
        this.typeMask = ((TraitRuntimeComponentFactory)RuntimeComponentFactory.get()).getTraitRegistry(context.getRuleBase()).getHierarchy().getCode(objectType.getClassName());
    }

    public void propagateAssert(InternalFactHandle factHandle, PropagationContext context, ReteEvaluator reteEvaluator) {
        if (this.isAssertAllowed(factHandle)) {
            super.propagateAssert(factHandle, context, reteEvaluator);
        }
    }

    private boolean isAssertAllowed(InternalFactHandle factHandle) {
        if (factHandle.isTraiting()) {
            boolean allowed;
            TraitProxyImpl proxy = (TraitProxyImpl)factHandle.getObject();
            BitSet vetoMask = proxy.computeInsertionVetoMask();
            boolean vetoed = vetoMask != null && !this.typeMask.isEmpty() && TraitUtils.supersetOrEqualset(vetoMask, this.typeMask);
            boolean bl = allowed = !vetoed || this.sameAndNotCoveredByDescendants((TraitProxyImpl)factHandle.getObject(), this.typeMask);
            if (allowed) {
                proxy.assignOtn(this.typeMask);
            }
            return allowed;
        }
        return true;
    }

    private boolean sameAndNotCoveredByDescendants(TraitProxyImpl proxy, BitSet typeMask) {
        boolean isSameType = typeMask.equals(proxy._getTypeCode());
        if (isSameType) {
            TraitTypeMapImpl ttm = (TraitTypeMapImpl)proxy.getObject()._getTraitMap();
            Collection descs = ttm.lowerDescendants(typeMask);
            if (descs == null || descs.isEmpty()) {
                return true;
            }
            for (Thing sub : descs) {
                TraitType tt = (TraitType)sub;
                if (tt == proxy || !tt._hasTypeCode(typeMask)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean isModifyAllowed(InternalFactHandle factHandle) {
        if (factHandle.isTraiting()) {
            TraitProxyImpl proxy = (TraitProxyImpl)factHandle.getObject();
            return proxy.listAssignedOtnTypeCodes().contains(this.typeMask);
        }
        return true;
    }

    public void modifyObject(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, ReteEvaluator reteEvaluator) {
        if (!this.isModifyAllowed(factHandle)) {
            return;
        }
        this.checkDirty();
        if (factHandle.isTraiting()) {
            if (this.isModifyAllowed(factHandle)) {
                this.sink.propagateModifyObject(factHandle, modifyPreviousTuples, context.adaptModificationMaskForObjectType(this.objectType, reteEvaluator), reteEvaluator);
            }
        } else {
            this.sink.propagateModifyObject(factHandle, modifyPreviousTuples, !context.getModificationMask().isSet(0) ? context.adaptModificationMaskForObjectType(this.objectType, reteEvaluator) : context, reteEvaluator);
        }
    }

    public BitMask updateMask(BitMask mask) {
        BitMask returnMask = this.declaredMask.clone().setAll(mask);
        this.inferredMask = this.inferredMask.setAll(returnMask);
        return returnMask;
    }

    public BitSet getLocalTypeCode() {
        return this.typeMask;
    }
}

