/*
 * Decompiled with CFR 0.152.
 */
package org.drools.traits.core.meta.org;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.drools.traits.compiler.Person;
import org.drools.traits.compiler.factmodel.traits.TraitTestUtils;
import org.drools.traits.core.factmodel.AbstractTraitFactory;
import org.drools.traits.core.factmodel.Entity;
import org.drools.traits.core.meta.org.test.AnotherKlass;
import org.drools.traits.core.meta.org.test.AnotherKlassImpl;
import org.drools.traits.core.meta.org.test.AnotherKlass_;
import org.drools.traits.core.meta.org.test.Klass;
import org.drools.traits.core.meta.org.test.KlassImpl;
import org.drools.traits.core.meta.org.test.Klass_;
import org.drools.traits.core.meta.org.test.SubKlass;
import org.drools.traits.core.meta.org.test.SubKlassImpl;
import org.drools.traits.core.meta.org.test.SubKlass_;
import org.drools.traits.core.metadata.Identifiable;
import org.drools.traits.core.metadata.Lit;
import org.drools.traits.core.metadata.MetadataContainer;
import org.drools.traits.core.metadata.With;
import org.junit.Test;

public class MetadataTest {
    @Test
    public void testKlassAndSubKlassWithImpl() {
        SubKlassImpl ski = new SubKlassImpl();
        ski.setSubProp(42);
        ski.setProp("hello");
        SubKlass_<SubKlassImpl> sk = new SubKlass_<SubKlassImpl>(ski);
        Assertions.assertThat((int)((Integer)SubKlass_.subProp.get((Object)ski))).isEqualTo(42);
        Assertions.assertThat((String)((String)SubKlass_.prop.get((Object)ski))).isEqualTo("hello");
        ((SubKlass_.SubKlass_Modify)((SubKlass_.SubKlass_Modify)sk.modify(new With[0])).prop("bye")).subProp(-99).call();
        Assertions.assertThat((int)((Integer)SubKlass_.subProp.get((Object)ski))).isEqualTo(-99);
        Assertions.assertThat((String)((String)SubKlass_.prop.get((Object)ski))).isEqualTo("bye");
    }

    @Test
    public void testKlassAndSubKlassWithHolderImpl() {
        SubKlassImpl ski = new SubKlassImpl();
        ski.setSubProp(42);
        ski.setProp("hello");
        SubKlass_ sk = ski.get_();
        Assertions.assertThat((int)((Integer)SubKlass_.subProp.get((Object)ski))).isEqualTo(42);
        Assertions.assertThat((String)((String)SubKlass_.prop.get((Object)ski))).isEqualTo("hello");
        ((SubKlass_.SubKlass_Modify)((SubKlass_.SubKlass_Modify)sk.modify(new With[0])).prop("bye")).subProp(-99).call();
        Assertions.assertThat((int)((Integer)SubKlass_.subProp.get((Object)ski))).isEqualTo(-99);
        Assertions.assertThat((String)((String)SubKlass_.prop.get((Object)ski))).isEqualTo("bye");
    }

    @Test
    public void testKlassAndSubKlassWithInterfaces() {
        Foo ski = new Foo();
        ski.setSubProp(42);
        ski.setProp("hello");
        SubKlass_<Foo> sk = new SubKlass_<Foo>(ski);
        Assertions.assertThat((int)((Integer)SubKlass_.subProp.get((Object)ski))).isEqualTo(42);
        Assertions.assertThat((String)((String)SubKlass_.prop.get((Object)ski))).isEqualTo("hello");
        ((SubKlass_.SubKlass_Modify)sk.modify(new With[0])).subProp(-99).prop("bye").call();
        Assertions.assertThat((int)((Integer)SubKlass_.subProp.get((Object)ski))).isEqualTo(-99);
        Assertions.assertThat((String)((String)SubKlass_.prop.get((Object)ski))).isEqualTo("bye");
        System.out.println(ski.map);
        HashMap<String, Object> tgt = new HashMap<String, Object>();
        tgt.put("prop", "bye");
        tgt.put("subProp", -99);
        Assertions.assertThat(ski.map).isEqualTo(tgt);
    }

    @Test
    public void testMetaPropertiesWithManyKlasses() {
        Foo ski = new Foo();
        ski.setSubProp(42);
        ski.setProp("hello");
        SubKlass_<Foo> sk = new SubKlass_<Foo>(ski);
        AnotherKlassImpl aki = new AnotherKlassImpl();
        aki.setNum(1);
        AnotherKlass_<AnotherKlassImpl> ak = new AnotherKlass_<AnotherKlassImpl>(aki);
        ((SubKlass_.SubKlass_Modify)sk.modify(new With[0])).subProp(-99).prop("bye").call();
        ak.modify(new With[0]).num(-5).call();
        Assertions.assertThat((int)aki.getNum()).isEqualTo(-5);
        Assertions.assertThat((int)ski.getSubProp()).isEqualTo(-99);
    }

    @Test
    public void testMetadataInternals() {
        SubKlass_<SubKlassImpl> sk = new SubKlass_<SubKlassImpl>(new SubKlassImpl());
        Klass_<KlassImpl> k = new Klass_<KlassImpl>(new KlassImpl());
        AnotherKlass_<AnotherKlassImpl> ak = new AnotherKlass_<AnotherKlassImpl>(new AnotherKlassImpl());
        Assertions.assertThat((int)ak.getMetaClassInfo().getProperties().length).isEqualTo(4);
        Assertions.assertThat((int)sk.getMetaClassInfo().getProperties().length).isEqualTo(4);
        Assertions.assertThat((int)k.getMetaClassInfo().getProperties().length).isEqualTo(4);
        Assertions.assertThat((String)sk.getMetaClassInfo().getProperties()[2].getName()).isEqualTo("subProp");
    }

    @Test
    public void testMetadataModifyStyle() {
        SubKlassImpl ski = new SubKlassImpl();
        ((SubKlass_.SubKlass_Modify)SubKlass_.modify(ski, new With[0]).prop("hello")).subProp(42).call();
        Assertions.assertThat((String)ski.getProp()).isEqualTo("hello");
        Assertions.assertThat((int)ski.getSubProp()).isEqualTo(42);
    }

    @Test
    public void testModificationMask() {
        SubKlassImpl ski = new SubKlassImpl();
        SubKlass_.SubKlass_Modify task = ((SubKlass_.SubKlass_Modify)SubKlass_.modify(ski, new With[0]).prop("hello")).subProp(42);
        task.call();
        Assertions.assertThat((String)task.getModificationMask().toString()).isEqualTo("288");
        Klass_.Klass_Modify task2 = SubKlass_.modify(ski, new With[0]).prop("hello");
        task2.call();
        Assertions.assertThat((String)task2.getModificationMask().toString()).isEqualTo("32");
        SubKlass_.SubKlass_Modify<SubKlass> task3 = SubKlass_.modify(ski, new With[0]).subProp(42);
        task3.call();
        Assertions.assertThat((String)task3.getModificationMask().toString()).isEqualTo("256");
    }

    @Test
    public void testURIs() {
        AnotherKlassImpl aki = new AnotherKlassImpl();
        Assertions.assertThat((URI)aki.get_().getMetaClassInfo().getUri()).isEqualTo((Object)URI.create("http://www.test.org#AnotherKlass"));
        aki.get_();
        Assertions.assertThat((URI)AnotherKlass_.num.getUri()).isEqualTo((Object)URI.create("http://www.test.org#AnotherKlass?num"));
        URI uri = AnotherKlass_.getIdentifier((Object)aki);
        Assertions.assertThat((URI)uri).isEqualTo((Object)URI.create("http://www.test.org#AnotherKlass/AnotherKlassImpl/" + System.identityHashCode(aki)));
        Assertions.assertThat((URI)AnotherKlass_.modify(aki, new With[0]).num(33).getUri()).isEqualTo((Object)URI.create(uri.toString() + "/modify?num"));
        Assertions.assertThat((boolean)uri.toString().startsWith(aki.get_().getMetaClassInfo().getUri().toString())).isTrue();
        Assertions.assertThat((URI)SubKlass_.newSubKlass(URI.create("http://www.test.org#SubKlass/123"), new With[0]).getUri()).isEqualTo((Object)URI.create("http://www.test.org#SubKlass/123?create"));
        aki.get_();
        Assertions.assertThat((URI)AnotherKlass_.donAnotherKlass(new Foo(), new With[0]).getUri()).isEqualTo((Object)URI.create("123?don=org.drools.traits.core.meta.org.test.AnotherKlass"));
    }

    @Test
    public void testNewInstance() {
        Klass klass = (Klass)Klass_.newKlass(URI.create("test"), new With[0]).call();
        Assertions.assertThat((Object)klass).isNotNull();
        Assertions.assertThat((boolean)(klass instanceof KlassImpl)).isTrue();
        SubKlass klass2 = (SubKlass)SubKlass_.newSubKlass(URI.create("test2"), new With[0]).subProp(42).prop("hello").call();
        Assertions.assertThat((String)klass2.getProp()).isEqualTo("hello");
        Assertions.assertThat((int)klass2.getSubProp()).isEqualTo(42);
    }

    @Test
    public void testURIsOnLegacyClasses() {
        Person p = new Person();
        URI uri = MetadataContainer.getIdentifier((Object)p);
        Assertions.assertThat((URI)uri).isEqualTo((Object)URI.create("urn:" + p.getClass().getPackage().getName() + "/" + p.getClass().getSimpleName() + "/" + System.identityHashCode(p)));
    }

    @Test
    public void testDon() {
        Entity entity = new Entity("123");
        entity._setDynamicProperties(new HashMap());
        entity._getDynamicProperties().put("prop", "hello");
        Klass klass = (Klass)Klass_.donKlass(entity, new With[0]).setTraitFactory((AbstractTraitFactory)TraitTestUtils.createStandaloneTraitFactory()).call();
        Assertions.assertThat((String)klass.getProp()).isEqualTo("hello");
    }

    @Test
    public void testDonWithAttributes() {
        Entity entity = new Entity("123");
        entity._setDynamicProperties(new HashMap());
        SubKlass klass = (SubKlass)((SubKlass_.SubKlass_Don)((SubKlass_.SubKlass_Don)SubKlass_.donSubKlass(entity, new With[0]).setTraitFactory((AbstractTraitFactory)TraitTestUtils.createStandaloneTraitFactory())).prop("hello")).subProp(32).call();
        Assertions.assertThat((String)klass.getProp()).isEqualTo("hello");
        Assertions.assertThat((int)klass.getSubProp()).isEqualTo(32);
    }

    @Test
    public void testInitWithModifyArgs() {
        AnotherKlass aki = (AnotherKlass)AnotherKlass_.newAnotherKlass("000", new With[0]).call();
        SubKlass ski = (SubKlass)((SubKlass_.SubKlass_NewInstance)SubKlass_.newSubKlass(URI.create("123"), With.with((Object[])new Object[]{aki})).prop("hello")).subProp(42).another(aki).call();
        Klass ki = (Klass)Klass_.newKlass("1421", new With[0]).call();
        Assertions.assertThat((String)ski.getProp()).isEqualTo("hello");
        Assertions.assertThat((int)ski.getSubProp()).isEqualTo(42);
        Assertions.assertThat((Object)ski.getAnother()).isEqualTo((Object)aki);
    }

    @Test
    public void testCollectionOrientedProperties() {
        AnotherKlass aki0 = (AnotherKlass)AnotherKlass_.newAnotherKlass("000", new With[0]).call();
        AnotherKlass aki1 = (AnotherKlass)AnotherKlass_.newAnotherKlass("001", new With[0]).call();
        AnotherKlass aki2 = (AnotherKlass)AnotherKlass_.newAnotherKlass("002", new With[0]).call();
        AnotherKlass aki3 = (AnotherKlass)AnotherKlass_.newAnotherKlass("003", new With[0]).call();
        AnotherKlass aki4 = (AnotherKlass)AnotherKlass_.newAnotherKlass("004", new With[0]).call();
        ArrayList<AnotherKlass> initial = new ArrayList<AnotherKlass>(Arrays.asList(aki0, aki1));
        SubKlass ski = (SubKlass)SubKlass_.newSubKlass(URI.create("123"), new With[0]).links(initial, Lit.SET).links(aki1, Lit.REMOVE).links(aki2, Lit.ADD).links(Arrays.asList(aki3, aki4), Lit.REMOVE).call();
        Assertions.assertThat(ski.getLinks()).isEqualTo(Arrays.asList(aki0, aki2));
    }

    @Test
    public void testOneToOneProperty() {
        AnotherKlass aki0 = (AnotherKlass)AnotherKlass_.newAnotherKlass("000", new With[0]).call();
        Klass klass = (Klass)Klass_.newKlass("001", new With[0]).call();
        Klass_.modify(klass, With.with((Object[])new Object[]{aki0})).another(aki0).call();
        Assertions.assertThat((Object)aki0).isSameAs((Object)klass.getAnother());
        Assertions.assertThat((Object)aki0.getTheKlass()).isSameAs((Object)klass);
        Klass klass1 = (Klass)Klass_.newKlass("002", new With[0]).call();
        AnotherKlass_.modify(aki0, new With[0]).theKlass(klass1).call();
        Assertions.assertThat((Object)klass1.getAnother()).isSameAs((Object)aki0);
        Assertions.assertThat((Object)aki0.getTheKlass()).isSameAs((Object)klass1);
        Klass_.modify(klass, new With[0]).another(null).call();
        Assertions.assertThat((Object)klass.getAnother()).isNull();
        Assertions.assertThat((Object)aki0.getTheKlass()).isNull();
    }

    @Test
    public void testOneToManyProperty() {
        AnotherKlass aki = (AnotherKlass)AnotherKlass_.newAnotherKlass("000", new With[0]).call();
        AnotherKlass aki2 = (AnotherKlass)AnotherKlass_.newAnotherKlass("999", new With[0]).call();
        Klass klass1 = (Klass)Klass_.newKlass("001", new With[0]).call();
        Klass klass2 = (Klass)Klass_.newKlass("002", new With[0]).call();
        AnotherKlass_.modify(aki, With.with((Object[])new Object[]{klass1, klass2})).manyKlasses(new ArrayList<Klass>(Arrays.asList(klass1, klass2)), Lit.SET).call();
        Assertions.assertThat((Object)klass1.getOneAnother()).isSameAs((Object)aki);
        Assertions.assertThat((Object)klass2.getOneAnother()).isSameAs((Object)aki);
        AnotherKlass_.modify(aki2, new With[0]).manyKlasses(klass1, Lit.ADD).call();
        Assertions.assertThat((Object)klass1.getOneAnother()).isSameAs((Object)aki2);
        Assertions.assertThat((Object)klass2.getOneAnother()).isSameAs((Object)aki);
        Assertions.assertThat((boolean)aki.getManyKlasses().contains(klass1)).isFalse();
        Assertions.assertThat((boolean)aki2.getManyKlasses().contains(klass1)).isTrue();
        Assertions.assertThat((boolean)aki.getManyKlasses().contains(klass2)).isTrue();
        AnotherKlass_.modify(aki2, new With[0]).manyKlasses(klass1, Lit.REMOVE).call();
        Assertions.assertThat((Object)klass1.getOneAnother()).isNull();
        Assertions.assertThat((boolean)aki2.getManyKlasses().contains(klass1)).isFalse();
    }

    @Test
    public void testManyToOneProperty() {
        AnotherKlass aki = (AnotherKlass)AnotherKlass_.newAnotherKlass("000", new With[0]).call();
        AnotherKlass aki2 = (AnotherKlass)AnotherKlass_.newAnotherKlass("999", new With[0]).call();
        Klass klass1 = (Klass)Klass_.newKlass("001", new With[0]).call();
        Klass klass2 = (Klass)Klass_.newKlass("002", new With[0]).call();
        Klass_.modify(klass1, new With[0]).oneAnother(aki).call();
        Klass_.modify(klass2, new With[0]).oneAnother(aki).call();
        Assertions.assertThat((Object)klass1.getOneAnother()).isSameAs((Object)aki);
        Assertions.assertThat((Object)klass2.getOneAnother()).isSameAs((Object)aki);
        Assertions.assertThat(aki.getManyKlasses()).isEqualTo(Arrays.asList(klass1, klass2));
        Klass_.modify(klass1, new With[0]).oneAnother(aki2).call();
        Assertions.assertThat((Object)klass1.getOneAnother()).isSameAs((Object)aki2);
        Assertions.assertThat(aki2.getManyKlasses()).isEqualTo(List.of(klass1));
        Assertions.assertThat(aki.getManyKlasses()).isEqualTo(List.of(klass2));
    }

    @Test
    public void testManyToManyProperty() {
        AnotherKlass aki1 = (AnotherKlass)AnotherKlass_.newAnotherKlass("000", new With[0]).call();
        AnotherKlass aki2 = (AnotherKlass)AnotherKlass_.newAnotherKlass("999", new With[0]).call();
        Klass klass1 = (Klass)Klass_.newKlass("001", new With[0]).call();
        Klass klass2 = (Klass)Klass_.newKlass("002", new With[0]).call();
        Klass_.modify(klass1, new With[0]).manyOthers(aki1, Lit.ADD).call();
        Klass_.modify(klass1, new With[0]).manyOthers(aki2, Lit.ADD).call();
        AnotherKlass_.modify(aki2, new With[0]).manyMoreKlasses(klass2, Lit.ADD).call();
        AnotherKlass_.modify(aki1, new With[0]).manyMoreKlasses(klass2, Lit.ADD).call();
        Assertions.assertThat((boolean)klass1.getManyAnothers().contains(aki1)).isTrue();
        Assertions.assertThat((boolean)klass1.getManyAnothers().contains(aki2)).isTrue();
        Assertions.assertThat((boolean)klass2.getManyAnothers().contains(aki1)).isTrue();
        Assertions.assertThat((boolean)klass2.getManyAnothers().contains(aki2)).isTrue();
        Assertions.assertThat((boolean)aki1.getManyMoreKlasses().contains(klass1)).isTrue();
        Assertions.assertThat((boolean)aki1.getManyMoreKlasses().contains(klass2)).isTrue();
        Assertions.assertThat((boolean)aki2.getManyMoreKlasses().contains(klass1)).isTrue();
        Assertions.assertThat((boolean)aki2.getManyMoreKlasses().contains(klass2)).isTrue();
        AnotherKlass_.modify(aki2, new With[0]).manyMoreKlasses(klass2, Lit.REMOVE).call();
        Assertions.assertThat((boolean)klass1.getManyAnothers().contains(aki1)).isTrue();
        Assertions.assertThat((boolean)klass1.getManyAnothers().contains(aki2)).isTrue();
        Assertions.assertThat((boolean)klass2.getManyAnothers().contains(aki1)).isTrue();
        Assertions.assertThat((boolean)klass2.getManyAnothers().contains(aki2)).isFalse();
        Assertions.assertThat((boolean)aki1.getManyMoreKlasses().contains(klass1)).isTrue();
        Assertions.assertThat((boolean)aki1.getManyMoreKlasses().contains(klass2)).isTrue();
        Assertions.assertThat((boolean)aki2.getManyMoreKlasses().contains(klass1)).isTrue();
        Assertions.assertThat((boolean)aki2.getManyMoreKlasses().contains(klass2)).isFalse();
        AnotherKlass_.modify(aki2, new With[0]).manyMoreKlasses(klass2, Lit.ADD).call();
        Assertions.assertThat((boolean)klass1.getManyAnothers().contains(aki1)).isTrue();
        Assertions.assertThat((boolean)klass1.getManyAnothers().contains(aki2)).isTrue();
        Assertions.assertThat((boolean)klass2.getManyAnothers().contains(aki1)).isTrue();
        Assertions.assertThat((boolean)klass2.getManyAnothers().contains(aki2)).isTrue();
        Assertions.assertThat((boolean)aki1.getManyMoreKlasses().contains(klass1)).isTrue();
        Assertions.assertThat((boolean)aki1.getManyMoreKlasses().contains(klass2)).isTrue();
        Assertions.assertThat((boolean)aki2.getManyMoreKlasses().contains(klass1)).isTrue();
        Assertions.assertThat((boolean)aki2.getManyMoreKlasses().contains(klass2)).isTrue();
        AnotherKlass_.modify(aki2, new With[0]).manyMoreKlasses(klass2, Lit.SET).call();
        Assertions.assertThat((boolean)klass1.getManyAnothers().contains(aki1)).isTrue();
        Assertions.assertThat((boolean)klass1.getManyAnothers().contains(aki2)).isFalse();
        Assertions.assertThat((boolean)klass2.getManyAnothers().contains(aki1)).isTrue();
        Assertions.assertThat((boolean)klass2.getManyAnothers().contains(aki2)).isTrue();
        Assertions.assertThat((boolean)aki1.getManyMoreKlasses().contains(klass1)).isTrue();
        Assertions.assertThat((boolean)aki1.getManyMoreKlasses().contains(klass2)).isTrue();
        Assertions.assertThat((boolean)aki2.getManyMoreKlasses().contains(klass1)).isFalse();
        Assertions.assertThat((boolean)aki2.getManyMoreKlasses().contains(klass2)).isTrue();
    }

    public static class Foo
    implements SubKlass,
    Identifiable {
        private URI uri;
        public Map<String, Object> map = new HashMap<String, Object>();

        public Foo() {
            this("123");
        }

        public Foo(String uri) {
            this.uri = URI.create(uri);
        }

        @Override
        public String getProp() {
            return (String)this.map.get("prop");
        }

        @Override
        public void setProp(String value) {
            this.map.put("prop", value);
        }

        @Override
        public AnotherKlass getAnother() {
            return (AnotherKlass)this.map.get("another");
        }

        @Override
        public void setAnother(AnotherKlass another) {
            this.map.put("another", another);
        }

        @Override
        public AnotherKlass getOneAnother() {
            return null;
        }

        @Override
        public void setOneAnother(AnotherKlass another) {
        }

        @Override
        public List<AnotherKlass> getManyAnothers() {
            return null;
        }

        @Override
        public void setManyAnothers(List<AnotherKlass> anothers) {
        }

        @Override
        public Integer getSubProp() {
            return (Integer)this.map.get("subProp");
        }

        @Override
        public void setSubProp(Integer value) {
            this.map.put("subProp", value);
        }

        @Override
        public List<AnotherKlass> getLinks() {
            return null;
        }

        @Override
        public void setLinks(List<AnotherKlass> links) {
        }

        public URI getUri() {
            return this.uri;
        }

        public Object getId() {
            return this.uri;
        }
    }
}

