/*
 * Decompiled with CFR 0.152.
 */
package org.drools.util;

import java.net.URL;

public class JarUtils {
    private static final String SPRING_BOOT_PREFIX = "BOOT-INF/classes/";
    private static final String SPRING_BOOT_URL_PREFIX = "BOOT-INF/classes!/";
    private static final String SPRING_BOOT_URL_PREFIX_3_2 = "BOOT-INF/classes/!/";
    private static final String SPRING_BOOT_NESTED_PREFIX_BEFORE_3_2 = "!/BOOT-INF/";
    private static final String SPRING_BOOT_NESTED_PREFIX_AFTER_3_2 = "/!BOOT-INF/";

    private JarUtils() {
    }

    public static String normalizeSpringBootResourceUrlPath(String resourceUrlPath) {
        if ((resourceUrlPath = JarUtils.replaceNestedPathForSpringBoot32(resourceUrlPath)).contains(SPRING_BOOT_URL_PREFIX)) {
            return resourceUrlPath.replace(SPRING_BOOT_URL_PREFIX, SPRING_BOOT_PREFIX);
        }
        if (resourceUrlPath.contains(SPRING_BOOT_URL_PREFIX_3_2)) {
            return resourceUrlPath.replace(SPRING_BOOT_URL_PREFIX_3_2, SPRING_BOOT_PREFIX);
        }
        return resourceUrlPath;
    }

    public static String replaceNestedPathForSpringBoot32(String urlPath) {
        if (urlPath.contains(SPRING_BOOT_NESTED_PREFIX_AFTER_3_2)) {
            return urlPath.replace(SPRING_BOOT_NESTED_PREFIX_AFTER_3_2, SPRING_BOOT_NESTED_PREFIX_BEFORE_3_2);
        }
        return urlPath;
    }

    public static String getPathWithoutScheme(URL url) {
        String path = url.getPath();
        if (path.startsWith("file:")) {
            return path.substring("file:".length());
        }
        if (path.startsWith("nested:")) {
            return path.substring("nested:".length());
        }
        return path;
    }
}

