/*
 * Decompiled with CFR 0.152.
 */
package org.drools.util;

import org.drools.util.PortablePath;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class KiePathTest {
    protected final boolean isWindowsSeparator;
    protected final String fileSeparator;

    public KiePathTest(boolean isWindowsSeparator) {
        this.isWindowsSeparator = isWindowsSeparator;
        this.fileSeparator = isWindowsSeparator ? "\\" : "/";
    }

    @Parameterized.Parameters(name="{0}")
    public static Object[] params() {
        return new Object[]{true, false};
    }

    @Test
    public void testAsString() throws Exception {
        Assert.assertEquals((Object)"src", (Object)PortablePath.of((String)"src", (boolean)this.isWindowsSeparator).asString());
        Assert.assertEquals((Object)"src/test", (Object)PortablePath.of((String)("src" + this.fileSeparator + "test"), (boolean)this.isWindowsSeparator).asString());
        Assert.assertEquals((Object)"src/test", (Object)PortablePath.of((String)("src" + this.fileSeparator + "test"), (boolean)this.isWindowsSeparator).asString());
        Assert.assertEquals((Object)"src/test/folder", (Object)PortablePath.of((String)("src" + this.fileSeparator + "test" + this.fileSeparator + "folder"), (boolean)this.isWindowsSeparator).asString());
    }

    @Test
    public void testParent() throws Exception {
        Assert.assertEquals((Object)"src/test", (Object)PortablePath.of((String)("src" + this.fileSeparator + "test" + this.fileSeparator + "folder"), (boolean)this.isWindowsSeparator).getParent().asString());
        Assert.assertEquals((Object)"src", (Object)PortablePath.of((String)("src" + this.fileSeparator + "test" + this.fileSeparator + "folder"), (boolean)this.isWindowsSeparator).getParent().getParent().asString());
        Assert.assertEquals((Object)"", (Object)PortablePath.of((String)("src" + this.fileSeparator + "test" + this.fileSeparator + "folder"), (boolean)this.isWindowsSeparator).getParent().getParent().getParent().asString());
    }

    @Test
    public void testResolve() throws Exception {
        Assert.assertEquals((Object)"src/test/folder", (Object)PortablePath.of((String)("src" + this.fileSeparator + "test"), (boolean)this.isWindowsSeparator).resolve("folder").asString());
        Assert.assertEquals((Object)"src/test/folder/subfolder", (Object)PortablePath.of((String)("src" + this.fileSeparator + "test"), (boolean)this.isWindowsSeparator).resolve(PortablePath.of((String)("folder" + this.fileSeparator + "subfolder"), (boolean)this.isWindowsSeparator)).asString());
    }

    @Test
    public void testFileName() throws Exception {
        Assert.assertEquals((Object)"folder", (Object)PortablePath.of((String)("src" + this.fileSeparator + "test" + this.fileSeparator + "folder"), (boolean)this.isWindowsSeparator).getFileName());
    }
}

