/*
 * Decompiled with CFR 0.152.
 */
package org.drools.util;

import org.assertj.core.api.Assertions;
import org.drools.util.PortablePath;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class KiePathTest {
    protected final boolean isWindowsSeparator;
    protected final String fileSeparator;

    public KiePathTest(boolean isWindowsSeparator) {
        this.isWindowsSeparator = isWindowsSeparator;
        this.fileSeparator = isWindowsSeparator ? "\\" : "/";
    }

    @Parameterized.Parameters(name="{0}")
    public static Object[] params() {
        return new Object[]{true, false};
    }

    @Test
    public void testAsString() throws Exception {
        Assertions.assertThat((String)PortablePath.of((String)"src", (boolean)this.isWindowsSeparator).asString()).isEqualTo("src");
        Assertions.assertThat((String)PortablePath.of((String)("src" + this.fileSeparator + "test"), (boolean)this.isWindowsSeparator).asString()).isEqualTo("src/test");
        Assertions.assertThat((String)PortablePath.of((String)("src" + this.fileSeparator + "test"), (boolean)this.isWindowsSeparator).asString()).isEqualTo("src/test");
        Assertions.assertThat((String)PortablePath.of((String)("src" + this.fileSeparator + "test" + this.fileSeparator + "folder"), (boolean)this.isWindowsSeparator).asString()).isEqualTo("src/test/folder");
    }

    @Test
    public void testParent() throws Exception {
        Assertions.assertThat((String)PortablePath.of((String)("src" + this.fileSeparator + "test" + this.fileSeparator + "folder"), (boolean)this.isWindowsSeparator).getParent().asString()).isEqualTo("src/test");
        Assertions.assertThat((String)PortablePath.of((String)("src" + this.fileSeparator + "test" + this.fileSeparator + "folder"), (boolean)this.isWindowsSeparator).getParent().getParent().asString()).isEqualTo("src");
        Assertions.assertThat((String)PortablePath.of((String)("src" + this.fileSeparator + "test" + this.fileSeparator + "folder"), (boolean)this.isWindowsSeparator).getParent().getParent().getParent().asString()).isEqualTo("");
    }

    @Test
    public void testResolve() throws Exception {
        Assertions.assertThat((String)PortablePath.of((String)("src" + this.fileSeparator + "test"), (boolean)this.isWindowsSeparator).resolve("folder").asString()).isEqualTo("src/test/folder");
        Assertions.assertThat((String)PortablePath.of((String)("src" + this.fileSeparator + "test"), (boolean)this.isWindowsSeparator).resolve(PortablePath.of((String)("folder" + this.fileSeparator + "subfolder"), (boolean)this.isWindowsSeparator)).asString()).isEqualTo("src/test/folder/subfolder");
    }

    @Test
    public void testFileName() throws Exception {
        Assertions.assertThat((String)PortablePath.of((String)("src" + this.fileSeparator + "test" + this.fileSeparator + "folder"), (boolean)this.isWindowsSeparator).getFileName()).isEqualTo("folder");
    }
}

