/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.api.reporting;

import java.util.HashSet;
import java.util.Set;
import org.drools.verifier.api.reporting.CheckType;
import org.drools.verifier.api.reporting.Severity;

public class Issue {
    public static final Issue EMPTY = new Issue();
    private Severity severity;
    private Set<Integer> rowNumbers;
    private CheckType checkType;
    private String debugMessage;

    public Issue() {
        this.severity = null;
        this.rowNumbers = new HashSet<Integer>();
    }

    public Issue(Severity severity, CheckType checkType, Set<Integer> rowNumbers) {
        this.severity = severity;
        this.checkType = checkType;
        this.rowNumbers = rowNumbers;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public Set<Integer> getRowNumbers() {
        return this.rowNumbers;
    }

    public CheckType getCheckType() {
        return this.checkType;
    }

    public void setCheckType(CheckType checkType) {
        this.checkType = checkType;
    }

    public String getDebugMessage() {
        return this.debugMessage;
    }

    public Issue setDebugMessage(String debugMessage) {
        this.debugMessage = debugMessage;
        return this;
    }

    public void setSeverity(Severity severity) {
        this.severity = severity;
    }

    public void setRowNumbers(Set<Integer> rowNumbers) {
        this.rowNumbers = rowNumbers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Issue issue = (Issue)o;
        if (this.severity != issue.severity) {
            return false;
        }
        if (this.rowNumbers != null ? !this.rowNumbers.equals(issue.rowNumbers) : issue.rowNumbers != null) {
            return false;
        }
        if (this.checkType != issue.checkType) {
            return false;
        }
        return this.debugMessage != null ? this.debugMessage.equals(issue.debugMessage) : issue.debugMessage == null;
    }

    public int hashCode() {
        int result = this.severity != null ? ~(~this.severity.hashCode()) : 0;
        result = 31 * result + (this.rowNumbers != null ? ~(~this.rowNumbers.hashCode()) : 0);
        result = 31 * result + (this.checkType != null ? ~(~this.checkType.hashCode()) : 0);
        result = 31 * result + (this.debugMessage != null ? ~(~this.debugMessage.hashCode()) : 0);
        return ~(~result);
    }
}

