/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.consequence;

import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.drools.core.base.RuleNameMatchesAgendaFilter;
import org.drools.verifier.TestBaseOld;
import org.drools.verifier.data.VerifierReport;
import org.drools.verifier.data.VerifierReportFactory;
import org.drools.verifier.report.components.Severity;
import org.drools.verifier.report.components.VerifierMessage;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.AgendaFilter;

public class ConsequenceTest
extends TestBaseOld {
    @Test
    public void testMissingConsequence() throws Exception {
        InputStream in = this.getClass().getResourceAsStream("Consequence.drl");
        KieSession session = this.getStatelessKieSession(in);
        VerifierReport result = VerifierReportFactory.newVerifierReport();
        Collection<? extends Object> testData = this.getTestData(this.getClass().getResourceAsStream("ConsequenceTest2.drl"), result.getVerifierData());
        session.setGlobal("result", (Object)result);
        for (Object object : testData) {
            session.insert(object);
        }
        session.fireAllRules((AgendaFilter)new RuleNameMatchesAgendaFilter("No action - possibly commented out"));
        Iterator iterator = result.getBySeverity(Severity.WARNING).iterator();
        HashSet hashSet = new HashSet();
        while (iterator.hasNext()) {
            Object o = iterator.next();
            if (!(o instanceof VerifierMessage)) continue;
            VerifierMessage message = (VerifierMessage)o;
            hashSet.addAll(message.getImpactedRules().values());
        }
        Assert.assertFalse((boolean)hashSet.contains("Has a consequence 1"));
        Assert.assertTrue((boolean)hashSet.remove("Missing consequence 1"));
        Assert.assertTrue((boolean)hashSet.remove("Missing consequence 2"));
        if (!hashSet.isEmpty()) {
            for (String string : hashSet) {
                Assert.fail((String)("Rule " + string + " caused an error."));
            }
        }
    }
}

