/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.report.html;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipOutputStream;
import org.drools.verifier.components.Field;
import org.drools.verifier.components.ObjectType;
import org.drools.verifier.components.VerifierComponentType;
import org.drools.verifier.components.VerifierRule;
import org.drools.verifier.data.VerifierData;
import org.drools.verifier.data.VerifierReport;
import org.drools.verifier.report.VerifierReportWriter;
import org.drools.verifier.report.components.Severity;
import org.drools.verifier.report.html.ComponentsReportVisitor;
import org.drools.verifier.report.html.ReportModeller;
import org.drools.verifier.report.html.VerifierMessagesVisitor;

public class HTMLReportWriter
extends ReportModeller
implements VerifierReportWriter {
    @Override
    public void writeReport(OutputStream out, VerifierReport result) throws IOException {
        this.zout = new ZipOutputStream(out);
        VerifierData data = result.getVerifierData();
        this.writeToFile("report/index.htm", this.formPage(".", ComponentsReportVisitor.visitObjectTypeCollection(".", data.getAll(VerifierComponentType.OBJECT_TYPE))));
        this.writeToFile("report/packages.htm", this.formPage(".", ComponentsReportVisitor.visitRulePackageCollection(".", data.getAll(VerifierComponentType.RULE_PACKAGE))));
        String ruleFolder = "report/rules";
        for (Object rule : data.getAll(VerifierComponentType.RULE)) {
            this.writeToFile(ruleFolder + "/" + ((VerifierRule)rule).getPath() + ".htm", this.formPage("..", ComponentsReportVisitor.visitRule("..", (VerifierRule)rule, data)));
        }
        String objectTypeFolder = "report/objectTypes";
        for (Object objectType : data.getAll(VerifierComponentType.OBJECT_TYPE)) {
            this.writeToFile(objectTypeFolder + "/" + ((ObjectType)objectType).getPath() + ".htm", this.formPage("..", ComponentsReportVisitor.visitObjectType("..", (ObjectType)objectType, data)));
        }
        String fieldFolder = "report/fields";
        for (Field field : data.getAll(VerifierComponentType.FIELD)) {
            this.writeToFile(fieldFolder + "/" + field.getPath() + ".htm", this.formPage("..", ComponentsReportVisitor.visitField("..", field, result)));
        }
        this.writeMessages(result);
        String cssFolder = "report/css";
        this.writeToFile(cssFolder + "/" + "basic.css", ComponentsReportVisitor.getCss("basic.css"));
        String imagesFolder = "report/images";
        this.copyFile(imagesFolder, "hdrlogo_drools50px.gif");
        this.copyFile(imagesFolder, "jbossrules_hdrbkg_blue.gif");
        this.zout.close();
    }

    private void writeMessages(VerifierReport result) throws IOException {
        VerifierData data = result.getVerifierData();
        String errors = VerifierMessagesVisitor.visitVerifierMessagesCollection(Severity.ERROR.getTuple(), result.getBySeverity(Severity.ERROR), data);
        String warnings = VerifierMessagesVisitor.visitVerifierMessagesCollection(Severity.WARNING.getTuple(), result.getBySeverity(Severity.WARNING), data);
        String notes = VerifierMessagesVisitor.visitVerifierMessagesCollection(Severity.NOTE.getTuple(), result.getBySeverity(Severity.NOTE), data);
        this.writeToFile("report/verifierMessages.htm", this.formPage(".", errors + warnings + notes));
    }
}

