/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier;

import java.util.Collection;
import java.util.HashSet;
import org.assertj.core.api.Assertions;
import org.drools.core.base.RuleNameMatchesAgendaFilter;
import org.drools.verifier.TestBaseOld;
import org.drools.verifier.data.VerifierReport;
import org.drools.verifier.data.VerifierReportFactory;
import org.drools.verifier.report.components.Gap;
import org.junit.Test;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.AgendaFilter;

public class RangeCheckDatesTest
extends TestBaseOld {
    @Test
    public void testFake() {
        Assertions.assertThat((boolean)true).isTrue();
    }

    @Test
    public void testSmallerOrEqual() throws Exception {
        KieSession session = this.getStatelessKieSession(this.getClass().getResourceAsStream("rangeChecks/Dates.drl"));
        VerifierReport result = VerifierReportFactory.newVerifierReport();
        Collection<? extends Object> testData = this.getTestData(this.getClass().getResourceAsStream("MissingRangesForDates.drl"), result.getVerifierData());
        session.setGlobal("result", (Object)result);
        for (Object object : testData) {
            session.insert(object);
        }
        session.fireAllRules((AgendaFilter)new RuleNameMatchesAgendaFilter("Range check for dates, if smaller than or equal is missing"));
        HashSet<String> rulesThatHadErrors = new HashSet<String>();
        for (Object o : session.getObjects()) {
            if (!(o instanceof Gap)) continue;
            rulesThatHadErrors.add(((Gap)o).getRuleName());
        }
        Assertions.assertThat((boolean)rulesThatHadErrors.remove("Date gap rule 4a")).isTrue();
        Assertions.assertThat((boolean)rulesThatHadErrors.remove("Date gap rule 5a")).isTrue();
        if (!rulesThatHadErrors.isEmpty()) {
            for (String string : rulesThatHadErrors) {
                Assertions.fail((String)("Rule " + string + " caused an error."));
            }
        }
    }

    @Test
    public void testGreaterOrEqual() throws Exception {
        KieSession session = this.getStatelessKieSession(this.getClass().getResourceAsStream("rangeChecks/Dates.drl"));
        VerifierReport result = VerifierReportFactory.newVerifierReport();
        Collection<? extends Object> testData = this.getTestData(this.getClass().getResourceAsStream("MissingRangesForDates.drl"), result.getVerifierData());
        session.setGlobal("result", (Object)result);
        for (Object object : testData) {
            session.insert(object);
        }
        session.fireAllRules((AgendaFilter)new RuleNameMatchesAgendaFilter("Range check for dates, if greater than or equal is missing"));
        HashSet<String> rulesThatHadErrors = new HashSet<String>();
        for (Object o : session.getObjects()) {
            if (!(o instanceof Gap)) continue;
            rulesThatHadErrors.add(((Gap)o).getRuleName());
        }
        Assertions.assertThat((boolean)rulesThatHadErrors.remove("Date gap rule 4b")).isTrue();
        Assertions.assertThat((boolean)rulesThatHadErrors.remove("Date gap rule 5b")).isTrue();
        if (!rulesThatHadErrors.isEmpty()) {
            for (String string : rulesThatHadErrors) {
                Assertions.fail((String)("Rule " + string + " caused an error."));
            }
        }
    }

    @Test
    public void testEqualAndGreaterThan() throws Exception {
        KieSession session = this.getStatelessKieSession(this.getClass().getResourceAsStream("rangeChecks/Dates.drl"));
        VerifierReport result = VerifierReportFactory.newVerifierReport();
        Collection<? extends Object> testData = this.getTestData(this.getClass().getResourceAsStream("MissingRangesForDates.drl"), result.getVerifierData());
        session.setGlobal("result", (Object)result);
        for (Object object : testData) {
            session.insert(object);
        }
        session.fireAllRules((AgendaFilter)new RuleNameMatchesAgendaFilter("Range check for dates, equal and greater than"));
        HashSet<String> rulesThatHadErrors = new HashSet<String>();
        for (Object o : session.getObjects()) {
            if (!(o instanceof Gap)) continue;
            rulesThatHadErrors.add(((Gap)o).getRuleName());
        }
        Assertions.assertThat((boolean)rulesThatHadErrors.remove("Date gap rule 1")).isTrue();
        Assertions.assertThat((boolean)rulesThatHadErrors.remove("Date gap rule 7b")).isTrue();
        Assertions.assertThat((boolean)rulesThatHadErrors.remove("Date gap rule 3")).isTrue();
        if (!rulesThatHadErrors.isEmpty()) {
            for (String string : rulesThatHadErrors) {
                Assertions.fail((String)("Rule " + string + " caused an error."));
            }
        }
    }

    @Test
    public void testEqualAndSmallerThan() throws Exception {
        KieSession session = this.getStatelessKieSession(this.getClass().getResourceAsStream("rangeChecks/Dates.drl"));
        VerifierReport result = VerifierReportFactory.newVerifierReport();
        Collection<? extends Object> testData = this.getTestData(this.getClass().getResourceAsStream("MissingRangesForDates.drl"), result.getVerifierData());
        session.setGlobal("result", (Object)result);
        for (Object object : testData) {
            session.insert(object);
        }
        session.fireAllRules((AgendaFilter)new RuleNameMatchesAgendaFilter("Range check for dates, equal and smaller than"));
        HashSet<String> rulesThatHadErrors = new HashSet<String>();
        for (Object o : session.getObjects()) {
            if (!(o instanceof Gap)) continue;
            rulesThatHadErrors.add(((Gap)o).getRuleName());
        }
        Assertions.assertThat((boolean)rulesThatHadErrors.remove("Date gap rule 1")).isTrue();
        Assertions.assertThat((boolean)rulesThatHadErrors.remove("Date gap rule 6b")).isTrue();
        Assertions.assertThat((boolean)rulesThatHadErrors.remove("Date gap rule 2")).isTrue();
        if (!rulesThatHadErrors.isEmpty()) {
            for (String string : rulesThatHadErrors) {
                Assertions.fail((String)("Rule " + string + " caused an error."));
            }
        }
    }
}

