/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier;

import java.util.Collection;
import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.drools.io.ClassPathResource;
import org.drools.verifier.Verifier;
import org.drools.verifier.VerifierConfiguration;
import org.drools.verifier.VerifierError;
import org.drools.verifier.builder.ScopesAgendaFilter;
import org.drools.verifier.builder.VerifierBuilder;
import org.drools.verifier.builder.VerifierBuilderFactory;
import org.drools.verifier.data.VerifierReport;
import org.drools.verifier.report.components.Severity;
import org.junit.Test;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;

public class VerifyingScopeTest {
    @Test
    public void testSingleRule() {
        VerifierBuilder vBuilder = VerifierBuilderFactory.newVerifierBuilder();
        VerifierConfiguration vConfiguration = vBuilder.newVerifierConfiguration();
        Assertions.assertThat((boolean)vBuilder.hasErrors()).isFalse();
        Assertions.assertThat((int)vBuilder.getErrors().size()).isEqualTo(0);
        vConfiguration.getVerifyingResources().put(new ClassPathResource("VerifyingScope.drl", Verifier.class), ResourceType.DRL);
        Verifier verifier = vBuilder.newVerifier(vConfiguration);
        verifier.addResourcesToVerify((Resource)new ClassPathResource("Misc3.drl", Verifier.class), ResourceType.DRL);
        Assertions.assertThat((boolean)verifier.hasErrors()).isFalse();
        Assertions.assertThat((int)verifier.getErrors().size()).isEqualTo(0);
        boolean works = verifier.fireAnalysis(new ScopesAgendaFilter(true, "single-rule"));
        if (!works) {
            for (VerifierError error : verifier.getErrors()) {
                System.out.println(error.getMessage());
            }
            Assertions.fail((String)"Error when building in verifier");
        }
        VerifierReport result = verifier.getResult();
        Assertions.assertThat((Object)result).isNotNull();
        Assertions.assertThat((int)result.getBySeverity(Severity.ERROR).size()).isEqualTo(0);
        Assertions.assertThat((int)result.getBySeverity(Severity.WARNING).size()).isEqualTo(0);
        Assertions.assertThat((int)result.getBySeverity(Severity.NOTE).size()).isEqualTo(6);
    }

    @Test
    public void testNothing() {
        VerifierBuilder vBuilder = VerifierBuilderFactory.newVerifierBuilder();
        VerifierConfiguration vConfiguration = vBuilder.newVerifierConfiguration();
        Assertions.assertThat((boolean)vBuilder.hasErrors()).isFalse();
        Assertions.assertThat((int)vBuilder.getErrors().size()).isEqualTo(0);
        vConfiguration.getVerifyingResources().put(new ClassPathResource("VerifyingScope.drl", Verifier.class), ResourceType.DRL);
        Verifier verifier = vBuilder.newVerifier(vConfiguration);
        verifier.addResourcesToVerify((Resource)new ClassPathResource("Misc3.drl", Verifier.class), ResourceType.DRL);
        Assertions.assertThat((boolean)verifier.hasErrors()).isFalse();
        Assertions.assertThat((int)verifier.getErrors().size()).isEqualTo(0);
        boolean works = verifier.fireAnalysis(new ScopesAgendaFilter(true, (Collection)Collections.EMPTY_LIST));
        Assertions.assertThat((boolean)works).isTrue();
        VerifierReport result = verifier.getResult();
        Assertions.assertThat((Object)result).isNotNull();
        Assertions.assertThat((int)result.getBySeverity(Severity.ERROR).size()).isEqualTo(0);
        Assertions.assertThat((int)result.getBySeverity(Severity.WARNING).size()).isEqualTo(0);
        Assertions.assertThat((int)result.getBySeverity(Severity.NOTE).size()).isEqualTo(2);
    }

    @Test
    public void testDecisionTable() {
        VerifierBuilder vBuilder = VerifierBuilderFactory.newVerifierBuilder();
        VerifierConfiguration vConfiguration = vBuilder.newVerifierConfiguration();
        Assertions.assertThat((boolean)vBuilder.hasErrors()).isFalse();
        Assertions.assertThat((int)vBuilder.getErrors().size()).isEqualTo(0);
        vConfiguration.getVerifyingResources().put(new ClassPathResource("VerifyingScope.drl", Verifier.class), ResourceType.DRL);
        Verifier verifier = vBuilder.newVerifier(vConfiguration);
        verifier.addResourcesToVerify((Resource)new ClassPathResource("Misc3.drl", Verifier.class), ResourceType.DRL);
        Assertions.assertThat((boolean)verifier.hasErrors()).isFalse();
        Assertions.assertThat((int)verifier.getErrors().size()).isEqualTo(0);
        boolean works = verifier.fireAnalysis(new ScopesAgendaFilter(false, "decision-table"));
        Assertions.assertThat((boolean)works).isTrue();
        VerifierReport result = verifier.getResult();
        Assertions.assertThat((Object)result).isNotNull();
        Assertions.assertThat((int)result.getBySeverity(Severity.ERROR).size()).isEqualTo(0);
        Assertions.assertThat((int)result.getBySeverity(Severity.WARNING).size()).isEqualTo(0);
        Assertions.assertThat((int)result.getBySeverity(Severity.NOTE).size()).isEqualTo(2);
    }
}

