/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.consequence;

import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.assertj.core.api.Assertions;
import org.drools.core.base.RuleNameMatchesAgendaFilter;
import org.drools.verifier.TestBaseOld;
import org.drools.verifier.data.VerifierReport;
import org.drools.verifier.data.VerifierReportFactory;
import org.drools.verifier.report.components.Severity;
import org.drools.verifier.report.components.VerifierMessage;
import org.junit.Test;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.AgendaFilter;

public class NamedConsequencesTest
extends TestBaseOld {
    @Test
    public void testMissingConsequence() throws Exception {
        InputStream in = this.getClass().getResourceAsStream("NamedConsequences.drl");
        KieSession session = this.getStatelessKieSession(in);
        VerifierReport result = VerifierReportFactory.newVerifierReport();
        Collection<? extends Object> testData = this.getTestData(this.getClass().getResourceAsStream("ConsequenceTest.drl"), result.getVerifierData());
        session.setGlobal("result", (Object)result);
        for (Object object : testData) {
            session.insert(object);
        }
        session.fireAllRules((AgendaFilter)new RuleNameMatchesAgendaFilter("No action - possibly commented out"));
        Iterator iter = result.getBySeverity(Severity.NOTE).iterator();
        HashSet hashSet = new HashSet();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof VerifierMessage)) continue;
            VerifierMessage message = (VerifierMessage)o;
            hashSet.addAll(message.getImpactedRules().values());
        }
        Assertions.assertThat((boolean)hashSet.contains("This one is has an unused named consequence")).isFalse();
        if (!hashSet.isEmpty()) {
            for (String string : hashSet) {
                Assertions.fail((String)("Rule " + string + " caused an error."));
            }
        }
    }
}

