/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.data;

import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.drools.drl.ast.descr.AndDescr;
import org.drools.drl.ast.descr.BaseDescr;
import org.drools.drl.ast.descr.PackageDescr;
import org.drools.verifier.VerifierComponentMockFactory;
import org.drools.verifier.components.EnumField;
import org.drools.verifier.components.EnumRestriction;
import org.drools.verifier.components.Field;
import org.drools.verifier.components.InlineEvalDescr;
import org.drools.verifier.components.LiteralRestriction;
import org.drools.verifier.components.ObjectType;
import org.drools.verifier.components.OperatorDescrType;
import org.drools.verifier.components.Pattern;
import org.drools.verifier.components.PatternEval;
import org.drools.verifier.components.PatternOperatorDescr;
import org.drools.verifier.components.PatternVariable;
import org.drools.verifier.components.QualifiedIdentifierRestriction;
import org.drools.verifier.components.Restriction;
import org.drools.verifier.components.ReturnValueFieldDescr;
import org.drools.verifier.components.ReturnValueRestriction;
import org.drools.verifier.components.RuleEval;
import org.drools.verifier.components.RuleOperatorDescr;
import org.drools.verifier.components.RulePackage;
import org.drools.verifier.components.SubPattern;
import org.drools.verifier.components.SubRule;
import org.drools.verifier.components.TextConsequence;
import org.drools.verifier.components.VariableRestriction;
import org.drools.verifier.components.VerifierAccessorDescr;
import org.drools.verifier.components.VerifierAccumulateDescr;
import org.drools.verifier.components.VerifierCollectDescr;
import org.drools.verifier.components.VerifierComponentType;
import org.drools.verifier.components.VerifierFieldAccessDescr;
import org.drools.verifier.components.VerifierFromDescr;
import org.drools.verifier.components.VerifierMethodAccessDescr;
import org.drools.verifier.components.VerifierRule;
import org.drools.verifier.data.VerifierComponent;
import org.drools.verifier.data.VerifierData;
import org.drools.verifier.data.VerifierReportFactory;
import org.junit.Test;

public class VerifierDataMapsTest {
    @Test
    public void testSaveVerifierComponentAndGet() {
        VerifierData data = VerifierReportFactory.newVerifierData();
        VerifierRule rule = VerifierComponentMockFactory.createRule1();
        rule.setName("0");
        String rulePath = rule.getPath();
        data.add((VerifierComponent)rule);
        Collection all = data.getAll();
        Assertions.assertThat((int)all.size()).isEqualTo(1);
        Assertions.assertThat((Object)all.toArray()[0]).isEqualTo((Object)rule);
        Collection rules = data.getAll(VerifierComponentType.RULE);
        Assertions.assertThat((int)rules.size()).isEqualTo(1);
        Assertions.assertThat((Object)rules.toArray()[0]).isEqualTo((Object)rule);
        VerifierRule rule2 = (VerifierRule)data.getVerifierObject(VerifierComponentType.RULE, rulePath);
        Assertions.assertThat((Comparable)rule2).isNotNull();
        Assertions.assertThat((Comparable)rule2).isEqualTo((Object)rule);
    }

    @Test
    public void testSaveVerifierComponentAndGetForAllComponentTypes() {
        RulePackage rulePackage = VerifierComponentMockFactory.createPackage1();
        this.saveVerifierComponentAndGet((VerifierComponent)rulePackage);
        VerifierRule rule = VerifierComponentMockFactory.createRule1();
        this.saveVerifierComponentAndGet((VerifierComponent)rule);
        Pattern pattern = VerifierComponentMockFactory.createPattern1();
        this.saveVerifierComponentAndGet((VerifierComponent)pattern);
        this.saveVerifierComponentAndGet((VerifierComponent)new InlineEvalDescr(pattern));
        this.saveVerifierComponentAndGet((VerifierComponent)new ObjectType((BaseDescr)new PackageDescr("testPackage1")));
        this.saveVerifierComponentAndGet((VerifierComponent)new RuleOperatorDescr((BaseDescr)new AndDescr(), rule, OperatorDescrType.AND));
        this.saveVerifierComponentAndGet((VerifierComponent)new PatternOperatorDescr(pattern, OperatorDescrType.AND));
        this.saveVerifierComponentAndGet((VerifierComponent)new SubPattern(pattern, 0));
        this.saveVerifierComponentAndGet((VerifierComponent)new ReturnValueFieldDescr(pattern));
        this.saveVerifierComponentAndGet((VerifierComponent)new SubRule(rule, 0));
        this.saveVerifierComponentAndGet((VerifierComponent)new TextConsequence(rule));
        this.saveVerifierComponentAndGet((VerifierComponent)new PatternVariable(rule));
        this.saveVerifierComponentAndGet((VerifierComponent)new VerifierAccessorDescr(rule));
        this.saveVerifierComponentAndGet((VerifierComponent)new VerifierAccumulateDescr(pattern));
        this.saveVerifierComponentAndGet((VerifierComponent)new VerifierCollectDescr(pattern));
        this.saveVerifierComponentAndGet((VerifierComponent)new RuleEval(rule));
        this.saveVerifierComponentAndGet((VerifierComponent)new VerifierFieldAccessDescr(rule));
        this.saveVerifierComponentAndGet((VerifierComponent)new VerifierFromDescr(pattern));
        this.saveVerifierComponentAndGet((VerifierComponent)new VerifierMethodAccessDescr(rule));
        this.saveVerifierComponentAndGet((VerifierComponent)new PatternEval(pattern));
    }

    @Test
    public void testSaveVerifierComponentAndGetForAllFields() {
        this.saveVerifierComponentAndGet((Field)new EnumField((BaseDescr)new PackageDescr("testPackage1")));
        this.saveVerifierComponentAndGet(new Field((BaseDescr)new PackageDescr("testPackage1")));
    }

    @Test
    public void testSaveVerifierComponentAndGetForAllRestrictions() {
        Pattern pattern = VerifierComponentMockFactory.createPattern1();
        this.saveVerifierComponentAndGet((Restriction)LiteralRestriction.createRestriction((Pattern)pattern, (String)""));
        this.saveVerifierComponentAndGet((Restriction)new EnumRestriction(pattern));
        this.saveVerifierComponentAndGet((Restriction)new QualifiedIdentifierRestriction(pattern));
        this.saveVerifierComponentAndGet((Restriction)new ReturnValueRestriction(pattern));
        this.saveVerifierComponentAndGet((Restriction)new ReturnValueRestriction(pattern));
        this.saveVerifierComponentAndGet((Restriction)new VariableRestriction(pattern));
    }

    @Test
    public void testSavePatternAndGet() {
        VerifierData data = VerifierReportFactory.newVerifierData();
        VerifierRule rule = VerifierComponentMockFactory.createRule1();
        Assertions.assertThat((String)rule.getName()).isNotNull();
        Assertions.assertThat((String)rule.getName()).isEqualTo("testRule1");
        ObjectType objectType = new ObjectType((BaseDescr)new PackageDescr("testPackage1"));
        Pattern pattern = VerifierComponentMockFactory.createPattern1();
        Assertions.assertThat((String)pattern.getRulePath()).isNotNull();
        Assertions.assertThat((String)pattern.getRulePath()).isEqualTo(rule.getPath());
        Assertions.assertThat((String)pattern.getName()).isNotNull();
        Assertions.assertThat((String)pattern.getRuleName()).isEqualTo(rule.getName());
        pattern.setObjectTypePath(objectType.getPath());
        Assertions.assertThat((String)pattern.getObjectTypePath()).isNotNull();
        Assertions.assertThat((String)pattern.getObjectTypePath()).isEqualTo(objectType.getPath());
        data.add((VerifierComponent)rule);
        data.add((VerifierComponent)objectType);
        data.add((VerifierComponent)pattern);
        Collection all = data.getAll();
        Assertions.assertThat((int)all.size()).isEqualTo(3);
        Assertions.assertThat((boolean)all.contains(pattern)).isTrue();
        Assertions.assertThat((boolean)all.contains(objectType)).isTrue();
        Assertions.assertThat((boolean)all.contains(rule)).isTrue();
        Collection components = data.getAll(pattern.getVerifierComponentType());
        Assertions.assertThat((int)components.size()).isEqualTo(1);
        Assertions.assertThat((Object)components.toArray()[0]).isEqualTo((Object)pattern);
        VerifierComponent objectType2 = data.getVerifierObject(objectType.getVerifierComponentType(), objectType.getPath());
        Assertions.assertThat((Comparable)objectType2).isNotNull();
        Assertions.assertThat((Comparable)objectType2).isEqualTo((Object)objectType);
        VerifierComponent rule2 = data.getVerifierObject(rule.getVerifierComponentType(), rule.getPath());
        Assertions.assertThat((Comparable)rule2).isNotNull();
        Assertions.assertThat((Comparable)rule2).isEqualTo((Object)rule);
    }

    private void saveVerifierComponentAndGet(Field field) {
        VerifierData data = VerifierReportFactory.newVerifierData();
        ObjectType objectType = new ObjectType((BaseDescr)new PackageDescr("testPackage1"));
        field.setObjectTypePath(objectType.getPath());
        data.add((VerifierComponent)objectType);
        data.add((VerifierComponent)field);
        Collection all = data.getAll();
        Assertions.assertThat((int)all.size()).isEqualTo(2);
        Assertions.assertThat((boolean)all.contains(objectType)).isTrue();
        Assertions.assertThat((boolean)all.contains(field)).isTrue();
        Collection fields = data.getAll(field.getVerifierComponentType());
        Assertions.assertThat((int)fields.size()).isEqualTo(1);
        Assertions.assertThat((Object)fields.toArray()[0]).isEqualTo((Object)field);
        VerifierComponent field2 = data.getVerifierObject(field.getVerifierComponentType(), field.getPath());
        Assertions.assertThat((Comparable)field2).isNotNull();
        Assertions.assertThat((Comparable)field2).isEqualTo((Object)field);
        Collection objectTypes = data.getAll(objectType.getVerifierComponentType());
        Assertions.assertThat((int)objectTypes.size()).isEqualTo(1);
        Assertions.assertThat((Object)objectTypes.toArray()[0]).isEqualTo((Object)objectType);
        VerifierComponent objectType2 = data.getVerifierObject(objectType.getVerifierComponentType(), objectType.getPath());
        Assertions.assertThat((Comparable)objectType2).isNotNull();
        Assertions.assertThat((Comparable)objectType2).isEqualTo((Object)objectType);
    }

    private void saveVerifierComponentAndGet(Restriction component) {
        VerifierData data = VerifierReportFactory.newVerifierData();
        ObjectType objectType = new ObjectType((BaseDescr)new PackageDescr("testPackage1"));
        Field field = new Field((BaseDescr)new PackageDescr("testPackage1"));
        field.setObjectTypePath(objectType.getPath());
        component.setFieldPath(field.getPath());
        Assertions.assertThat((String)component.getFieldPath()).isNotNull();
        data.add((VerifierComponent)objectType);
        data.add((VerifierComponent)field);
        data.add((VerifierComponent)component);
        Collection all = data.getAll();
        Assertions.assertThat((int)all.size()).isEqualTo(3);
        Assertions.assertThat((boolean)all.contains(objectType)).isTrue();
        Assertions.assertThat((boolean)all.contains(field)).isTrue();
        Assertions.assertThat((boolean)all.contains(component)).isTrue();
        Collection components = data.getAll(component.getVerifierComponentType());
        Assertions.assertThat((int)components.size()).isEqualTo(1);
        Assertions.assertThat((Object)components.toArray()[0]).isEqualTo((Object)component);
        VerifierComponent component2 = data.getVerifierObject(component.getVerifierComponentType(), component.getPath());
        Assertions.assertThat((Comparable)component2).isNotNull();
        Assertions.assertThat((Comparable)component2).isEqualTo((Object)component);
        Collection fields = data.getAll(field.getVerifierComponentType());
        Assertions.assertThat((int)fields.size()).isEqualTo(1);
        Assertions.assertThat((Object)fields.toArray()[0]).isEqualTo((Object)field);
        VerifierComponent field2 = data.getVerifierObject(field.getVerifierComponentType(), field.getPath());
        Assertions.assertThat((Comparable)field2).isNotNull();
        Assertions.assertThat((Comparable)field2).isEqualTo((Object)field);
        Collection objectTypes = data.getAll(objectType.getVerifierComponentType());
        Assertions.assertThat((int)objectTypes.size()).isEqualTo(1);
        Assertions.assertThat((Object)objectTypes.toArray()[0]).isEqualTo((Object)objectType);
        VerifierComponent objectType2 = data.getVerifierObject(objectType.getVerifierComponentType(), objectType.getPath());
        Assertions.assertThat((Comparable)objectType2).isNotNull();
        Assertions.assertThat((Comparable)objectType2).isEqualTo((Object)objectType);
    }

    private void saveVerifierComponentAndGet(VerifierComponent component) {
        VerifierData data = VerifierReportFactory.newVerifierData();
        data.add(component);
        Collection all = data.getAll();
        Assertions.assertThat((int)all.size()).isEqualTo(1);
        Assertions.assertThat((Object)all.toArray()[0]).isEqualTo((Object)component);
        Collection components = data.getAll(component.getVerifierComponentType());
        Assertions.assertThat((int)components.size()).isEqualTo(1);
        Assertions.assertThat((Object)components.toArray()[0]).isEqualTo((Object)component);
        VerifierComponent component2 = data.getVerifierObject(component.getVerifierComponentType(), component.getPath());
        Assertions.assertThat((Comparable)component2).isNotNull();
        Assertions.assertThat((Comparable)component2).isEqualTo((Object)component);
    }
}

