/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.equivalence;

import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.drools.verifier.Verifier;
import org.drools.verifier.builder.VerifierBuilder;
import org.drools.verifier.builder.VerifierBuilderFactory;
import org.drools.verifier.data.VerifierReport;
import org.drools.verifier.report.components.MessageType;
import org.drools.verifier.report.components.Severity;
import org.drools.verifier.report.components.VerifierMessageBase;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.api.io.ResourceType;
import org.kie.internal.io.ResourceFactory;

public class EquivalentRulesTest {
    @Test
    @Ignore(value="08-APR-2011 temporally ignoring -Rikkola-")
    public void testVerifierLiteralRestrictionRedundancy() throws Exception {
        VerifierBuilder vBuilder = VerifierBuilderFactory.newVerifierBuilder();
        Verifier verifier = vBuilder.newVerifier();
        verifier.addResourcesToVerify(ResourceFactory.newClassPathResource((String)"EquivalentRules.drl", this.getClass()), ResourceType.DRL);
        Assertions.assertThat((boolean)verifier.hasErrors()).isFalse();
        boolean noProblems = verifier.fireAnalysis();
        Assertions.assertThat((boolean)noProblems).isTrue();
        VerifierReport result = verifier.getResult();
        Collection warnings = result.getBySeverity(Severity.WARNING);
        int counter = 0;
        for (VerifierMessageBase message : warnings) {
            if (!message.getMessageType().equals(MessageType.EQUIVALANCE)) continue;
            ++counter;
        }
        Assertions.assertThat((int)counter).isEqualTo(1);
        verifier.dispose();
    }
}

