/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.incompatibility;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.drools.core.base.RuleNameMatchesAgendaFilter;
import org.drools.drl.ast.descr.BaseDescr;
import org.drools.drl.ast.descr.PackageDescr;
import org.drools.drl.parser.impl.Operator;
import org.drools.verifier.TestBaseOld;
import org.drools.verifier.VerifierComponentMockFactory;
import org.drools.verifier.components.LiteralRestriction;
import org.drools.verifier.components.ObjectType;
import org.drools.verifier.components.Pattern;
import org.drools.verifier.components.PatternVariable;
import org.drools.verifier.components.Variable;
import org.drools.verifier.components.VariableRestriction;
import org.drools.verifier.components.VerifierComponentType;
import org.drools.verifier.components.VerifierRule;
import org.drools.verifier.incompatibility.IncompatibilityBase;
import org.drools.verifier.report.components.Cause;
import org.junit.Test;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.AgendaFilter;

public class IncompatibilityRestrictionsTest
extends IncompatibilityBase {
    @Test
    public void testLiteralRestrictionsIncompatibilityLessOrEqual() throws Exception {
        KieSession session = this.getStatelessKieSession(this.getClass().getResourceAsStream("Restrictions.drl"));
        ArrayList<LiteralRestriction> data = new ArrayList<LiteralRestriction>();
        Pattern pattern1 = VerifierComponentMockFactory.createPattern1();
        Pattern pattern2 = VerifierComponentMockFactory.createPattern2();
        LiteralRestriction r1 = LiteralRestriction.createRestriction((Pattern)pattern1, (String)"10");
        r1.setOperator(Operator.BuiltInOperator.EQUAL.getOperator());
        r1.setFieldPath("0");
        r1.setOrderNumber(0);
        LiteralRestriction r2 = LiteralRestriction.createRestriction((Pattern)pattern1, (String)"1");
        r2.setOperator(Operator.BuiltInOperator.LESS.getOperator());
        r2.setFieldPath("0");
        r2.setOrderNumber(2);
        LiteralRestriction r3 = LiteralRestriction.createRestriction((Pattern)pattern2, (String)"1");
        r3.setOperator(Operator.BuiltInOperator.GREATER_OR_EQUAL.getOperator());
        r3.setFieldPath("1");
        r3.setOrderNumber(0);
        LiteralRestriction r4 = LiteralRestriction.createRestriction((Pattern)pattern2, (String)"10");
        r4.setOperator(Operator.BuiltInOperator.EQUAL.getOperator());
        r4.setFieldPath("1");
        r4.setOrderNumber(1);
        data.add(r1);
        data.add(r2);
        data.add(r3);
        data.add(r4);
        for (Object e : data) {
            session.insert(e);
        }
        session.fireAllRules((AgendaFilter)new RuleNameMatchesAgendaFilter("Incompatible LiteralRestrictions with ranges in pattern possibility, impossible equality less or equal"));
        Map<Cause, Set<Cause>> map = this.createIncompatibilityMap(VerifierComponentType.RESTRICTION, session.getObjects().iterator());
        Assertions.assertThat((boolean)(TestBaseOld.causeMapContains(map, (Cause)r1, (Cause)r2) ^ TestBaseOld.causeMapContains(map, (Cause)r2, (Cause)r1))).isTrue();
        if (!map.isEmpty()) {
            Assertions.fail((String)"More incompatibilities than was expected.");
        }
    }

    @Test
    public void testLiteralRestrictionsIncompatibilityGreater() throws Exception {
        KieSession session = this.getStatelessKieSession(this.getClass().getResourceAsStream("Restrictions.drl"));
        ArrayList<LiteralRestriction> data = new ArrayList<LiteralRestriction>();
        Pattern pattern1 = VerifierComponentMockFactory.createPattern1();
        Pattern pattern2 = VerifierComponentMockFactory.createPattern2();
        LiteralRestriction r1 = LiteralRestriction.createRestriction((Pattern)pattern1, (String)"10");
        r1.setOperator(Operator.BuiltInOperator.GREATER.getOperator());
        r1.setFieldPath("0");
        r1.setOrderNumber(0);
        LiteralRestriction r2 = LiteralRestriction.createRestriction((Pattern)pattern1, (String)"1");
        r2.setOperator(Operator.BuiltInOperator.EQUAL.getOperator());
        r2.setFieldPath("0");
        r2.setOrderNumber(1);
        LiteralRestriction r3 = LiteralRestriction.createRestriction((Pattern)pattern2, (String)"1");
        r3.setOperator(Operator.BuiltInOperator.GREATER_OR_EQUAL.getOperator());
        r3.setFieldPath("1");
        r3.setOrderNumber(0);
        LiteralRestriction r4 = LiteralRestriction.createRestriction((Pattern)pattern2, (String)"10");
        r4.setOperator(Operator.BuiltInOperator.EQUAL.getOperator());
        r4.setFieldPath("1");
        r4.setOrderNumber(1);
        data.add(r1);
        data.add(r2);
        data.add(r3);
        data.add(r4);
        for (Object e : data) {
            session.insert(e);
        }
        session.fireAllRules((AgendaFilter)new RuleNameMatchesAgendaFilter("Incompatible LiteralRestrictions with ranges in pattern possibility, impossible equality greater"));
        Map<Cause, Set<Cause>> map = this.createIncompatibilityMap(VerifierComponentType.RESTRICTION, session.getObjects().iterator());
        Assertions.assertThat((boolean)(TestBaseOld.causeMapContains(map, (Cause)r1, (Cause)r2) ^ TestBaseOld.causeMapContains(map, (Cause)r2, (Cause)r1))).isTrue();
        if (!map.isEmpty()) {
            Assertions.fail((String)"More incompatibilities than was expected.");
        }
    }

    @Test
    public void testLiteralRestrictionsIncompatibilityImpossibleRange() throws Exception {
        KieSession session = this.getStatelessKieSession(this.getClass().getResourceAsStream("Restrictions.drl"));
        ArrayList<LiteralRestriction> data = new ArrayList<LiteralRestriction>();
        Pattern pattern1 = VerifierComponentMockFactory.createPattern1();
        Pattern pattern2 = VerifierComponentMockFactory.createPattern2();
        LiteralRestriction r1 = LiteralRestriction.createRestriction((Pattern)pattern1, (String)"10");
        r1.setOperator(Operator.BuiltInOperator.GREATER.getOperator());
        r1.setFieldPath("0");
        r1.setOrderNumber(0);
        LiteralRestriction r2 = LiteralRestriction.createRestriction((Pattern)pattern1, (String)"10");
        r2.setOperator(Operator.BuiltInOperator.LESS.getOperator());
        r2.setFieldPath("0");
        r2.setOrderNumber(1);
        LiteralRestriction r3 = LiteralRestriction.createRestriction((Pattern)pattern2, (String)"1");
        r3.setOperator(Operator.BuiltInOperator.GREATER_OR_EQUAL.getOperator());
        r3.setFieldPath("1");
        r3.setOrderNumber(0);
        LiteralRestriction r4 = LiteralRestriction.createRestriction((Pattern)pattern2, (String)"");
        r4.setOperator(Operator.BuiltInOperator.EQUAL.getOperator());
        r4.setFieldPath("1");
        r4.setOrderNumber(1);
        data.add(r1);
        data.add(r2);
        data.add(r3);
        data.add(r4);
        for (Object e : data) {
            session.insert(e);
        }
        session.fireAllRules((AgendaFilter)new RuleNameMatchesAgendaFilter("Incompatible LiteralRestrictions with ranges in pattern possibility, impossible range"));
        Map<Cause, Set<Cause>> map = this.createIncompatibilityMap(VerifierComponentType.RESTRICTION, session.getObjects().iterator());
        Assertions.assertThat((boolean)(TestBaseOld.causeMapContains(map, (Cause)r1, (Cause)r2) ^ TestBaseOld.causeMapContains(map, (Cause)r2, (Cause)r1))).isTrue();
        if (!map.isEmpty()) {
            Assertions.fail((String)"More incompatibilities than was expected.");
        }
    }

    @Test
    public void testVariableRestrictionsIncompatibilityImpossibleRange() throws Exception {
        KieSession session = this.getStatelessKieSession(this.getClass().getResourceAsStream("Restrictions.drl"));
        ArrayList<VariableRestriction> data = new ArrayList<VariableRestriction>();
        VerifierRule rule = VerifierComponentMockFactory.createRule1();
        ObjectType objectType = new ObjectType((BaseDescr)new PackageDescr("testPackage1"));
        objectType.setFullName("org.test.Person");
        Pattern pattern1 = VerifierComponentMockFactory.createPattern1();
        Pattern pattern2 = VerifierComponentMockFactory.createPattern2();
        PatternVariable variable1 = new PatternVariable(rule);
        variable1.setParentPath("0");
        variable1.setParentType(VerifierComponentType.FIELD);
        variable1.setOrderNumber(11);
        VariableRestriction r1 = new VariableRestriction(pattern1);
        r1.setOperator(Operator.BuiltInOperator.GREATER.getOperator());
        r1.setFieldPath("0");
        r1.setVariable((Variable)variable1);
        r1.setOrderNumber(0);
        VariableRestriction r2 = new VariableRestriction(pattern1);
        r2.setOperator(Operator.BuiltInOperator.LESS.getOperator());
        r2.setFieldPath("0");
        r2.setVariable((Variable)variable1);
        r2.setOrderNumber(1);
        PatternVariable variable2 = new PatternVariable(rule);
        variable2.setParentPath("1");
        variable2.setParentType(VerifierComponentType.FIELD);
        variable2.setOrderNumber(10);
        VariableRestriction r3 = new VariableRestriction(pattern2);
        r3.setOperator(Operator.BuiltInOperator.GREATER_OR_EQUAL.getOperator());
        r3.setFieldPath("1");
        r3.setVariable((Variable)variable2);
        r3.setOrderNumber(0);
        VariableRestriction r4 = new VariableRestriction(pattern2);
        r4.setOperator(Operator.BuiltInOperator.EQUAL.getOperator());
        r4.setFieldPath("1");
        r4.setVariable((Variable)variable2);
        r4.setOrderNumber(1);
        data.add(r1);
        data.add(r2);
        data.add(r3);
        data.add(r4);
        for (Object e : data) {
            session.insert(e);
        }
        session.fireAllRules((AgendaFilter)new RuleNameMatchesAgendaFilter("Incoherent VariableRestrictions in pattern possibility, impossible range"));
        Map<Cause, Set<Cause>> map = this.createIncompatibilityMap(VerifierComponentType.RESTRICTION, session.getObjects().iterator());
        Assertions.assertThat((boolean)(TestBaseOld.causeMapContains(map, (Cause)r1, (Cause)r2) ^ TestBaseOld.causeMapContains(map, (Cause)r2, (Cause)r1))).isTrue();
        if (!map.isEmpty()) {
            Assertions.fail((String)"More incompatibilities than was expected.");
        }
    }
}

