/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.jarloader;

import java.io.IOException;
import java.util.ArrayList;
import java.util.jar.JarInputStream;
import org.assertj.core.api.Assertions;
import org.drools.verifier.Verifier;
import org.drools.verifier.jarloader.VerifierMapBackedClassLoader;
import org.junit.Test;
import org.mockito.Mockito;

public class VerifierMapBackedClassLoaderTest {
    @Test
    public void testCheckResources() throws Exception {
        ArrayList<JarInputStream> jarInputStreams = new ArrayList<JarInputStream>();
        jarInputStreams.add(new JarInputStream(Verifier.class.getResourceAsStream("model.jar")));
        VerifierMapBackedClassLoader verifierMapBackedClassLoader = new VerifierMapBackedClassLoader(jarInputStreams);
        Assertions.assertThat((boolean)verifierMapBackedClassLoader.getStore().containsKey("org.test.Person")).isNotNull();
        Assertions.assertThat((boolean)verifierMapBackedClassLoader.getStore().containsKey("org.test.Rambo")).isNotNull();
        Assertions.assertThat((boolean)verifierMapBackedClassLoader.getStore().containsKey("org.test.Pet")).isNotNull();
    }

    @Test
    public void testToMakeSureExceptionsAreNotLost() throws Exception {
        ArrayList<JarInputStream> jarInputStreams = new ArrayList<JarInputStream>();
        JarInputStream jarInputStream = (JarInputStream)Mockito.mock(JarInputStream.class);
        Mockito.when((Object)jarInputStream.getNextJarEntry()).thenThrow(new Throwable[]{new IOException()});
        jarInputStreams.add(jarInputStream);
        try {
            new VerifierMapBackedClassLoader(jarInputStreams);
        }
        catch (IOException e) {
            return;
        }
        Assertions.fail((String)"Expected IOException");
    }
}

