/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.optimisation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.assertj.core.api.Assertions;
import org.drools.core.base.RuleNameMatchesAgendaFilter;
import org.drools.verifier.TestBaseOld;
import org.drools.verifier.components.Restriction;
import org.drools.verifier.components.RuleComponent;
import org.drools.verifier.data.VerifierReport;
import org.drools.verifier.data.VerifierReportFactory;
import org.drools.verifier.report.components.Severity;
import org.drools.verifier.report.components.VerifierMessage;
import org.junit.Test;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.AgendaFilter;

public class RestrictionOrderTest
extends TestBaseOld {
    @Test
    public void testRestrictionOrderInsideOperator() throws Exception {
        KieSession session = this.getStatelessKieSession(this.getClass().getResourceAsStream("RestrictionOrder.drl"));
        VerifierReport result = VerifierReportFactory.newVerifierReport();
        Collection<? extends Object> testData = this.getTestData(this.getClass().getResourceAsStream("OptimisationRestrictionOrderTest.drl"), result.getVerifierData());
        session.setGlobal("result", (Object)result);
        for (Object object : testData) {
            session.insert(object);
        }
        session.fireAllRules((AgendaFilter)new RuleNameMatchesAgendaFilter("Optimise restrictions inside operator"));
        Iterator iter = result.getBySeverity(Severity.NOTE).iterator();
        ArrayList<String> arrayList = new ArrayList<String>();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof VerifierMessage)) continue;
            String name = ((VerifierMessage)o).getCauses().toArray(new Restriction[2])[0].getRuleName();
            arrayList.add(name);
        }
        Assertions.assertThat((boolean)arrayList.remove("Wrong descr order 1")).isTrue();
        if (!arrayList.isEmpty()) {
            for (String string : arrayList) {
                Assertions.fail((String)("Rule " + string + " caused an error."));
            }
        }
    }

    @Test
    public void testPredicateOrderInsideOperator() throws Exception {
        KieSession session = this.getStatelessKieSession(this.getClass().getResourceAsStream("RestrictionOrder.drl"));
        VerifierReport result = VerifierReportFactory.newVerifierReport();
        Collection<? extends Object> testData = this.getTestData(this.getClass().getResourceAsStream("OptimisationRestrictionOrderTest.drl"), result.getVerifierData());
        session.setGlobal("result", (Object)result);
        for (Object object : testData) {
            session.insert(object);
        }
        session.fireAllRules((AgendaFilter)new RuleNameMatchesAgendaFilter("Optimise predicates inside operator"));
        Iterator iter = result.getBySeverity(Severity.NOTE).iterator();
        ArrayList<String> arrayList = new ArrayList<String>();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof VerifierMessage)) continue;
            String name = ((VerifierMessage)o).getCauses().toArray(new RuleComponent[2])[0].getRuleName();
            arrayList.add(name);
        }
        Assertions.assertThat((boolean)arrayList.remove("Wrong eval order 1")).isTrue();
        if (!arrayList.isEmpty()) {
            for (String string : arrayList) {
                Assertions.fail((String)("Rule " + string + " caused an error."));
            }
        }
    }
}

