/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.redundancy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.assertj.core.api.Assertions;
import org.drools.core.base.RuleNameMatchesAgendaFilter;
import org.drools.verifier.TestBaseOld;
import org.drools.verifier.VerifierComponentMockFactory;
import org.drools.verifier.components.LiteralRestriction;
import org.drools.verifier.components.Pattern;
import org.drools.verifier.components.PatternComponent;
import org.drools.verifier.components.RuleComponent;
import org.drools.verifier.components.SubPattern;
import org.drools.verifier.components.SubRule;
import org.drools.verifier.components.VerifierRule;
import org.drools.verifier.data.VerifierComponent;
import org.drools.verifier.data.VerifierReport;
import org.drools.verifier.data.VerifierReportFactory;
import org.drools.verifier.report.components.Cause;
import org.drools.verifier.report.components.Redundancy;
import org.drools.verifier.report.components.Severity;
import org.drools.verifier.report.components.VerifierMessageBase;
import org.junit.Test;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.AgendaFilter;

public class NotesTest
extends TestBaseOld {
    @Test
    public void testRedundantRestrictionsInPatternPossibilities() throws Exception {
        KieSession session = this.getStatelessKieSession(this.getClass().getResourceAsStream("Notes.drl"));
        Pattern pattern = VerifierComponentMockFactory.createPattern1();
        ArrayList<Object> objects = new ArrayList<Object>();
        LiteralRestriction left = LiteralRestriction.createRestriction((Pattern)pattern, (String)"");
        LiteralRestriction right = LiteralRestriction.createRestriction((Pattern)pattern, (String)"");
        Redundancy redundancy = new Redundancy((VerifierComponent)left, (VerifierComponent)right);
        SubPattern possibility = new SubPattern(pattern, 0);
        possibility.add((PatternComponent)left);
        possibility.add((PatternComponent)right);
        objects.add(left);
        objects.add(right);
        objects.add(redundancy);
        objects.add(possibility);
        VerifierReport result = VerifierReportFactory.newVerifierReport();
        session.setGlobal("result", (Object)result);
        for (Object e : objects) {
            session.insert(e);
        }
        session.fireAllRules((AgendaFilter)new RuleNameMatchesAgendaFilter("Find redundant restrictions from pattern possibilities"));
        Collection notes = result.getBySeverity(Severity.NOTE);
        Assertions.assertThat((int)notes.size()).isEqualTo(1);
        VerifierMessageBase verifierMessageBase = (VerifierMessageBase)notes.iterator().next();
        Iterator causes = verifierMessageBase.getCauses().iterator();
        Assertions.assertThat((Object)((Cause)causes.next())).isEqualTo((Object)left);
        Assertions.assertThat((Object)((Cause)causes.next())).isEqualTo((Object)right);
    }

    @Test
    public void testRedundantPatternPossibilitiesInRulePossibilities() throws Exception {
        KieSession session = this.getStatelessKieSession(this.getClass().getResourceAsStream("Notes.drl"));
        VerifierRule rule = VerifierComponentMockFactory.createRule1();
        Pattern pattern = VerifierComponentMockFactory.createPattern1();
        ArrayList<Object> objects = new ArrayList<Object>();
        SubPattern left = new SubPattern(pattern, 0);
        SubPattern right = new SubPattern(pattern, 1);
        Redundancy redundancy = new Redundancy((VerifierComponent)left, (VerifierComponent)right);
        SubRule possibility = new SubRule(rule, 0);
        possibility.add((RuleComponent)left);
        possibility.add((RuleComponent)right);
        objects.add(left);
        objects.add(right);
        objects.add(redundancy);
        objects.add(possibility);
        VerifierReport result = VerifierReportFactory.newVerifierReport();
        session.setGlobal("result", (Object)result);
        for (Object e : objects) {
            session.insert(e);
        }
        session.fireAllRules((AgendaFilter)new RuleNameMatchesAgendaFilter("Find redundant pattern possibilities from rule possibilities"));
        Collection notes = result.getBySeverity(Severity.NOTE);
        Assertions.assertThat((int)notes.size()).isEqualTo(1);
        VerifierMessageBase verifierMessageBase = (VerifierMessageBase)notes.iterator().next();
        Iterator causes = verifierMessageBase.getCauses().iterator();
        Assertions.assertThat((Object)((Cause)causes.next())).isEqualTo((Object)left);
        Assertions.assertThat((Object)((Cause)causes.next())).isEqualTo((Object)right);
    }
}

