/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.redundancy;

import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.drools.verifier.Verifier;
import org.drools.verifier.builder.VerifierBuilder;
import org.drools.verifier.builder.VerifierBuilderFactory;
import org.drools.verifier.builder.VerifierImpl;
import org.drools.verifier.report.components.Redundancy;
import org.drools.verifier.report.components.Subsumption;
import org.junit.Test;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.ClassObjectFilter;
import org.kie.api.runtime.ObjectFilter;
import org.kie.internal.io.ResourceFactory;

public class RedundancyTest {
    @Test
    public void testVerifierLiteralRestrictionRedundancy() throws Exception {
        VerifierBuilder vBuilder = VerifierBuilderFactory.newVerifierBuilder();
        Verifier verifier = vBuilder.newVerifier();
        verifier.addResourcesToVerify(ResourceFactory.newClassPathResource((String)"RedundantRestrictions.drl", this.getClass()), ResourceType.DRL);
        Assertions.assertThat((boolean)verifier.hasErrors()).isFalse();
        boolean noProblems = verifier.fireAnalysis();
        Assertions.assertThat((boolean)noProblems).isTrue();
        Collection subsumptionList = ((VerifierImpl)verifier).getKnowledgeSession().getObjects((ObjectFilter)new ClassObjectFilter(Subsumption.class));
        Collection redundancyList = ((VerifierImpl)verifier).getKnowledgeSession().getObjects((ObjectFilter)new ClassObjectFilter(Redundancy.class));
        Assertions.assertThat((int)subsumptionList.size()).isEqualTo(2);
        Assertions.assertThat((int)redundancyList.size()).isEqualTo(1);
        verifier.dispose();
    }
}

