/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.report.components;

import java.util.ArrayList;
import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.drools.io.ClassPathResource;
import org.drools.verifier.Verifier;
import org.drools.verifier.builder.VerifierBuilder;
import org.drools.verifier.builder.VerifierBuilderFactory;
import org.drools.verifier.data.VerifierReport;
import org.drools.verifier.report.components.Cause;
import org.drools.verifier.report.components.MessageType;
import org.drools.verifier.report.components.Severity;
import org.drools.verifier.report.components.VerifierMessage;
import org.drools.verifier.report.components.VerifierMessageBase;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;

public class CauseTest {
    @Test
    @Ignore(value="08-APR-2011 temporally ignoring -Rikkola-")
    public void testCauseTrace() throws Exception {
        VerifierBuilder vBuilder = VerifierBuilderFactory.newVerifierBuilder();
        Assertions.assertThat((boolean)vBuilder.hasErrors()).isFalse();
        Assertions.assertThat((int)vBuilder.getErrors().size()).isEqualTo(0);
        Verifier verifier = vBuilder.newVerifier();
        verifier.addResourcesToVerify((Resource)new ClassPathResource("Causes.drl", this.getClass()), ResourceType.DRL);
        Assertions.assertThat((boolean)verifier.hasErrors()).isFalse();
        Assertions.assertThat((int)verifier.getErrors().size()).isEqualTo(0);
        boolean works = verifier.fireAnalysis();
        Assertions.assertThat((boolean)works).isTrue();
        VerifierReport result = verifier.getResult();
        Assertions.assertThat((Object)result).isNotNull();
        Assertions.assertThat((int)result.getBySeverity(Severity.ERROR).size()).isEqualTo(0);
        Collection warnings = result.getBySeverity(Severity.WARNING);
        ArrayList<VerifierMessageBase> redundancyWarnings = new ArrayList<VerifierMessageBase>();
        for (VerifierMessageBase verifierMessageBase : warnings) {
            if (!verifierMessageBase.getMessageType().equals(MessageType.REDUNDANCY)) continue;
            redundancyWarnings.add(verifierMessageBase);
        }
        Assertions.assertThat((int)redundancyWarnings.size()).isEqualTo(1);
        VerifierMessage message = (VerifierMessage)redundancyWarnings.toArray()[0];
        Assertions.assertThat((int)message.getImpactedRules().size()).isEqualTo(2);
        Assertions.assertThat((boolean)message.getImpactedRules().values().contains("Your First Rule")).isTrue();
        Assertions.assertThat((boolean)message.getImpactedRules().values().contains("Your Second Rule")).isTrue();
        Cause[] causes = message.getCauses().toArray(new Cause[message.getCauses().size()]);
        Assertions.assertThat((int)causes.length).isEqualTo(1);
        causes = causes[0].getCauses().toArray(new Cause[causes[0].getCauses().size()]);
        Assertions.assertThat((int)causes.length).isEqualTo(2);
        causes = causes[0].getCauses().toArray(new Cause[causes[0].getCauses().size()]);
        Assertions.assertThat((int)causes.length).isEqualTo(1);
        causes = causes[0].getCauses().toArray(new Cause[causes[0].getCauses().size()]);
        Assertions.assertThat((int)causes.length).isEqualTo(1);
        causes = causes[0].getCauses().toArray(new Cause[causes[0].getCauses().size()]);
        Assertions.assertThat((int)causes.length).isEqualTo(2);
        Assertions.assertThat((int)result.getBySeverity(Severity.NOTE).size()).isEqualTo(0);
    }
}

