/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.visitor;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.assertj.core.api.Assertions;
import org.drools.drl.ast.descr.PackageDescr;
import org.drools.drl.parser.DrlParser;
import org.drools.drl.parser.DroolsParserException;
import org.drools.verifier.Verifier;
import org.drools.verifier.components.SubPattern;
import org.drools.verifier.components.SubRule;
import org.drools.verifier.components.VerifierComponentType;
import org.drools.verifier.data.VerifierComponent;
import org.drools.verifier.data.VerifierData;
import org.drools.verifier.data.VerifierReportFactory;
import org.drools.verifier.visitor.PackageDescrVisitor;
import org.junit.Before;
import org.junit.Test;
import org.kie.internal.builder.conf.LanguageLevelOption;

public class PackageDescrVisitorTest {
    private VerifierData verifierData;
    private PackageDescrVisitor packageDescrVisitor;

    @Before
    public void setUp() throws Exception {
        this.verifierData = VerifierReportFactory.newVerifierData();
        this.packageDescrVisitor = new PackageDescrVisitor(this.verifierData, Collections.EMPTY_LIST);
    }

    @Test
    public void testVisit() throws Exception {
        PackageDescr packageDescr = this.getPackageDescr(Verifier.class.getResourceAsStream("Misc3.drl"));
        Assertions.assertThat((Object)packageDescr).isNotNull();
        this.packageDescrVisitor.visitPackageDescr(packageDescr);
        Collection all = this.verifierData.getAll();
        HashSet<String> names = new HashSet<String>();
        for (VerifierComponent verifierComponent : all) {
            String path = verifierComponent.getPath();
            System.out.println("-" + verifierComponent);
            if (verifierComponent.getDescr() != null) {
                System.out.println(" \n\t\t => " + verifierComponent.getDescr().getLine() + ":" + verifierComponent.getDescr().getEndLine() + " " + verifierComponent.getDescr().getText());
            } else {
                System.out.println(" \n\t\t => null for " + verifierComponent.getClass().getSimpleName());
            }
            if (names.contains(path)) {
                Assertions.fail((String)("Dublicate path " + path));
                continue;
            }
            names.add(path);
        }
        Assertions.assertThat((Iterable)all).isNotNull();
        Assertions.assertThat((int)all.size()).isEqualTo(45);
    }

    @Test
    public void testSubPatterns() throws Exception {
        PackageDescr packageDescr = this.getPackageDescr(this.getClass().getResourceAsStream("SubPattern.drl"));
        Assertions.assertThat((Object)packageDescr).isNotNull();
        this.packageDescrVisitor.visitPackageDescr(packageDescr);
        Collection all = this.verifierData.getAll();
        Assertions.assertThat((Iterable)all).isNotNull();
        SubPattern test1SubPattern = null;
        SubPattern test2SubPattern = null;
        SubRule test1SubRule = null;
        SubRule test2SubRule = null;
        for (VerifierComponent verifierComponent : all) {
            System.out.println("-" + verifierComponent);
            if (verifierComponent.getDescr() != null) {
                System.out.println(" \n\t\t => " + verifierComponent.getDescr().getLine() + ":" + verifierComponent.getDescr().getEndLine() + " " + verifierComponent.getDescr().getText());
            } else {
                System.out.println(" \n\t\t => null for " + verifierComponent.getClass().getSimpleName());
            }
            if (verifierComponent.getVerifierComponentType().equals(VerifierComponentType.SUB_PATTERN)) {
                SubPattern subPattern = (SubPattern)verifierComponent;
                if ("Test 1".equals(subPattern.getRuleName())) {
                    Assertions.assertThat(test1SubPattern).isNull();
                    test1SubPattern = subPattern;
                } else if ("Test 2".equals(subPattern.getRuleName())) {
                    Assertions.assertThat(test2SubPattern).isNull();
                    test2SubPattern = subPattern;
                }
            }
            if (!verifierComponent.getVerifierComponentType().equals(VerifierComponentType.SUB_RULE)) continue;
            SubRule subRule = (SubRule)verifierComponent;
            if ("Test 1".equals(subRule.getRuleName())) {
                Assertions.assertThat(test1SubRule).isNull();
                test1SubRule = subRule;
                continue;
            }
            if (!"Test 2".equals(subRule.getRuleName())) continue;
            Assertions.assertThat(test2SubRule).isNull();
            test2SubRule = subRule;
        }
        Assertions.assertThat(test1SubPattern).isNotNull();
        Assertions.assertThat((int)test1SubPattern.getItems().size()).isEqualTo(3);
        Assertions.assertThat(test2SubPattern).isNotNull();
        Assertions.assertThat((int)test2SubPattern.getItems().size()).isEqualTo(3);
        Assertions.assertThat(test1SubRule).isNotNull();
        Assertions.assertThat((int)test1SubRule.getItems().size()).isEqualTo(1);
        Assertions.assertThat(test2SubRule).isNotNull();
        Assertions.assertThat((int)test2SubRule.getItems().size()).isEqualTo(1);
    }

    private PackageDescr getPackageDescr(InputStream resourceAsStream) throws DroolsParserException {
        InputStreamReader drlReader = new InputStreamReader(resourceAsStream);
        return new DrlParser(LanguageLevelOption.DRL5).parse((Reader)drlReader);
    }
}

