/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.subsumption;

import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.drools.verifier.Verifier;
import org.drools.verifier.VerifierError;
import org.drools.verifier.builder.VerifierBuilder;
import org.drools.verifier.builder.VerifierBuilderFactory;
import org.drools.verifier.builder.VerifierImpl;
import org.drools.verifier.components.VerifierComponentType;
import org.drools.verifier.report.components.Subsumption;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.ClassObjectFilter;
import org.kie.api.runtime.ObjectFilter;
import org.kie.internal.io.ResourceFactory;

public class SubsumptantSubPatternsTest {
    @Test
    void testSubpatternSubsumption1() throws Exception {
        VerifierBuilder vBuilder = VerifierBuilderFactory.newVerifierBuilder();
        Verifier verifier = vBuilder.newVerifier();
        verifier.addResourcesToVerify(ResourceFactory.newClassPathResource((String)"SubsumptantSubPatterns1.drl", this.getClass()), ResourceType.DRL);
        Assertions.assertThat((boolean)verifier.hasErrors()).isFalse();
        boolean noProblems = verifier.fireAnalysis();
        if (!noProblems) {
            for (VerifierError error : verifier.getErrors()) {
                System.out.println(error.getMessage());
            }
        }
        Collection subsumptionList = ((VerifierImpl)verifier).getKnowledgeSession().getObjects((ObjectFilter)new ClassObjectFilter(Subsumption.class));
        int count = 0;
        for (Object object : subsumptionList) {
            if (!((Subsumption)object).getLeft().getVerifierComponentType().equals(VerifierComponentType.SUB_PATTERN)) continue;
            ++count;
        }
        Assertions.assertThat((int)count).isEqualTo(1);
        verifier.dispose();
    }

    @Test
    void testSubpatternSubsumption2() throws Exception {
        VerifierBuilder vBuilder = VerifierBuilderFactory.newVerifierBuilder();
        Verifier verifier = vBuilder.newVerifier();
        verifier.addResourcesToVerify(ResourceFactory.newClassPathResource((String)"SubsumptantSubPatterns2.drl", this.getClass()), ResourceType.DRL);
        Assertions.assertThat((boolean)verifier.hasErrors()).isFalse();
        boolean noProblems = verifier.fireAnalysis();
        Assertions.assertThat((boolean)noProblems).isTrue();
        Collection subsumptionList = ((VerifierImpl)verifier).getKnowledgeSession().getObjects((ObjectFilter)new ClassObjectFilter(Subsumption.class));
        int count = 0;
        for (Object object : subsumptionList) {
            if (!((Subsumption)object).getLeft().getVerifierComponentType().equals(VerifierComponentType.SUB_PATTERN)) continue;
            ++count;
        }
        Assertions.assertThat((int)count).isEqualTo(1);
        verifier.dispose();
    }

    @Test
    void testSubpatternSubsumption3() throws Exception {
        VerifierBuilder vBuilder = VerifierBuilderFactory.newVerifierBuilder();
        Verifier verifier = vBuilder.newVerifier();
        verifier.addResourcesToVerify(ResourceFactory.newClassPathResource((String)"SubsumptantSubPatterns3.drl", this.getClass()), ResourceType.DRL);
        Assertions.assertThat((boolean)verifier.hasErrors()).isFalse();
        boolean noProblems = verifier.fireAnalysis();
        Assertions.assertThat((boolean)noProblems).isTrue();
        Collection subsumptionList = ((VerifierImpl)verifier).getKnowledgeSession().getObjects((ObjectFilter)new ClassObjectFilter(Subsumption.class));
        int count = 0;
        for (Object object : subsumptionList) {
            if (!((Subsumption)object).getLeft().getVerifierComponentType().equals(VerifierComponentType.SUB_PATTERN)) continue;
            ++count;
        }
        Assertions.assertThat((int)count).isEqualTo(1);
        verifier.dispose();
    }

    @Test
    @Disabled
    void testSubpatternSubsumption4() throws Exception {
        VerifierBuilder vBuilder = VerifierBuilderFactory.newVerifierBuilder();
        Verifier verifier = vBuilder.newVerifier();
        verifier.addResourcesToVerify(ResourceFactory.newClassPathResource((String)"SubsumptantSubPatterns4.drl", this.getClass()), ResourceType.DRL);
        Assertions.assertThat((boolean)verifier.hasErrors()).isFalse();
        boolean noProblems = verifier.fireAnalysis();
        Assertions.assertThat((boolean)noProblems).isTrue();
        Collection subsumptionList = ((VerifierImpl)verifier).getKnowledgeSession().getObjects((ObjectFilter)new ClassObjectFilter(Subsumption.class));
        int count = 0;
        for (Object object : subsumptionList) {
            if (!((Subsumption)object).getLeft().getVerifierComponentType().equals(VerifierComponentType.SUB_PATTERN)) continue;
            ++count;
        }
        Assertions.assertThat((int)count).isEqualTo(1);
        verifier.dispose();
    }

    @Test
    void testSubpatternSubsumption5() throws Exception {
        VerifierBuilder vBuilder = VerifierBuilderFactory.newVerifierBuilder();
        Verifier verifier = vBuilder.newVerifier();
        verifier.addResourcesToVerify(ResourceFactory.newClassPathResource((String)"SubsumptantSubPatterns5.drl", this.getClass()), ResourceType.DRL);
        Assertions.assertThat((boolean)verifier.hasErrors()).isFalse();
        boolean noProblems = verifier.fireAnalysis();
        Assertions.assertThat((boolean)noProblems).isTrue();
        Collection subsumptionList = ((VerifierImpl)verifier).getKnowledgeSession().getObjects((ObjectFilter)new ClassObjectFilter(Subsumption.class));
        int count = 0;
        for (Object object : subsumptionList) {
            if (!((Subsumption)object).getLeft().getVerifierComponentType().equals(VerifierComponentType.SUB_PATTERN)) continue;
            ++count;
        }
        Assertions.assertThat((int)count).isEqualTo(8);
        verifier.dispose();
    }
}

