/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.visitor;

import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.drools.drl.ast.descr.PackageDescr;
import org.drools.drl.ast.descr.RuleDescr;
import org.drools.drl.parser.DrlParser;
import org.drools.verifier.Verifier;
import org.drools.verifier.components.Field;
import org.drools.verifier.components.Import;
import org.drools.verifier.components.NumberRestriction;
import org.drools.verifier.components.ObjectType;
import org.drools.verifier.components.Pattern;
import org.drools.verifier.components.PatternOperatorDescr;
import org.drools.verifier.components.RuleOperatorDescr;
import org.drools.verifier.components.RulePackage;
import org.drools.verifier.components.SubPattern;
import org.drools.verifier.components.SubRule;
import org.drools.verifier.components.TextConsequence;
import org.drools.verifier.components.VerifierRule;
import org.drools.verifier.components.WorkingMemory;
import org.drools.verifier.data.VerifierComponent;
import org.drools.verifier.data.VerifierData;
import org.drools.verifier.data.VerifierReportFactory;
import org.drools.verifier.visitor.PackageDescrVisitor;
import org.junit.jupiter.api.Test;
import org.kie.internal.builder.conf.LanguageLevelOption;

public class VerifierComponentTest {
    @Test
    void testVisit() throws Exception {
        InputStreamReader drlReader = new InputStreamReader(Verifier.class.getResourceAsStream("Misc3.drl"));
        PackageDescr descr = new DrlParser(LanguageLevelOption.DRL5).parse((Reader)drlReader);
        VerifierData verifierData = VerifierReportFactory.newVerifierData();
        PackageDescrVisitor visitor = new PackageDescrVisitor(verifierData, Collections.EMPTY_LIST);
        visitor.visitPackageDescr(descr);
        Collection datas = verifierData.getAll();
        VerifierComponent[] components = datas.toArray(new VerifierComponent[datas.size()]);
        this.assertVerifierComponent((VerifierComponent)((TextConsequence)components[0]), 51);
        this.assertVerifierComponent((VerifierComponent)((TextConsequence)components[1]), 42);
        this.assertVerifierComponent((VerifierComponent)((Field)components[2]), 48);
        this.assertVerifierComponent((VerifierComponent)((Field)components[3]), 39);
        this.assertVerifierComponent((VerifierComponent)((Field)components[4]), 40);
        this.assertVerifierComponent((VerifierComponent)((Field)components[5]), 41);
        this.assertVerifierComponent((VerifierComponent)((Import)components[6]), 19);
        this.assertVerifierComponent((VerifierComponent)((ObjectType)components[7]), 48);
        this.assertVerifierComponent((VerifierComponent)((ObjectType)components[8]), 19);
        this.assertVerifierComponent((VerifierComponent)((ObjectType)components[9]), 39);
        this.assertVerifierComponent((VerifierComponent)((ObjectType)components[10]), 40);
        this.assertVerifierComponent((VerifierComponent)((ObjectType)components[11]), 41);
        this.assertVerifierComponent((VerifierComponent)((RuleOperatorDescr)components[12]), 48);
        this.assertVerifierComponent((VerifierComponent)((PatternOperatorDescr)components[13]), 48);
        this.assertVerifierComponent((VerifierComponent)((PatternOperatorDescr)components[14]), 49);
        this.assertVerifierComponent((VerifierComponent)((PatternOperatorDescr)components[15]), 50);
        this.assertVerifierComponent((VerifierComponent)((RuleOperatorDescr)components[16]), 39);
        this.assertVerifierComponent((VerifierComponent)((PatternOperatorDescr)components[17]), 39);
        this.assertVerifierComponent((VerifierComponent)((PatternOperatorDescr)components[18]), 40);
        this.assertVerifierComponent((VerifierComponent)((PatternOperatorDescr)components[19]), 41);
        this.assertVerifierComponent((VerifierComponent)((Pattern)components[20]), 48);
        this.assertVerifierComponent((VerifierComponent)((Pattern)components[21]), 49);
        this.assertVerifierComponent((VerifierComponent)((Pattern)components[22]), 50);
        this.assertVerifierComponent((VerifierComponent)((Pattern)components[23]), 39);
        this.assertVerifierComponent((VerifierComponent)((Pattern)components[24]), 40);
        this.assertVerifierComponent((VerifierComponent)((Pattern)components[25]), 41);
        this.assertVerifierComponent((VerifierComponent)((NumberRestriction)components[26]), 48);
        this.assertVerifierComponent((VerifierComponent)((NumberRestriction)components[27]), 49);
        this.assertVerifierComponent((VerifierComponent)((NumberRestriction)components[28]), 50);
        this.assertVerifierComponent((VerifierComponent)((NumberRestriction)components[29]), 39);
        this.assertVerifierComponent((VerifierComponent)((NumberRestriction)components[30]), 40);
        this.assertVerifierComponent((VerifierComponent)((NumberRestriction)components[31]), 41);
        this.assertVerifierComponent((VerifierComponent)((NumberRestriction)components[32]), 41);
        this.assertVerifierComponent((VerifierComponent)((VerifierRule)components[33]), 46);
        this.assertVerifierComponent((VerifierComponent)((VerifierRule)components[34]), 37);
        this.assertVerifierComponent((VerifierComponent)((RulePackage)components[35]), 17);
        this.assertVerifierComponent((VerifierComponent)((SubPattern)components[36]), 48);
        this.assertVerifierComponent((VerifierComponent)((SubPattern)components[37]), 49);
        this.assertVerifierComponent((VerifierComponent)((SubPattern)components[38]), 50);
        this.assertVerifierComponent((VerifierComponent)((SubPattern)components[39]), 39);
        this.assertVerifierComponent((VerifierComponent)((SubPattern)components[40]), 40);
        this.assertVerifierComponent((VerifierComponent)((SubPattern)components[41]), 41);
        this.assertVerifierComponent((VerifierComponent)((SubRule)components[42]), 46);
        this.assertVerifierComponent((VerifierComponent)((SubRule)components[43]), 37);
        this.assertVerifierComponent((VerifierComponent)((WorkingMemory)components[44]), -1);
    }

    void assertVerifierComponent(VerifierComponent component, int line) {
        Assertions.assertThat((Comparable)component).isNotNull();
        Assertions.assertThat((Object)component.getDescr()).isNotNull();
        if (component instanceof TextConsequence) {
            Assertions.assertThat((int)((RuleDescr)((TextConsequence)component).getDescr()).getConsequenceLine()).isEqualTo(line);
        } else {
            Assertions.assertThat((int)component.getDescr().getLine()).isEqualTo(line);
        }
    }
}

