/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.kie.api.runtime.rule.AgendaFilter;
import org.kie.api.runtime.rule.Match;

public class ScopesAgendaFilter
implements AgendaFilter {
    public static final String VERIFYING_SCOPE_SINGLE_RULE = "single-rule";
    public static final String VERIFYING_SCOPE_DECISION_TABLE = "decision-table";
    public static final String VERIFYING_SCOPE_KNOWLEDGE_PACKAGE = "knowledge-package";
    public static final Collection<String> ALL_SCOPES = new ArrayList<String>(){
        private static final long serialVersionUID = 510L;
        {
            this.add(ScopesAgendaFilter.VERIFYING_SCOPE_DECISION_TABLE);
            this.add(ScopesAgendaFilter.VERIFYING_SCOPE_SINGLE_RULE);
            this.add(ScopesAgendaFilter.VERIFYING_SCOPE_KNOWLEDGE_PACKAGE);
        }
    };
    public static final String VERIFYING_SCOPES = "verifying_scopes";
    private final boolean acceptEmpty;
    private final Collection<String> scopes;

    public ScopesAgendaFilter(boolean acceptEmpty, Collection<String> scopes) {
        this.acceptEmpty = acceptEmpty;
        this.scopes = scopes;
    }

    public ScopesAgendaFilter(boolean acceptEmpty, String scope) {
        this.acceptEmpty = acceptEmpty;
        ArrayList<String> list = new ArrayList<String>();
        list.add(scope);
        this.scopes = list;
    }

    public boolean accept(Match activation) {
        if (this.acceptEmpty && activation.getRule().getMetaData().isEmpty()) {
            return true;
        }
        if (activation.getRule().getMetaData().containsKey(VERIFYING_SCOPES)) {
            List values = (List)activation.getRule().getMetaData().get(VERIFYING_SCOPES);
            for (String value : values) {
                if (!this.scopes.contains(value.trim())) continue;
                return true;
            }
        }
        return false;
    }
}

