/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.misc;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.drools.verifier.misc.DrlPackageParser;
import org.drools.verifier.misc.DrlRuleParser;
import org.junit.jupiter.api.Test;

public class DrlPackageDataTest {
    @Test
    void testHandleDrl() throws ParseException {
        Object drl = "";
        drl = (String)drl + "package org.drools.test\n";
        drl = (String)drl + "global java.util.List list\n";
        drl = (String)drl + "rule rule1\n";
        drl = (String)drl + "when\n";
        drl = (String)drl + "then\n";
        drl = (String)drl + "list.add( drools.getRule().getName() );\n";
        drl = (String)drl + "end\n";
        drl = (String)drl + "rule rule2\n";
        drl = (String)drl + "when\n";
        drl = (String)drl + "then\n";
        drl = (String)drl + "list.add( drools.getRule().getName() );\n";
        drl = (String)drl + "end\n";
        DrlPackageParser s = DrlPackageParser.findPackageDataFromDrl((String)drl);
        Assertions.assertThat((String)s.getName()).isEqualTo("org.drools.test");
        Assertions.assertThat((int)s.getRules().size()).isEqualTo(2);
        Assertions.assertThat((String)s.getDescription()).isEqualTo("");
    }

    @Test
    void testHandleDrl2() throws IOException, ParseException {
        String str;
        BufferedReader in = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("DrlPackageTestData.drl")));
        Object rule = "";
        while ((str = in.readLine()) != null) {
            rule = (String)rule + str;
            rule = (String)rule + "\n";
        }
        in.close();
        DrlPackageParser s = DrlPackageParser.findPackageDataFromDrl((String)rule);
        Assertions.assertThat((Object)s).isNotNull();
        Assertions.assertThat((String)s.getName()).isEqualTo("org.drools.test");
        Assertions.assertThat((int)s.getRules().size()).isEqualTo(5);
        Assertions.assertThat((String)s.getDescription()).isEqualTo("");
    }

    @Test
    void testHandleDrlNoPackageData() {
        Object drl = "";
        drl = (String)drl + "rule rule1\n";
        drl = (String)drl + "    when\n";
        drl = (String)drl + "    then\n";
        drl = (String)drl + "        list.add( drools.getRule().getName() );\n";
        drl = (String)drl + "end\n";
        boolean exception = false;
        try {
            DrlPackageParser drlPackageParser = DrlPackageParser.findPackageDataFromDrl((String)drl);
        }
        catch (ParseException e) {
            exception = true;
        }
        if (!exception) {
            Assertions.fail((String)"Should have thrown a ParseException.");
        }
    }

    @Test
    void testHandleDrlWithComments() throws ParseException {
        Object drl = "";
        drl = (String)drl + "# important information\n";
        drl = (String)drl + "# about this package\n";
        drl = (String)drl + "# it contains some rules\n";
        drl = (String)drl + "package org.drools.test\n";
        drl = (String)drl + "global java.util.List list\n";
        drl = (String)drl + "rule rule1\n";
        drl = (String)drl + "\twhen\n";
        drl = (String)drl + "\tthen\n";
        drl = (String)drl + "\t\tlist.add( drools.getRule().getName() );\n";
        drl = (String)drl + "end\n";
        drl = (String)drl + "rule rule2\n";
        drl = (String)drl + "\twhen\n";
        drl = (String)drl + "\tthen\n";
        drl = (String)drl + "\t\tlist.add( drools.getRule().getName() );\n";
        drl = (String)drl + "end\n";
        DrlPackageParser data = DrlPackageParser.findPackageDataFromDrl((String)drl);
        Assertions.assertThat((String)data.getName()).isEqualTo("org.drools.test");
        Assertions.assertThat((int)data.getRules().size()).isEqualTo(2);
        Assertions.assertThat((int)data.getGlobals().size()).isEqualTo(1);
        Assertions.assertThat((String)((String)data.getGlobals().get(0))).isEqualTo("java.util.List list");
        Assertions.assertThat((String)data.getDescription()).isEqualTo("important information\nabout this package\nit contains some rules\n");
        DrlRuleParser rd1 = (DrlRuleParser)data.getRules().get(0);
        Assertions.assertThat((String)rd1.getName()).isEqualTo("rule1");
        Assertions.assertThat((String)rd1.getDescription()).isEqualTo("");
        DrlRuleParser rd2 = (DrlRuleParser)data.getRules().get(1);
        Assertions.assertThat((String)rd2.getName()).isEqualTo("rule2");
        Assertions.assertThat((String)rd2.getDescription()).isEqualTo("");
    }

    @Test
    void testfindGlobals() {
        String header = "global LoanApplication gg";
        List globals = DrlPackageParser.findGlobals((String)header);
        Assertions.assertThat((int)globals.size()).isEqualTo(1);
        Assertions.assertThat((String)((String)globals.get(0))).isEqualTo("LoanApplication gg");
    }
}

