/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier;

import java.io.InputStreamReader;
import java.io.Reader;
import junit.framework.TestCase;
import org.drools.RuleBase;
import org.drools.compiler.DrlParser;
import org.drools.lang.descr.PackageDescr;
import org.drools.verifier.Verifier;
import org.drools.verifier.dao.VerifierResult;
import org.drools.verifier.report.components.Severity;

public class VerifierTest
extends TestCase {
    public void testAnalyzer() throws Exception {
        Verifier anal = new Verifier();
        DrlParser p = new DrlParser();
        InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("Misc3.drl"));
        PackageDescr pkg = p.parse((Reader)reader);
        VerifierTest.assertFalse((boolean)p.hasErrors());
        anal.addPackageDescr(pkg);
        VerifierTest.assertTrue((String)"Firing verifier failed.", (boolean)anal.fireAnalysis());
        VerifierResult result = anal.getResult();
        VerifierTest.assertNotNull((Object)result);
        VerifierTest.assertEquals((int)0, (int)result.getBySeverity(Severity.ERROR).size());
        VerifierTest.assertEquals((int)10, (int)result.getBySeverity(Severity.WARNING).size());
        VerifierTest.assertEquals((int)16, (int)result.getBySeverity(Severity.NOTE).size());
        anal = new Verifier();
        p = new DrlParser();
        reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("Misc3.drl"));
        pkg = p.parse((Reader)reader);
        VerifierTest.assertFalse((boolean)p.hasErrors());
        anal.addPackageDescr(pkg);
        VerifierTest.assertTrue((String)"Firing verifier failed.", (boolean)anal.fireAnalysis());
        result = anal.getResult();
        VerifierTest.assertNotNull((Object)result);
        VerifierTest.assertEquals((int)0, (int)result.getBySeverity(Severity.ERROR).size());
        VerifierTest.assertEquals((int)10, (int)result.getBySeverity(Severity.WARNING).size());
        VerifierTest.assertEquals((int)16, (int)result.getBySeverity(Severity.NOTE).size());
    }

    public void testCacheKnowledgeBase() throws Exception {
        Verifier anal = new Verifier();
        DrlParser p = new DrlParser();
        InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("Misc3.drl"));
        PackageDescr pkg = p.parse((Reader)reader);
        VerifierTest.assertFalse((boolean)p.hasErrors());
        anal.addPackageDescr(pkg);
        anal.fireAnalysis();
        RuleBase original = Verifier.verifierKnowledgeBase;
        Verifier anal2 = new Verifier();
        VerifierTest.assertSame((Object)original, (Object)Verifier.verifierKnowledgeBase);
        try {
            anal2.reloadAnalysisKnowledgeBase();
        }
        catch (Exception e) {
            VerifierTest.fail((String)"Couldn't reload the knowledge base.");
        }
        VerifierTest.assertNotSame((Object)original, (Object)Verifier.verifierKnowledgeBase);
    }
}

