/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.incompatibility;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.drools.StatelessSession;
import org.drools.StatelessSessionResult;
import org.drools.base.RuleNameMatchesAgendaFilter;
import org.drools.spi.AgendaFilter;
import org.drools.verifier.TestBase;
import org.drools.verifier.components.LiteralRestriction;
import org.drools.verifier.components.PatternPossibility;
import org.drools.verifier.components.Restriction;
import org.drools.verifier.incompatibility.IncompatibilityBase;
import org.drools.verifier.report.components.Cause;
import org.drools.verifier.report.components.CauseType;
import org.drools.verifier.report.components.Incompatibility;

public class IncompatibilityPatternsTest
extends IncompatibilityBase {
    public void testPatternsPossibilitiesIncompatibility() throws Exception {
        StatelessSession session = this.getStatelessSession(((Object)((Object)this)).getClass().getResourceAsStream("Patterns.drl"));
        session.setAgendaFilter((AgendaFilter)new RuleNameMatchesAgendaFilter("Incompatible Patterns"));
        ArrayList<Object> data = new ArrayList<Object>();
        PatternPossibility pp1 = new PatternPossibility();
        PatternPossibility pp2 = new PatternPossibility();
        LiteralRestriction r1 = new LiteralRestriction();
        pp1.add((Restriction)r1);
        LiteralRestriction r2 = new LiteralRestriction();
        pp2.add((Restriction)r2);
        LiteralRestriction r3 = new LiteralRestriction();
        pp1.add((Restriction)r3);
        LiteralRestriction r4 = new LiteralRestriction();
        pp2.add((Restriction)r4);
        Incompatibility o1 = new Incompatibility((Cause)r1, (Cause)r2);
        Incompatibility o2 = new Incompatibility((Cause)r3, (Cause)r4);
        PatternPossibility pp3 = new PatternPossibility();
        PatternPossibility pp4 = new PatternPossibility();
        LiteralRestriction r5 = new LiteralRestriction();
        pp3.add((Restriction)r5);
        LiteralRestriction r6 = new LiteralRestriction();
        pp4.add((Restriction)r6);
        LiteralRestriction r7 = new LiteralRestriction();
        pp3.add((Restriction)r7);
        LiteralRestriction r8 = new LiteralRestriction();
        pp4.add((Restriction)r8);
        Incompatibility o3 = new Incompatibility((Cause)r5, (Cause)r6);
        data.add(r1);
        data.add(r2);
        data.add(r3);
        data.add(r4);
        data.add(r5);
        data.add(r6);
        data.add(r7);
        data.add(r8);
        data.add(pp1);
        data.add(pp2);
        data.add(pp3);
        data.add(pp4);
        data.add(o1);
        data.add(o2);
        data.add(o3);
        StatelessSessionResult sessionResult = session.executeWithResults(data);
        Map<Cause, Set<Cause>> map = this.createIncompatibilityMap(CauseType.PATTERN_POSSIBILITY, sessionResult.iterateObjects());
        IncompatibilityPatternsTest.assertTrue((boolean)(TestBase.causeMapContains(map, (Cause)pp1, (Cause)pp2) ^ TestBase.causeMapContains(map, (Cause)pp2, (Cause)pp1)));
        IncompatibilityPatternsTest.assertTrue((boolean)(TestBase.causeMapContains(map, (Cause)pp3, (Cause)pp4) ^ TestBase.causeMapContains(map, (Cause)pp4, (Cause)pp3)));
        if (!map.isEmpty()) {
            IncompatibilityPatternsTest.fail((String)"More opposites than was expected.");
        }
    }
}

