/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.opposites;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.drools.StatelessSession;
import org.drools.StatelessSessionResult;
import org.drools.base.RuleNameMatchesAgendaFilter;
import org.drools.base.evaluators.MatchesEvaluatorsDefinition;
import org.drools.base.evaluators.Operator;
import org.drools.spi.AgendaFilter;
import org.drools.verifier.TestBase;
import org.drools.verifier.components.LiteralRestriction;
import org.drools.verifier.components.Variable;
import org.drools.verifier.components.VariableRestriction;
import org.drools.verifier.components.VerifierComponentType;
import org.drools.verifier.opposites.OppositesBase;
import org.drools.verifier.report.components.Cause;
import org.drools.verifier.report.components.CauseType;

public class OppositeRestrictionsTest
extends OppositesBase {
    public void testLiteralRestrictionOpposite() throws Exception {
        StatelessSession session = this.getStatelessSession(((Object)((Object)this)).getClass().getResourceAsStream("Restrictions.drl"));
        session.setAgendaFilter((AgendaFilter)new RuleNameMatchesAgendaFilter("Opposite LiteralRestrictions"));
        ArrayList<LiteralRestriction> data = new ArrayList<LiteralRestriction>();
        LiteralRestriction r1 = new LiteralRestriction();
        r1.setFieldId(0);
        r1.setOperator(Operator.EQUAL);
        r1.setValue("1");
        LiteralRestriction r2 = new LiteralRestriction();
        r2.setFieldId(0);
        r2.setOperator(Operator.NOT_EQUAL);
        r2.setValue("1");
        LiteralRestriction r3 = new LiteralRestriction();
        r3.setFieldId(0);
        r3.setOperator(Operator.EQUAL);
        r3.setValue("1.0");
        LiteralRestriction r4 = new LiteralRestriction();
        r4.setFieldId(0);
        r4.setOperator(Operator.NOT_EQUAL);
        r4.setValue("1.0");
        LiteralRestriction r5 = new LiteralRestriction();
        r5.setFieldId(0);
        r5.setOperator(MatchesEvaluatorsDefinition.MATCHES);
        r5.setValue("foo");
        LiteralRestriction r6 = new LiteralRestriction();
        r6.setFieldId(0);
        r6.setOperator(MatchesEvaluatorsDefinition.NOT_MATCHES);
        r6.setValue("foo");
        data.add(r1);
        data.add(r2);
        data.add(r3);
        data.add(r4);
        data.add(r5);
        data.add(r6);
        StatelessSessionResult sessionResult = session.executeWithResults(data);
        Map<Cause, Set<Cause>> map = this.createOppositesMap(CauseType.RESTRICTION, sessionResult.iterateObjects());
        OppositeRestrictionsTest.assertTrue((boolean)(TestBase.causeMapContains(map, (Cause)r1, (Cause)r2) ^ TestBase.causeMapContains(map, (Cause)r2, (Cause)r1)));
        OppositeRestrictionsTest.assertTrue((boolean)(TestBase.causeMapContains(map, (Cause)r3, (Cause)r4) ^ TestBase.causeMapContains(map, (Cause)r4, (Cause)r3)));
        OppositeRestrictionsTest.assertTrue((boolean)(TestBase.causeMapContains(map, (Cause)r5, (Cause)r6) ^ TestBase.causeMapContains(map, (Cause)r6, (Cause)r5)));
        if (!map.isEmpty()) {
            OppositeRestrictionsTest.fail((String)"More opposites than was expected.");
        }
    }

    public void testLiteralRestrictionOppositeWithRangesGreaterOrEqualAndLess() throws Exception {
        StatelessSession session = this.getStatelessSession(((Object)((Object)this)).getClass().getResourceAsStream("Restrictions.drl"));
        session.setAgendaFilter((AgendaFilter)new RuleNameMatchesAgendaFilter("Opposite LiteralRestrictions with ranges, greater or equal - less"));
        ArrayList<LiteralRestriction> data = new ArrayList<LiteralRestriction>();
        LiteralRestriction r1 = new LiteralRestriction();
        r1.setFieldId(0);
        r1.setOperator(Operator.GREATER_OR_EQUAL);
        r1.setValue("1");
        LiteralRestriction r2 = new LiteralRestriction();
        r2.setFieldId(0);
        r2.setOperator(Operator.LESS);
        r2.setValue("1");
        data.add(r1);
        data.add(r2);
        StatelessSessionResult sessionResult = session.executeWithResults(data);
        Map<Cause, Set<Cause>> map = this.createOppositesMap(CauseType.RESTRICTION, sessionResult.iterateObjects());
        OppositeRestrictionsTest.assertTrue((boolean)(TestBase.causeMapContains(map, (Cause)r1, (Cause)r2) ^ TestBase.causeMapContains(map, (Cause)r2, (Cause)r1)));
        if (!map.isEmpty()) {
            OppositeRestrictionsTest.fail((String)"More opposites than was expected.");
        }
    }

    public void testLiteralRestrictionOppositeWithRangesGreaterAndLessOrEqual() throws Exception {
        StatelessSession session = this.getStatelessSession(((Object)((Object)this)).getClass().getResourceAsStream("Restrictions.drl"));
        session.setAgendaFilter((AgendaFilter)new RuleNameMatchesAgendaFilter("Opposite LiteralRestrictions with ranges, greater - less or equal"));
        ArrayList<LiteralRestriction> data = new ArrayList<LiteralRestriction>();
        LiteralRestriction r1 = new LiteralRestriction();
        r1.setFieldId(0);
        r1.setOperator(Operator.GREATER);
        r1.setValue("1");
        LiteralRestriction r2 = new LiteralRestriction();
        r2.setFieldId(0);
        r2.setOperator(Operator.LESS_OR_EQUAL);
        r2.setValue("1");
        data.add(r1);
        data.add(r2);
        StatelessSessionResult sessionResult = session.executeWithResults(data);
        Map<Cause, Set<Cause>> map = this.createOppositesMap(CauseType.RESTRICTION, sessionResult.iterateObjects());
        OppositeRestrictionsTest.assertTrue((boolean)(TestBase.causeMapContains(map, (Cause)r1, (Cause)r2) ^ TestBase.causeMapContains(map, (Cause)r2, (Cause)r1)));
        if (!map.isEmpty()) {
            OppositeRestrictionsTest.fail((String)"More opposites than was expected.");
        }
    }

    public void testLiteralRestrictionOppositeWithRangesLessAndGreaterForIntsAndDates() throws Exception {
        StatelessSession session = this.getStatelessSession(((Object)((Object)this)).getClass().getResourceAsStream("Restrictions.drl"));
        session.setAgendaFilter((AgendaFilter)new RuleNameMatchesAgendaFilter("Opposite LiteralRestrictions with ranges, less - greater for ints and dates"));
        ArrayList<LiteralRestriction> data = new ArrayList<LiteralRestriction>();
        LiteralRestriction r1 = new LiteralRestriction();
        r1.setFieldId(0);
        r1.setOperator(Operator.GREATER);
        r1.setValue("0");
        LiteralRestriction r2 = new LiteralRestriction();
        r2.setFieldId(0);
        r2.setOperator(Operator.LESS);
        r2.setValue("1");
        data.add(r1);
        data.add(r2);
        StatelessSessionResult sessionResult = session.executeWithResults(data);
        Map<Cause, Set<Cause>> map = this.createOppositesMap(CauseType.RESTRICTION, sessionResult.iterateObjects());
        OppositeRestrictionsTest.assertTrue((boolean)(TestBase.causeMapContains(map, (Cause)r1, (Cause)r2) ^ TestBase.causeMapContains(map, (Cause)r2, (Cause)r1)));
        if (!map.isEmpty()) {
            OppositeRestrictionsTest.fail((String)"More opposites than was expected.");
        }
    }

    public void testLiteralRestrictionOppositeWithRangesLessOrEqualAndGreaterOrEqualForIntsAndDates() throws Exception {
        StatelessSession session = this.getStatelessSession(((Object)((Object)this)).getClass().getResourceAsStream("Restrictions.drl"));
        session.setAgendaFilter((AgendaFilter)new RuleNameMatchesAgendaFilter("Opposite LiteralRestrictions with ranges, less or equal - greater or equal for ints and dates"));
        ArrayList<LiteralRestriction> data = new ArrayList<LiteralRestriction>();
        LiteralRestriction r1 = new LiteralRestriction();
        r1.setFieldId(0);
        r1.setOperator(Operator.GREATER_OR_EQUAL);
        r1.setValue("1");
        LiteralRestriction r2 = new LiteralRestriction();
        r2.setFieldId(0);
        r2.setOperator(Operator.LESS_OR_EQUAL);
        r2.setValue("0");
        data.add(r1);
        data.add(r2);
        StatelessSessionResult sessionResult = session.executeWithResults(data);
        Map<Cause, Set<Cause>> map = this.createOppositesMap(CauseType.RESTRICTION, sessionResult.iterateObjects());
        OppositeRestrictionsTest.assertTrue((boolean)(TestBase.causeMapContains(map, (Cause)r1, (Cause)r2) ^ TestBase.causeMapContains(map, (Cause)r2, (Cause)r1)));
        if (!map.isEmpty()) {
            OppositeRestrictionsTest.fail((String)"More opposites than was expected.");
        }
    }

    public void testVariableRestrictionOpposite() throws Exception {
        StatelessSession session = this.getStatelessSession(((Object)((Object)this)).getClass().getResourceAsStream("Restrictions.drl"));
        session.setAgendaFilter((AgendaFilter)new RuleNameMatchesAgendaFilter("Opposite VariableRestrictions"));
        ArrayList<VariableRestriction> data = new ArrayList<VariableRestriction>();
        Variable variable1 = new Variable();
        variable1.setObjectId(1);
        variable1.setObjectType(VerifierComponentType.FIELD);
        VariableRestriction r1 = new VariableRestriction();
        r1.setPatternId(0);
        r1.setFieldId(0);
        r1.setOperator(Operator.GREATER_OR_EQUAL);
        r1.setVariable(variable1);
        VariableRestriction r2 = new VariableRestriction();
        r1.setPatternId(0);
        r2.setFieldId(0);
        r2.setOperator(Operator.LESS);
        r2.setVariable(variable1);
        String containsOperator = "contains";
        Variable variable2 = new Variable();
        variable2.setObjectId(2);
        variable2.setObjectType(VerifierComponentType.FIELD);
        VariableRestriction r3 = new VariableRestriction();
        r3.setPatternId(1);
        r3.setFieldId(1);
        r3.setOperator(Operator.determineOperator((String)containsOperator, (boolean)false));
        r3.setVariable(variable2);
        VariableRestriction r4 = new VariableRestriction();
        r4.setPatternId(1);
        r4.setFieldId(1);
        r4.setOperator(Operator.determineOperator((String)containsOperator, (boolean)true));
        r4.setVariable(variable2);
        Variable variable3 = new Variable();
        variable3.setObjectId(3);
        variable3.setObjectType(VerifierComponentType.FIELD);
        VariableRestriction r5 = new VariableRestriction();
        r5.setPatternId(2);
        r5.setFieldId(1);
        r5.setOperator(Operator.GREATER_OR_EQUAL);
        r5.setVariable(variable3);
        VariableRestriction r6 = new VariableRestriction();
        r6.setPatternId(2);
        r6.setFieldId(1);
        r6.setOperator(Operator.EQUAL);
        r6.setVariable(variable3);
        data.add(r1);
        data.add(r2);
        data.add(r3);
        data.add(r4);
        data.add(r5);
        data.add(r6);
        StatelessSessionResult sessionResult = session.executeWithResults(data);
        Map<Cause, Set<Cause>> map = this.createOppositesMap(CauseType.RESTRICTION, sessionResult.iterateObjects());
        OppositeRestrictionsTest.assertTrue((boolean)(TestBase.causeMapContains(map, (Cause)r1, (Cause)r2) ^ TestBase.causeMapContains(map, (Cause)r2, (Cause)r1)));
        OppositeRestrictionsTest.assertTrue((boolean)(TestBase.causeMapContains(map, (Cause)r3, (Cause)r4) ^ TestBase.causeMapContains(map, (Cause)r4, (Cause)r3)));
        if (!map.isEmpty()) {
            OppositeRestrictionsTest.fail((String)"More opposites than was expected.");
        }
    }
}

