/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.subsumption;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.drools.StatelessSession;
import org.drools.StatelessSessionResult;
import org.drools.base.RuleNameMatchesAgendaFilter;
import org.drools.base.evaluators.Operator;
import org.drools.spi.AgendaFilter;
import org.drools.verifier.TestBase;
import org.drools.verifier.components.Field;
import org.drools.verifier.components.LiteralRestriction;
import org.drools.verifier.dao.VerifierResult;
import org.drools.verifier.dao.VerifierResultFactory;
import org.drools.verifier.report.components.Cause;
import org.drools.verifier.subsumption.SubsumptionTestBase;

public class SubsumptantRestrictionsTest
extends SubsumptionTestBase {
    public void testRestrictionRedundancyGreater() throws Exception {
        StatelessSession session = this.getStatelessSession(((Object)((Object)this)).getClass().getResourceAsStream("Restrictions.drl"));
        session.setAgendaFilter((AgendaFilter)new RuleNameMatchesAgendaFilter("Find subsumptant restrictions, greater than"));
        ArrayList<LiteralRestriction> data = new ArrayList<LiteralRestriction>();
        VerifierResult result = VerifierResultFactory.createVerifierResult();
        session.setGlobal("result", (Object)result);
        Field field1 = new Field();
        LiteralRestriction lr1 = new LiteralRestriction();
        lr1.setOrderNumber(0);
        lr1.setFieldId(field1.getId());
        lr1.setValue("1.0");
        lr1.setOperator(Operator.GREATER);
        LiteralRestriction lr2 = new LiteralRestriction();
        lr2.setOrderNumber(1);
        lr2.setFieldId(field1.getId());
        lr2.setValue("2.0");
        lr2.setOperator(Operator.GREATER);
        Field field2 = new Field();
        LiteralRestriction lr3 = new LiteralRestriction();
        lr3.setOrderNumber(0);
        lr3.setFieldId(field2.getId());
        lr3.setValue("1");
        lr3.setOperator(Operator.GREATER);
        LiteralRestriction lr4 = new LiteralRestriction();
        lr4.setOrderNumber(1);
        lr4.setFieldId(field2.getId());
        lr4.setValue("2");
        lr4.setOperator(Operator.GREATER_OR_EQUAL);
        Field field3 = new Field();
        LiteralRestriction lr5 = new LiteralRestriction();
        lr5.setOrderNumber(0);
        lr5.setFieldId(field3.getId());
        lr5.setValue("10-dec-2005");
        lr5.setOperator(Operator.GREATER);
        LiteralRestriction lr6 = new LiteralRestriction();
        lr6.setOrderNumber(1);
        lr6.setFieldId(field3.getId());
        lr6.setValue("10-dec-2008");
        lr6.setOperator(Operator.EQUAL);
        data.add(lr1);
        data.add(lr2);
        data.add(lr3);
        data.add(lr4);
        data.add(lr5);
        data.add(lr6);
        StatelessSessionResult sessionResult = session.executeWithResults(data);
        Map<Cause, Set<Cause>> map = this.createSubsumptionMap(sessionResult.iterateObjects());
        SubsumptantRestrictionsTest.assertTrue((boolean)TestBase.causeMapContains(map, (Cause)lr1, (Cause)lr2));
        SubsumptantRestrictionsTest.assertTrue((boolean)TestBase.causeMapContains(map, (Cause)lr3, (Cause)lr4));
        SubsumptantRestrictionsTest.assertTrue((boolean)TestBase.causeMapContains(map, (Cause)lr5, (Cause)lr6));
        if (!map.isEmpty()) {
            SubsumptantRestrictionsTest.fail((String)"More redundancies than was expected.");
        }
    }

    public void testRestrictionRedundancyLess() throws Exception {
        StatelessSession session = this.getStatelessSession(((Object)((Object)this)).getClass().getResourceAsStream("Restrictions.drl"));
        session.setAgendaFilter((AgendaFilter)new RuleNameMatchesAgendaFilter("Find subsumptant restrictions, less than"));
        ArrayList<LiteralRestriction> data = new ArrayList<LiteralRestriction>();
        VerifierResult result = VerifierResultFactory.createVerifierResult();
        session.setGlobal("result", (Object)result);
        Field field1 = new Field();
        LiteralRestriction lr1 = new LiteralRestriction();
        lr1.setOrderNumber(0);
        lr1.setFieldId(field1.getId());
        lr1.setValue("2.0");
        lr1.setOperator(Operator.LESS);
        LiteralRestriction lr2 = new LiteralRestriction();
        lr2.setOrderNumber(1);
        lr2.setFieldId(field1.getId());
        lr2.setValue("1.0");
        lr2.setOperator(Operator.LESS);
        Field field2 = new Field();
        LiteralRestriction lr3 = new LiteralRestriction();
        lr3.setOrderNumber(0);
        lr3.setFieldId(field2.getId());
        lr3.setValue("2");
        lr3.setOperator(Operator.LESS);
        LiteralRestriction lr4 = new LiteralRestriction();
        lr4.setOrderNumber(1);
        lr4.setFieldId(field2.getId());
        lr4.setValue("1");
        lr4.setOperator(Operator.LESS_OR_EQUAL);
        Field field3 = new Field();
        LiteralRestriction lr5 = new LiteralRestriction();
        lr5.setOrderNumber(0);
        lr5.setFieldId(field3.getId());
        lr5.setValue("10-dec-2008");
        lr5.setOperator(Operator.LESS);
        LiteralRestriction lr6 = new LiteralRestriction();
        lr6.setOrderNumber(1);
        lr6.setFieldId(field3.getId());
        lr6.setValue("10-dec-2005");
        lr6.setOperator(Operator.EQUAL);
        data.add(lr1);
        data.add(lr2);
        data.add(lr3);
        data.add(lr4);
        data.add(lr5);
        data.add(lr6);
        StatelessSessionResult sessionResult = session.executeWithResults(data);
        Map<Cause, Set<Cause>> map = this.createSubsumptionMap(sessionResult.iterateObjects());
        SubsumptantRestrictionsTest.assertTrue((boolean)TestBase.causeMapContains(map, (Cause)lr1, (Cause)lr2));
        SubsumptantRestrictionsTest.assertTrue((boolean)TestBase.causeMapContains(map, (Cause)lr3, (Cause)lr4));
        SubsumptantRestrictionsTest.assertTrue((boolean)TestBase.causeMapContains(map, (Cause)lr5, (Cause)lr6));
        if (!map.isEmpty()) {
            SubsumptantRestrictionsTest.fail((String)"More redundancies than was expected.");
        }
    }
}

