/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier;

import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.drools.builder.ResourceType;
import org.drools.io.ResourceFactory;
import org.drools.verifier.Verifier;
import org.drools.verifier.builder.VerifierBuilderFactory;
import org.drools.verifier.components.Field;
import org.drools.verifier.components.ObjectType;
import org.drools.verifier.components.VerifierComponentType;
import org.drools.verifier.data.VerifierReport;
import org.drools.verifier.report.VerifierReportWriter;
import org.drools.verifier.report.VerifierReportWriterFactory;
import org.drools.verifier.report.components.Cause;
import org.drools.verifier.report.components.Severity;
import org.drools.verifier.report.components.VerifierMessage;
import org.drools.verifier.report.components.VerifierMessageBase;
import org.drools.verifier.report.components.VerifierRangeCheckMessage;

class VerifierTestStandalone {
    VerifierTestStandalone() {
    }

    public static final void main(String[] args) {
        try {
            ArrayList<String> fileNames = new ArrayList<String>();
            fileNames.add("Enums.drl");
            Verifier verifier = VerifierBuilderFactory.newVerifierBuilder().newVerifier();
            for (String s : fileNames) {
                verifier.addResourcesToVerify(ResourceFactory.newClassPathResource((String)s, Verifier.class), ResourceType.DRL);
            }
            verifier.fireAnalysis();
            VerifierReport result = verifier.getResult();
            VerifierReportWriter reportwriter = VerifierReportWriterFactory.newHTMLReportWriter();
            FileOutputStream out = new FileOutputStream("/Users/rikkola/Desktop/testReport.zip");
            reportwriter.writeReport((OutputStream)out, result);
            Collection msgs = result.getBySeverity(Severity.ERROR);
            for (VerifierMessageBase msg : msgs) {
                System.out.println("ERR: " + msg.getMessage());
            }
            msgs = result.getBySeverity(Severity.WARNING);
            for (VerifierMessageBase msg : msgs) {
                VerifierMessage amsg;
                System.out.println("WARN (" + msg.getClass().getSimpleName() + "): " + msg.getMessage());
                System.out.println("\t FAULT: [" + msg.getClass().getSimpleName() + "] " + msg.getFaulty());
                if (msg instanceof VerifierMessage) {
                    System.out.println("\t CAUSES (message):");
                    amsg = (VerifierMessage)msg;
                    for (Cause c : amsg.getCauses()) {
                        System.out.println("\t\t [" + c.getClass().getSimpleName() + "]" + c);
                    }
                    continue;
                }
                if (!(msg instanceof VerifierRangeCheckMessage)) continue;
                System.out.println("\t CAUSES (range):");
                amsg = (VerifierRangeCheckMessage)msg;
                for (Cause c : amsg.getCauses()) {
                    System.out.println("\t\t" + c);
                }
            }
            msgs = result.getBySeverity(Severity.NOTE);
            for (VerifierMessageBase msg : msgs) {
                System.out.println("NOTE: " + msg.getMessage());
                System.out.println("\t" + msg.getFaulty());
            }
            Collection classes = result.getVerifierData().getAll(VerifierComponentType.OBJECT_TYPE);
            for (ObjectType c : classes) {
                Collection cr = result.getVerifierData().getRulesByObjectTypePath(c.getPath());
                System.err.println("Class rules:" + cr);
                Set flds = c.getFields();
                for (Field f : flds) {
                    cr = result.getVerifierData().getRulesByFieldPath(f.getPath());
                    System.err.println("Field rules: " + cr);
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

