/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.visitor;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.drools.compiler.DrlParser;
import org.drools.compiler.DroolsParserException;
import org.drools.lang.descr.PackageDescr;
import org.drools.verifier.Verifier;
import org.drools.verifier.components.SubPattern;
import org.drools.verifier.components.SubRule;
import org.drools.verifier.components.VerifierComponentType;
import org.drools.verifier.data.VerifierComponent;
import org.drools.verifier.data.VerifierData;
import org.drools.verifier.data.VerifierReportFactory;
import org.drools.verifier.visitor.PackageDescrVisitor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PackageDescrVisitorTest {
    private VerifierData verifierData;
    private PackageDescrVisitor packageDescrVisitor;

    @Before
    public void setUp() throws Exception {
        this.verifierData = VerifierReportFactory.newVerifierData();
        this.packageDescrVisitor = new PackageDescrVisitor(this.verifierData, Collections.EMPTY_LIST);
    }

    @Test
    public void testVisit() throws Exception {
        PackageDescr packageDescr = this.getPackageDescr(Verifier.class.getResourceAsStream("Misc3.drl"));
        Assert.assertNotNull((Object)packageDescr);
        this.packageDescrVisitor.visitPackageDescr(packageDescr);
        Collection all = this.verifierData.getAll();
        HashSet<String> names = new HashSet<String>();
        for (VerifierComponent verifierComponent : all) {
            String path = verifierComponent.getPath();
            System.out.println("-" + verifierComponent);
            if (verifierComponent.getDescr() != null) {
                System.out.println(" \n\t\t => " + verifierComponent.getDescr().getLine() + ":" + verifierComponent.getDescr().getEndLine() + " " + verifierComponent.getDescr().getText());
            } else {
                System.out.println(" \n\t\t => null for " + verifierComponent.getClass().getSimpleName());
            }
            if (names.contains(path)) {
                Assert.fail((String)("Dublicate path " + path));
                continue;
            }
            names.add(path);
        }
        Assert.assertNotNull((Object)all);
        Assert.assertEquals((long)45L, (long)all.size());
    }

    @Test
    public void testSubPatterns() throws Exception {
        PackageDescr packageDescr = this.getPackageDescr(this.getClass().getResourceAsStream("SubPattern.drl"));
        Assert.assertNotNull((Object)packageDescr);
        this.packageDescrVisitor.visitPackageDescr(packageDescr);
        Collection all = this.verifierData.getAll();
        Assert.assertNotNull((Object)all);
        SubPattern test1SubPattern = null;
        SubPattern test2SubPattern = null;
        SubRule test1SubRule = null;
        SubRule test2SubRule = null;
        for (VerifierComponent verifierComponent : all) {
            System.out.println("-" + verifierComponent);
            if (verifierComponent.getDescr() != null) {
                System.out.println(" \n\t\t => " + verifierComponent.getDescr().getLine() + ":" + verifierComponent.getDescr().getEndLine() + " " + verifierComponent.getDescr().getText());
            } else {
                System.out.println(" \n\t\t => null for " + verifierComponent.getClass().getSimpleName());
            }
            if (verifierComponent.getVerifierComponentType().equals(VerifierComponentType.SUB_PATTERN)) {
                SubPattern subPattern = (SubPattern)verifierComponent;
                if ("Test 1".equals(subPattern.getRuleName())) {
                    Assert.assertNull(test1SubPattern);
                    test1SubPattern = subPattern;
                } else if ("Test 2".equals(subPattern.getRuleName())) {
                    Assert.assertNull(test2SubPattern);
                    test2SubPattern = subPattern;
                }
            }
            if (!verifierComponent.getVerifierComponentType().equals(VerifierComponentType.SUB_RULE)) continue;
            SubRule subRule = (SubRule)verifierComponent;
            if ("Test 1".equals(subRule.getRuleName())) {
                Assert.assertNull(test1SubRule);
                test1SubRule = subRule;
                continue;
            }
            if (!"Test 2".equals(subRule.getRuleName())) continue;
            Assert.assertNull(test2SubRule);
            test2SubRule = subRule;
        }
        Assert.assertNotNull(test1SubPattern);
        Assert.assertEquals((long)3L, (long)test1SubPattern.getItems().size());
        Assert.assertNotNull(test2SubPattern);
        Assert.assertEquals((long)3L, (long)test2SubPattern.getItems().size());
        Assert.assertNotNull(test1SubRule);
        Assert.assertEquals((long)1L, (long)test1SubRule.getItems().size());
        Assert.assertNotNull(test2SubRule);
        Assert.assertEquals((long)1L, (long)test2SubRule.getItems().size());
    }

    private PackageDescr getPackageDescr(InputStream resourceAsStream) throws DroolsParserException {
        InputStreamReader drlReader = new InputStreamReader(resourceAsStream);
        return new DrlParser().parse((Reader)drlReader);
    }
}

