/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier;

import java.io.IOException;
import java.util.Collection;
import java.util.jar.JarInputStream;
import org.drools.io.impl.ClassPathResource;
import org.drools.verifier.Verifier;
import org.drools.verifier.VerifierConfiguration;
import org.drools.verifier.VerifierError;
import org.drools.verifier.builder.VerifierBuilder;
import org.drools.verifier.builder.VerifierBuilderFactory;
import org.drools.verifier.components.ObjectType;
import org.drools.verifier.components.VerifierComponentType;
import org.drools.verifier.data.VerifierReport;
import org.drools.verifier.report.components.Severity;
import org.drools.verifier.report.components.VerifierMessageBase;
import org.junit.Assert;
import org.junit.Test;
import org.kie.io.Resource;
import org.kie.io.ResourceType;

public class VerifierTest {
    @Test
    public void testVerifier() {
        VerifierBuilder vBuilder = VerifierBuilderFactory.newVerifierBuilder();
        Assert.assertFalse((boolean)vBuilder.hasErrors());
        Assert.assertEquals((long)0L, (long)vBuilder.getErrors().size());
        Verifier verifier = vBuilder.newVerifier();
        verifier.addResourcesToVerify((Resource)new ClassPathResource("Misc3.drl", Verifier.class), ResourceType.DRL);
        Assert.assertFalse((boolean)verifier.hasErrors());
        Assert.assertEquals((long)0L, (long)verifier.getErrors().size());
        boolean works = verifier.fireAnalysis();
        Assert.assertTrue((boolean)works);
        VerifierReport result = verifier.getResult();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)0L, (long)result.getBySeverity(Severity.ERROR).size());
        Assert.assertEquals((long)6L, (long)result.getBySeverity(Severity.WARNING).size());
        Assert.assertEquals((long)1L, (long)result.getBySeverity(Severity.NOTE).size());
    }

    @Test
    public void testFactTypesFromJar() {
        VerifierBuilder vBuilder = VerifierBuilderFactory.newVerifierBuilder();
        Assert.assertFalse((boolean)vBuilder.hasErrors());
        Assert.assertEquals((long)0L, (long)vBuilder.getErrors().size());
        Verifier verifier = vBuilder.newVerifier();
        try {
            JarInputStream jar = new JarInputStream(this.getClass().getResourceAsStream("model.jar"));
            verifier.addObjectModel(jar);
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
        verifier.addResourcesToVerify((Resource)new ClassPathResource("imports.drl", Verifier.class), ResourceType.DRL);
        Assert.assertFalse((boolean)verifier.hasErrors());
        Assert.assertEquals((long)0L, (long)verifier.getErrors().size());
        boolean works = verifier.fireAnalysis();
        Assert.assertTrue((boolean)works);
        VerifierReport result = verifier.getResult();
        Collection objectTypes = result.getVerifierData().getAll(VerifierComponentType.OBJECT_TYPE);
        Assert.assertNotNull((Object)objectTypes);
        Assert.assertEquals((long)3L, (long)objectTypes.size());
        Collection fields = result.getVerifierData().getAll(VerifierComponentType.FIELD);
        Assert.assertNotNull((Object)fields);
        Assert.assertEquals((long)10L, (long)fields.size());
    }

    @Test
    public void testFactTypesFromJarAndDeclarations() {
        VerifierBuilder vBuilder = VerifierBuilderFactory.newVerifierBuilder();
        Assert.assertFalse((boolean)vBuilder.hasErrors());
        Assert.assertEquals((long)0L, (long)vBuilder.getErrors().size());
        Verifier verifier = vBuilder.newVerifier();
        try {
            JarInputStream jar = new JarInputStream(this.getClass().getResourceAsStream("model.jar"));
            verifier.addObjectModel(jar);
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
        verifier.addResourcesToVerify((Resource)new ClassPathResource("importsAndDeclarations.drl", Verifier.class), ResourceType.DRL);
        Assert.assertFalse((boolean)verifier.hasErrors());
        Assert.assertEquals((long)0L, (long)verifier.getErrors().size());
        boolean works = verifier.fireAnalysis();
        Assert.assertTrue((boolean)works);
        VerifierReport result = verifier.getResult();
        Collection objectTypes = result.getVerifierData().getAll(VerifierComponentType.OBJECT_TYPE);
        for (ObjectType objectType : objectTypes) {
            if (!objectType.getName().equals("VoiceCall")) continue;
            Assert.assertEquals((long)4L, (long)objectType.getMetadata().keySet().size());
        }
        Assert.assertNotNull((Object)objectTypes);
        Assert.assertEquals((long)4L, (long)objectTypes.size());
        Collection fields = result.getVerifierData().getAll(VerifierComponentType.FIELD);
        Assert.assertNotNull((Object)fields);
        Assert.assertEquals((long)11L, (long)fields.size());
    }

    @Test
    public void testCustomRule() {
        VerifierBuilder vBuilder = VerifierBuilderFactory.newVerifierBuilder();
        VerifierConfiguration vConfiguration = vBuilder.newVerifierConfiguration();
        Assert.assertFalse((boolean)vBuilder.hasErrors());
        Assert.assertEquals((long)0L, (long)vBuilder.getErrors().size());
        vConfiguration.getVerifyingResources().put(new ClassPathResource("FindPatterns.drl", Verifier.class), ResourceType.DRL);
        Verifier verifier = vBuilder.newVerifier(vConfiguration);
        verifier.addResourcesToVerify((Resource)new ClassPathResource("Misc3.drl", Verifier.class), ResourceType.DRL);
        Assert.assertFalse((boolean)verifier.hasErrors());
        Assert.assertEquals((long)0L, (long)verifier.getErrors().size());
        boolean works = verifier.fireAnalysis();
        if (!works) {
            for (VerifierError error : verifier.getErrors()) {
                System.out.println(error.getMessage());
            }
            Assert.fail((String)"Could not run verifier");
        }
        Assert.assertTrue((boolean)works);
        VerifierReport result = verifier.getResult();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)0L, (long)result.getBySeverity(Severity.ERROR).size());
        Assert.assertEquals((long)0L, (long)result.getBySeverity(Severity.WARNING).size());
        Assert.assertEquals((long)6L, (long)result.getBySeverity(Severity.NOTE).size());
        for (VerifierMessageBase m : result.getBySeverity(Severity.NOTE)) {
            Assert.assertEquals((Object)"This pattern was found.", (Object)m.getMessage());
        }
    }
}

