/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.opposites;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.drools.StatelessSession;
import org.drools.StatelessSessionResult;
import org.drools.base.RuleNameMatchesAgendaFilter;
import org.drools.base.evaluators.Operator;
import org.drools.spi.AgendaFilter;
import org.drools.verifier.TestBaseOld;
import org.drools.verifier.VerifierComponentMockFactory;
import org.drools.verifier.components.LiteralRestriction;
import org.drools.verifier.components.Pattern;
import org.drools.verifier.components.PatternVariable;
import org.drools.verifier.components.Variable;
import org.drools.verifier.components.VariableRestriction;
import org.drools.verifier.components.VerifierComponentType;
import org.drools.verifier.components.VerifierRule;
import org.drools.verifier.opposites.OppositesBase;
import org.drools.verifier.report.components.Cause;
import org.junit.Assert;
import org.junit.Test;

public class OppositeRestrictionsTest
extends OppositesBase {
    @Test
    public void testLiteralRestrictionOpposite() throws Exception {
        StatelessSession session = this.getStatelessSession(this.getClass().getResourceAsStream("Restrictions.drl"));
        session.setAgendaFilter((AgendaFilter)new RuleNameMatchesAgendaFilter("Opposite LiteralRestrictions"));
        ArrayList<LiteralRestriction> data = new ArrayList<LiteralRestriction>();
        Pattern pattern = VerifierComponentMockFactory.createPattern1();
        LiteralRestriction r1 = LiteralRestriction.createRestriction((Pattern)pattern, (String)"1");
        r1.setFieldPath("0");
        r1.setOperator(Operator.EQUAL);
        r1.setOrderNumber(0);
        LiteralRestriction r2 = LiteralRestriction.createRestriction((Pattern)pattern, (String)"1");
        r2.setFieldPath("0");
        r2.setOperator(Operator.NOT_EQUAL);
        r2.setOrderNumber(1);
        LiteralRestriction r3 = LiteralRestriction.createRestriction((Pattern)pattern, (String)"1.0");
        r3.setFieldPath("0");
        r3.setOperator(Operator.EQUAL);
        r3.setOrderNumber(2);
        LiteralRestriction r4 = LiteralRestriction.createRestriction((Pattern)pattern, (String)"1.0");
        r4.setFieldPath("0");
        r4.setOperator(Operator.NOT_EQUAL);
        r4.setOrderNumber(3);
        data.add(r1);
        data.add(r2);
        data.add(r3);
        data.add(r4);
        StatelessSessionResult sessionResult = session.executeWithResults(data);
        Map<Cause, Set<Cause>> map = this.createOppositesMap(VerifierComponentType.RESTRICTION, sessionResult.iterateObjects());
        Assert.assertTrue((boolean)(TestBaseOld.causeMapContains(map, (Cause)r1, (Cause)r2) ^ TestBaseOld.causeMapContains(map, (Cause)r2, (Cause)r1)));
        Assert.assertTrue((boolean)(TestBaseOld.causeMapContains(map, (Cause)r3, (Cause)r4) ^ TestBaseOld.causeMapContains(map, (Cause)r4, (Cause)r3)));
        if (!map.isEmpty()) {
            Assert.fail((String)"More opposites than was expected.");
        }
    }

    @Test
    public void testLiteralRestrictionOppositeWithRangesGreaterOrEqualAndLess() throws Exception {
        StatelessSession session = this.getStatelessSession(this.getClass().getResourceAsStream("Restrictions.drl"));
        session.setAgendaFilter((AgendaFilter)new RuleNameMatchesAgendaFilter("Opposite LiteralRestrictions with ranges, greater or equal - less"));
        ArrayList<LiteralRestriction> data = new ArrayList<LiteralRestriction>();
        Pattern pattern = VerifierComponentMockFactory.createPattern1();
        LiteralRestriction r1 = LiteralRestriction.createRestriction((Pattern)pattern, (String)"1");
        r1.setFieldPath("0");
        r1.setOperator(Operator.GREATER_OR_EQUAL);
        r1.setOrderNumber(0);
        LiteralRestriction r2 = LiteralRestriction.createRestriction((Pattern)pattern, (String)"1");
        r2.setFieldPath("0");
        r2.setOperator(Operator.LESS);
        r2.setOrderNumber(1);
        data.add(r1);
        data.add(r2);
        StatelessSessionResult sessionResult = session.executeWithResults(data);
        Map<Cause, Set<Cause>> map = this.createOppositesMap(VerifierComponentType.RESTRICTION, sessionResult.iterateObjects());
        Assert.assertTrue((boolean)(TestBaseOld.causeMapContains(map, (Cause)r1, (Cause)r2) ^ TestBaseOld.causeMapContains(map, (Cause)r2, (Cause)r1)));
        if (!map.isEmpty()) {
            Assert.fail((String)"More opposites than was expected.");
        }
    }

    @Test
    public void testLiteralRestrictionOppositeWithRangesGreaterAndLessOrEqual() throws Exception {
        StatelessSession session = this.getStatelessSession(this.getClass().getResourceAsStream("Restrictions.drl"));
        session.setAgendaFilter((AgendaFilter)new RuleNameMatchesAgendaFilter("Opposite LiteralRestrictions with ranges, greater - less or equal"));
        ArrayList<LiteralRestriction> data = new ArrayList<LiteralRestriction>();
        Pattern pattern = VerifierComponentMockFactory.createPattern1();
        LiteralRestriction r1 = LiteralRestriction.createRestriction((Pattern)pattern, (String)"1");
        r1.setFieldPath("0");
        r1.setOperator(Operator.GREATER);
        r1.setOrderNumber(0);
        LiteralRestriction r2 = LiteralRestriction.createRestriction((Pattern)pattern, (String)"1");
        r2.setFieldPath("0");
        r2.setOperator(Operator.LESS_OR_EQUAL);
        r2.setOrderNumber(1);
        data.add(r1);
        data.add(r2);
        StatelessSessionResult sessionResult = session.executeWithResults(data);
        Map<Cause, Set<Cause>> map = this.createOppositesMap(VerifierComponentType.RESTRICTION, sessionResult.iterateObjects());
        Assert.assertTrue((boolean)(TestBaseOld.causeMapContains(map, (Cause)r1, (Cause)r2) ^ TestBaseOld.causeMapContains(map, (Cause)r2, (Cause)r1)));
        if (!map.isEmpty()) {
            Assert.fail((String)"More opposites than was expected.");
        }
    }

    @Test
    public void testLiteralRestrictionOppositeWithRangesLessOrEqualAndGreaterOrEqualForIntsAndDates() throws Exception {
        StatelessSession session = this.getStatelessSession(this.getClass().getResourceAsStream("Restrictions.drl"));
        session.setAgendaFilter((AgendaFilter)new RuleNameMatchesAgendaFilter("Opposite LiteralRestrictions with ranges, less or equal - greater or equal for ints and dates"));
        ArrayList<LiteralRestriction> data = new ArrayList<LiteralRestriction>();
        Pattern pattern = VerifierComponentMockFactory.createPattern1();
        LiteralRestriction r1 = LiteralRestriction.createRestriction((Pattern)pattern, (String)"1");
        r1.setFieldPath("0");
        r1.setOperator(Operator.GREATER_OR_EQUAL);
        r1.setOrderNumber(0);
        LiteralRestriction r2 = LiteralRestriction.createRestriction((Pattern)pattern, (String)"0");
        r2.setFieldPath("0");
        r2.setOperator(Operator.LESS_OR_EQUAL);
        r2.setOrderNumber(1);
        data.add(r1);
        data.add(r2);
        StatelessSessionResult sessionResult = session.executeWithResults(data);
        Map<Cause, Set<Cause>> map = this.createOppositesMap(VerifierComponentType.RESTRICTION, sessionResult.iterateObjects());
        Assert.assertTrue((boolean)(TestBaseOld.causeMapContains(map, (Cause)r1, (Cause)r2) ^ TestBaseOld.causeMapContains(map, (Cause)r2, (Cause)r1)));
        if (!map.isEmpty()) {
            Assert.fail((String)"More opposites than was expected.");
        }
    }

    @Test
    public void testVariableRestrictionOpposite() throws Exception {
        StatelessSession session = this.getStatelessSession(this.getClass().getResourceAsStream("Restrictions.drl"));
        session.setAgendaFilter((AgendaFilter)new RuleNameMatchesAgendaFilter("Opposite VariableRestrictions"));
        ArrayList<VariableRestriction> data = new ArrayList<VariableRestriction>();
        VerifierRule rule = VerifierComponentMockFactory.createRule1();
        Pattern pattern1 = VerifierComponentMockFactory.createPattern(1);
        Pattern pattern2 = VerifierComponentMockFactory.createPattern(2);
        Pattern pattern3 = VerifierComponentMockFactory.createPattern(3);
        PatternVariable variable1 = new PatternVariable(rule);
        variable1.setParentPath("1");
        variable1.setParentType(VerifierComponentType.FIELD);
        variable1.setOrderNumber(-1);
        VariableRestriction r1 = new VariableRestriction(pattern1);
        r1.setFieldPath("0");
        r1.setOperator(Operator.GREATER_OR_EQUAL);
        r1.setVariable((Variable)variable1);
        r1.setOrderNumber(0);
        VariableRestriction r2 = new VariableRestriction(pattern1);
        r2.setFieldPath("0");
        r2.setOperator(Operator.LESS);
        r2.setVariable((Variable)variable1);
        r2.setOrderNumber(1);
        String containsOperator = "contains";
        PatternVariable variable2 = new PatternVariable(rule);
        variable2.setParentPath("2");
        variable2.setParentType(VerifierComponentType.FIELD);
        variable2.setOrderNumber(3);
        VariableRestriction r3 = new VariableRestriction(pattern2);
        r3.setFieldPath("1");
        r3.setOperator(Operator.determineOperator((String)containsOperator, (boolean)false));
        r3.setVariable((Variable)variable2);
        r3.setOrderNumber(4);
        VariableRestriction r4 = new VariableRestriction(pattern2);
        r4.setFieldPath("1");
        r4.setOperator(Operator.determineOperator((String)containsOperator, (boolean)true));
        r4.setVariable((Variable)variable2);
        r4.setOrderNumber(5);
        PatternVariable variable3 = new PatternVariable(rule);
        variable3.setParentPath("3");
        variable3.setParentType(VerifierComponentType.FIELD);
        variable3.setOrderNumber(6);
        VariableRestriction r5 = new VariableRestriction(pattern3);
        r5.setFieldPath("1");
        r5.setOperator(Operator.GREATER_OR_EQUAL);
        r5.setVariable((Variable)variable3);
        r5.setOrderNumber(7);
        VariableRestriction r6 = new VariableRestriction(pattern3);
        r6.setFieldPath("1");
        r6.setOperator(Operator.EQUAL);
        r6.setVariable((Variable)variable3);
        r6.setOrderNumber(8);
        data.add(r1);
        data.add(r2);
        data.add(r3);
        data.add(r4);
        data.add(r5);
        data.add(r6);
        StatelessSessionResult sessionResult = session.executeWithResults(data);
        Map<Cause, Set<Cause>> map = this.createOppositesMap(VerifierComponentType.RESTRICTION, sessionResult.iterateObjects());
        Assert.assertTrue((boolean)(TestBaseOld.causeMapContains(map, (Cause)r1, (Cause)r2) ^ TestBaseOld.causeMapContains(map, (Cause)r2, (Cause)r1)));
        Assert.assertTrue((boolean)(TestBaseOld.causeMapContains(map, (Cause)r3, (Cause)r4) ^ TestBaseOld.causeMapContains(map, (Cause)r4, (Cause)r3)));
        if (!map.isEmpty()) {
            Assert.fail((String)"More opposites than was expected.");
        }
    }
}

