/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.components;

import java.util.HashSet;
import java.util.Set;
import org.drools.verifier.components.Pattern;
import org.drools.verifier.components.PatternComponent;
import org.drools.verifier.components.Possibility;
import org.drools.verifier.components.VerifierComponentType;

public class SubPattern
extends PatternComponent
implements Possibility {
    private static final long serialVersionUID = 510L;
    private final Pattern pattern;
    private Set<PatternComponent> items = new HashSet<PatternComponent>();

    public SubPattern(Pattern pattern, int orderNumber) {
        super(pattern);
        this.pattern = pattern;
        this.setOrderNumber(orderNumber);
    }

    @Override
    public String getPath() {
        return String.format("%s/subPattern[%s]", this.getPatternPath(), this.getOrderNumber());
    }

    public String getSourcePath() {
        return this.pattern.getSourcePath();
    }

    public VerifierComponentType getSourceType() {
        return this.pattern.getSourceType();
    }

    public String getName() {
        return this.pattern.getName();
    }

    public String getObjectTypePath() {
        return this.pattern.getObjectTypePath();
    }

    public boolean isPatternNot() {
        return this.pattern.isPatternNot();
    }

    public boolean isPatternExists() {
        return this.pattern.isPatternExists();
    }

    public boolean isPatternForall() {
        return this.pattern.isPatternForall();
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public Set<PatternComponent> getItems() {
        return this.items;
    }

    @Override
    public int getAmountOfItems() {
        return this.items.size();
    }

    public void add(PatternComponent patternComponent) {
        this.items.add(patternComponent);
    }

    @Override
    public String toString() {
        return "SubPattern from rule: " + this.getRuleName() + ", amount of items:" + this.items.size();
    }

    @Override
    public VerifierComponentType getVerifierComponentType() {
        return VerifierComponentType.SUB_PATTERN;
    }
}

