/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.visitor;

import org.drools.lang.descr.AndDescr;
import org.drools.lang.descr.AttributeDescr;
import org.drools.lang.descr.BaseDescr;
import org.drools.lang.descr.EvalDescr;
import org.drools.lang.descr.ExistsDescr;
import org.drools.lang.descr.ForallDescr;
import org.drools.lang.descr.NotDescr;
import org.drools.lang.descr.OrDescr;
import org.drools.lang.descr.PatternDescr;
import org.drools.lang.descr.RuleDescr;
import org.drools.verifier.components.Consequence;
import org.drools.verifier.components.OperatorDescrType;
import org.drools.verifier.components.RuleEval;
import org.drools.verifier.components.RuleOperatorDescr;
import org.drools.verifier.components.RulePackage;
import org.drools.verifier.components.SubPattern;
import org.drools.verifier.components.SubRule;
import org.drools.verifier.components.TextConsequence;
import org.drools.verifier.components.VerifierRule;
import org.drools.verifier.data.VerifierComponent;
import org.drools.verifier.data.VerifierData;
import org.drools.verifier.solver.Solvers;
import org.drools.verifier.visitor.ConditionalElementDescrVisitor;
import org.drools.verifier.visitor.PatternDescrVisitor;
import org.drools.verifier.visitor.UnknownDescriptionException;

public class RuleDescrVisitor
extends ConditionalElementDescrVisitor {
    private final RulePackage rulePackage;

    public RuleDescrVisitor(VerifierData data, RulePackage rulePackage) {
        super(data, new Solvers());
        this.rulePackage = rulePackage;
    }

    public void visitRuleDescr(RuleDescr descr) throws UnknownDescriptionException {
        this.rule = new VerifierRule((BaseDescr)descr, this.rulePackage);
        this.rule.setName(descr.getName());
        for (AttributeDescr attribute : descr.getAttributes().values()) {
            this.rule.getAttributes().put(attribute.getName(), attribute.getValue());
        }
        Consequence consequence = this.visitConsequence(this.rule, descr.getConsequence());
        this.rule.setConsequencePath(consequence.getPath());
        this.rule.setConsequenceType(consequence.getConsequenceType());
        this.rule.setLineNumber(descr.getLine());
        this.data.add(this.rule);
        this.rulePackage.getRules().add(this.rule);
        this.solvers.startRuleSolver(this.rule);
        this.visitAndDescr(descr.getLhs());
        this.solvers.endRuleSolver();
        this.addSubItems();
    }

    @Override
    protected VerifierComponent getParent() {
        return this.rule;
    }

    @Override
    public void visit(Object descr) throws UnknownDescriptionException {
        if (descr instanceof AndDescr) {
            this.visitAndDescr((AndDescr)descr);
        } else if (descr instanceof EvalDescr) {
            this.visitEvalDescr((EvalDescr)descr);
        } else if (descr instanceof ExistsDescr) {
            this.visitExistsDescr((ExistsDescr)descr);
        } else if (descr instanceof ForallDescr) {
            this.visitForallDescr((ForallDescr)descr);
        } else if (descr instanceof NotDescr) {
            this.visitNotDescr((NotDescr)descr);
        } else if (descr instanceof OrDescr) {
            this.visitOrDescr((OrDescr)descr);
        } else if (descr instanceof PatternDescr) {
            this.visitPattern((PatternDescr)descr);
        } else {
            throw new UnknownDescriptionException((BaseDescr)descr);
        }
    }

    private void visitNotDescr(NotDescr descr) throws UnknownDescriptionException {
        this.solvers.startNot();
        this.visit(descr.getDescrs());
        this.solvers.endNot();
    }

    private void visitForallDescr(ForallDescr descr) throws UnknownDescriptionException {
        this.solvers.startForall();
        this.visit(descr.getDescrs());
        this.solvers.endForall();
    }

    private void visitExistsDescr(ExistsDescr descr) throws UnknownDescriptionException {
        this.solvers.startExists();
        this.visit(descr.getDescrs());
        this.solvers.endExists();
    }

    private RuleEval visitEvalDescr(EvalDescr descr) {
        RuleEval eval = new RuleEval(this.rule);
        eval.setContent(descr.getContent().toString());
        eval.setClassMethodName(descr.getClassMethodName());
        eval.setOrderNumber(this.orderNumber.next());
        eval.setParentPath(this.rule.getPath());
        eval.setParentType(this.rule.getVerifierComponentType());
        this.solvers.addRuleComponent(eval);
        this.data.add(eval);
        return eval;
    }

    private Consequence visitConsequence(VerifierComponent parent, Object o) {
        TextConsequence consequence = new TextConsequence(this.rule);
        String text = o.toString();
        StringBuffer buffer = new StringBuffer(text);
        int commentIndex = buffer.indexOf("//");
        while (commentIndex != -1) {
            buffer = buffer.delete(commentIndex, buffer.indexOf("\n", commentIndex));
            commentIndex = buffer.indexOf("//");
        }
        text = buffer.toString();
        text = text.replaceAll("\n", "");
        text = text.replaceAll("\r", "");
        text = text.replaceAll("\t", "");
        text = text.replaceAll(" ", "");
        consequence.setText(text);
        consequence.setParentPath(parent.getPath());
        consequence.setParentType(parent.getVerifierComponentType());
        this.data.add(consequence);
        return consequence;
    }

    private void visitPattern(PatternDescr descr) throws UnknownDescriptionException {
        PatternDescrVisitor visitor = new PatternDescrVisitor(this.data, this.rule, this.solvers);
        visitor.visit(descr, this.orderNumber.next());
    }

    private void addSubItems() {
        for (SubPattern subPattern : this.solvers.getPatternPossibilities()) {
            this.data.add(subPattern);
        }
        for (SubRule subRule : this.solvers.getRulePossibilities()) {
            this.data.add(subRule);
        }
    }

    @Override
    protected void visitAndDescr(AndDescr descr) throws UnknownDescriptionException {
        RuleOperatorDescr operatorDescr = new RuleOperatorDescr((BaseDescr)descr, this.rule, OperatorDescrType.AND);
        operatorDescr.setOrderNumber(this.orderNumber.next());
        operatorDescr.setParentPath(this.getParent().getPath());
        operatorDescr.setParentType(this.getParent().getVerifierComponentType());
        this.data.add(operatorDescr);
        this.solvers.startOperator(OperatorDescrType.AND);
        this.visit(descr.getDescrs());
        this.solvers.endOperator();
    }

    @Override
    protected void visitOrDescr(OrDescr descr) throws UnknownDescriptionException {
        RuleOperatorDescr operatorDescr = new RuleOperatorDescr((BaseDescr)descr, this.rule, OperatorDescrType.OR);
        operatorDescr.setOrderNumber(this.orderNumber.next());
        this.data.add(operatorDescr);
        this.solvers.startOperator(OperatorDescrType.OR);
        this.visit(descr.getDescrs());
        this.solvers.endOperator();
    }
}

