/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.misc;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.util.List;
import org.drools.verifier.misc.DrlPackageParser;
import org.drools.verifier.misc.DrlRuleParser;
import org.junit.Assert;
import org.junit.Test;

public class DrlPackageDataTest {
    @Test
    public void testHandleDrl() throws ParseException {
        String drl = "";
        drl = drl + "package org.drools.test\n";
        drl = drl + "global java.util.List list\n";
        drl = drl + "rule rule1\n";
        drl = drl + "when\n";
        drl = drl + "then\n";
        drl = drl + "list.add( drools.getRule().getName() );\n";
        drl = drl + "end\n";
        drl = drl + "rule rule2\n";
        drl = drl + "when\n";
        drl = drl + "then\n";
        drl = drl + "list.add( drools.getRule().getName() );\n";
        drl = drl + "end\n";
        DrlPackageParser s = DrlPackageParser.findPackageDataFromDrl((String)drl);
        Assert.assertEquals((Object)"org.drools.test", (Object)s.getName());
        Assert.assertEquals((long)2L, (long)s.getRules().size());
        Assert.assertEquals((Object)"", (Object)s.getDescription());
    }

    @Test
    public void testHandleDrl2() throws IOException, ParseException {
        String str;
        BufferedReader in = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("DrlPackageTestData.drl")));
        String rule = "";
        while ((str = in.readLine()) != null) {
            rule = rule + str;
            rule = rule + "\n";
        }
        in.close();
        DrlPackageParser s = DrlPackageParser.findPackageDataFromDrl((String)rule);
        Assert.assertNotNull((Object)s);
        Assert.assertEquals((Object)"org.drools.test", (Object)s.getName());
        Assert.assertEquals((long)5L, (long)s.getRules().size());
        Assert.assertEquals((Object)"", (Object)s.getDescription());
    }

    @Test
    public void testHandleDrlNoPackageData() {
        String drl = "";
        drl = drl + "rule rule1\n";
        drl = drl + "    when\n";
        drl = drl + "    then\n";
        drl = drl + "        list.add( drools.getRule().getName() );\n";
        drl = drl + "end\n";
        boolean exception = false;
        try {
            DrlPackageParser drlPackageParser = DrlPackageParser.findPackageDataFromDrl((String)drl);
        }
        catch (ParseException e) {
            exception = true;
        }
        if (!exception) {
            Assert.fail((String)"Should have thrown a ParseException.");
        }
    }

    @Test
    public void testHandleDrlWithComments() throws ParseException {
        String drl = "";
        drl = drl + "# important information\n";
        drl = drl + "# about this package\n";
        drl = drl + "# it contains some rules\n";
        drl = drl + "package org.drools.test\n";
        drl = drl + "global java.util.List list\n";
        drl = drl + "rule rule1\n";
        drl = drl + "\twhen\n";
        drl = drl + "\tthen\n";
        drl = drl + "\t\tlist.add( drools.getRule().getName() );\n";
        drl = drl + "end\n";
        drl = drl + "rule rule2\n";
        drl = drl + "\twhen\n";
        drl = drl + "\tthen\n";
        drl = drl + "\t\tlist.add( drools.getRule().getName() );\n";
        drl = drl + "end\n";
        DrlPackageParser data = DrlPackageParser.findPackageDataFromDrl((String)drl);
        Assert.assertEquals((Object)"org.drools.test", (Object)data.getName());
        Assert.assertEquals((long)2L, (long)data.getRules().size());
        Assert.assertEquals((long)1L, (long)data.getGlobals().size());
        Assert.assertEquals((Object)"java.util.List list", data.getGlobals().get(0));
        Assert.assertEquals((Object)"important information\nabout this package\nit contains some rules\n", (Object)data.getDescription());
        DrlRuleParser rd1 = (DrlRuleParser)data.getRules().get(0);
        Assert.assertEquals((Object)"rule1", (Object)rd1.getName());
        Assert.assertEquals((Object)"", (Object)rd1.getDescription());
        DrlRuleParser rd2 = (DrlRuleParser)data.getRules().get(1);
        Assert.assertEquals((Object)"rule2", (Object)rd2.getName());
        Assert.assertEquals((Object)"", (Object)rd2.getDescription());
    }

    @Test
    public void testfindGlobals() {
        String header = "global LoanApplication gg";
        List globals = DrlPackageParser.findGlobals((String)header);
        Assert.assertEquals((long)1L, (long)globals.size());
        Assert.assertEquals((Object)"LoanApplication gg", globals.get(0));
    }
}

