/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.dtablexls.client.editor;

import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Command;
import com.google.gwtmockito.GwtMockitoTestRunner;
import org.drools.workbench.screens.dtablexls.client.editor.DecisionTableXLSEditorPresenter;
import org.drools.workbench.screens.dtablexls.client.editor.DecisionTableXLSEditorView;
import org.drools.workbench.screens.dtablexls.client.editor.DecisionTableXLSEditorViewImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.widgets.client.widget.AttachmentFileWidget;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.workbench.type.ClientResourceType;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.workbench.events.NotificationEvent;

@RunWith(value=GwtMockitoTestRunner.class)
public class DecisionTableXLSEditorViewImplTest {
    private static final String SERVLET_URL = "dtablexls/file?clientId=123";
    @Spy
    @InjectMocks
    private DecisionTableXLSEditorViewImpl view;
    @Mock
    private EventSourceMock<NotificationEvent> notificationEvent;
    @Mock
    private AttachmentFileWidget attachmentFileWidget;
    @Mock
    private ClientResourceType type;
    @Mock
    private DecisionTableXLSEditorPresenter presenter;
    @Captor
    private ArgumentCaptor<ClickHandler> clickCaptor;
    @Captor
    private ArgumentCaptor<Command> commandCaptor;

    @Before
    public void setup() {
        ((DecisionTableXLSEditorViewImpl)Mockito.doReturn((Object)"123").when((Object)this.view)).getClientId();
        ((DecisionTableXLSEditorViewImpl)Mockito.doReturn((Object)this.attachmentFileWidget).when((Object)this.view)).constructUploadWidget((ClientResourceType)Matchers.any());
        this.view.init((DecisionTableXLSEditorView.Presenter)this.presenter);
    }

    @Test
    public void testGetDownloadUrl() throws Exception {
        Assert.assertEquals((Object)"dtablexls/file?clientId=123&attachmentPath=", (Object)this.view.getDownloadUrl(this.path()));
    }

    @Test
    public void getServletUrl() throws Exception {
        Assert.assertEquals((Object)SERVLET_URL, (Object)this.view.getServletUrl());
    }

    @Test
    public void testUploadWidgetClickHandler() throws Exception {
        ((DecisionTableXLSEditorPresenter)Mockito.doCallRealMethod().when((Object)this.presenter)).onUpload();
        this.view.setupUploadWidget(this.type);
        ((AttachmentFileWidget)Mockito.verify((Object)this.attachmentFileWidget)).addClickHandler((ClickHandler)this.clickCaptor.capture());
        ((ClickHandler)this.clickCaptor.getValue()).onClick(null);
        ((DecisionTableXLSEditorPresenter)Mockito.verify((Object)this.presenter)).submit();
    }

    @Test
    public void testSubmit() throws Exception {
        Path path = (Path)Mockito.mock(Path.class);
        this.view.setupUploadWidget(this.type);
        this.view.submit(path);
        ((AttachmentFileWidget)Mockito.verify((Object)this.attachmentFileWidget)).submit((Path)Matchers.eq((Object)path), (String)Matchers.eq((Object)SERVLET_URL), (Command)this.commandCaptor.capture(), (Command)Matchers.any(Command.class));
        ((Command)this.commandCaptor.getValue()).execute();
        ((EventSourceMock)Mockito.verify(this.notificationEvent)).fire((Object)((NotificationEvent)Matchers.any(NotificationEvent.class)));
        ((DecisionTableXLSEditorPresenter)Mockito.verify((Object)this.presenter)).onUploadSuccess();
    }

    private Path path() {
        return new Path(){

            public String getFileName() {
                return "";
            }

            public String toURI() {
                return "";
            }

            public int compareTo(Path o) {
                return 0;
            }
        };
    }
}

