/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.globals.backend.server.util.indexing;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.util.Version;
import org.drools.workbench.screens.globals.backend.server.util.indexing.TestGlobalsFileIndexer;
import org.drools.workbench.screens.globals.type.GlobalResourceTypeDefinition;
import org.junit.Assert;
import org.junit.Test;
import org.kie.workbench.common.services.refactoring.backend.server.BaseIndexingTest;
import org.kie.workbench.common.services.refactoring.backend.server.TestIndexer;
import org.kie.workbench.common.services.refactoring.backend.server.indexing.RuleAttributeNameAnalyzer;
import org.kie.workbench.common.services.refactoring.backend.server.query.QueryBuilder;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueTypeIndexTerm;
import org.uberfire.ext.metadata.backend.lucene.index.LuceneIndex;
import org.uberfire.ext.metadata.engine.Index;
import org.uberfire.ext.metadata.io.KObjectUtil;
import org.uberfire.ext.metadata.model.KObject;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;

public class IndexGlobalsTest
extends BaseIndexingTest<GlobalResourceTypeDefinition> {
    @Test
    public void testIndexGlobals() throws IOException, InterruptedException {
        Path path1 = this.basePath.resolve("global1.gdrl");
        String drl1 = this.loadText("global1.gdrl");
        this.ioService().write(path1, drl1, new OpenOption[0]);
        Path path2 = this.basePath.resolve("global2.gdrl");
        String drl2 = this.loadText("global2.gdrl");
        this.ioService().write(path2, drl2, new OpenOption[0]);
        Thread.sleep(5000L);
        Index index = IndexGlobalsTest.getConfig().getIndexManager().get(KObjectUtil.toKCluster((FileSystem)this.basePath.getFileSystem()));
        IndexSearcher searcher = ((LuceneIndex)index).nrtSearcher();
        TopScoreDocCollector collector = TopScoreDocCollector.create((int)10, (boolean)true);
        Query query = new QueryBuilder().addTerm((ValueIndexTerm)new ValueTypeIndexTerm("java.util.ArrayList")).build();
        searcher.search(query, (Collector)collector);
        ScoreDoc[] hits = collector.topDocs().scoreDocs;
        Assert.assertEquals((long)2L, (long)hits.length);
        ArrayList<KObject> results = new ArrayList<KObject>();
        for (int i = 0; i < hits.length; ++i) {
            results.add(org.uberfire.ext.metadata.backend.lucene.util.KObjectUtil.toKObject((Document)searcher.doc(hits[i].doc)));
        }
        this.assertContains(results, path1);
        this.assertContains(results, path2);
        ((LuceneIndex)index).nrtRelease(searcher);
    }

    protected TestIndexer getIndexer() {
        return new TestGlobalsFileIndexer();
    }

    public Map<String, Analyzer> getAnalyzers() {
        return new HashMap<String, Analyzer>(){
            {
                this.put("ruleAttribute", new RuleAttributeNameAnalyzer(Version.LUCENE_40));
            }
        };
    }

    protected GlobalResourceTypeDefinition getResourceTypeDefinition() {
        return new GlobalResourceTypeDefinition();
    }

    protected String getRepositoryName() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }
}

