/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.globals.backend.server;

import java.util.HashMap;
import java.util.Map;
import org.drools.workbench.screens.globals.backend.server.GlobalsEditorServiceImpl;
import org.drools.workbench.screens.globals.model.GlobalsModel;
import org.drools.workbench.screens.globals.service.GlobalsEditorService;
import org.guvnor.common.services.backend.metadata.MetadataServerSideService;
import org.guvnor.common.services.backend.util.CommentedOptionFactory;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.services.shared.project.KieProjectService;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.base.options.CommentedOption;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;

@RunWith(value=MockitoJUnitRunner.class)
public class GlobalsEditorServiceTest {
    @Mock
    private KieProjectService kieProjectService;
    @Mock
    private IOService ioService;
    @Mock
    private CommentedOptionFactory commentedOptionFactory;
    @Mock
    private MetadataServerSideService metadataService;
    private GlobalsEditorService globalsEditorService;

    @Before
    public void setUp() {
        this.globalsEditorService = new GlobalsEditorServiceImpl(){
            {
                this.projectService = GlobalsEditorServiceTest.this.kieProjectService;
                this.ioService = GlobalsEditorServiceTest.this.ioService;
                this.commentedOptionFactory = GlobalsEditorServiceTest.this.commentedOptionFactory;
                this.metadataService = GlobalsEditorServiceTest.this.metadataService;
            }
        };
    }

    @Test
    public void save() {
        org.uberfire.backend.vfs.Path path = PathFactory.newPath((String)"test", (String)"file:///test");
        GlobalsModel globalsModel = (GlobalsModel)Mockito.mock(GlobalsModel.class);
        Mockito.when((Object)this.ioService.exists((Path)Matchers.any(Path.class))).thenReturn((Object)false);
        this.globalsEditorService.create(path, "test", (Object)globalsModel, "comment");
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.times((int)1))).write((Path)Matchers.any(Path.class), Matchers.anyString(), new OpenOption[]{(OpenOption)Matchers.any(CommentedOption.class)});
    }

    @Test
    public void generate() {
        org.uberfire.backend.vfs.Path path = PathFactory.newPath((String)"test", (String)"file:///test");
        GlobalsModel globalsModel = (GlobalsModel)Mockito.mock(GlobalsModel.class);
        Mockito.when((Object)this.ioService.exists((Path)Matchers.any(Path.class))).thenReturn((Object)false);
        HashMap<String, Object> metadataMap = new HashMap<String, Object>(){
            {
                this.put("generated.generated", true);
            }
        };
        Mockito.when((Object)this.metadataService.configAttrs(Mockito.anyMapOf(String.class, Object.class), (Metadata)Matchers.any(Metadata.class))).thenReturn((Object)metadataMap);
        this.globalsEditorService.generate(path, "test", globalsModel, "comment");
        ArgumentCaptor mapArgumentCaptor = ArgumentCaptor.forClass(Map.class);
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.times((int)1))).write((Path)Matchers.any(Path.class), Matchers.anyString(), (Map)mapArgumentCaptor.capture(), new OpenOption[]{(OpenOption)Matchers.any(CommentedOption.class)});
        Map capturedMap = (Map)mapArgumentCaptor.getValue();
        Assert.assertEquals((Object)metadataMap, (Object)capturedMap);
        Object generatedAttribute = capturedMap.get("generated.generated");
        Assert.assertNotNull(generatedAttribute);
        Assert.assertTrue((boolean)Boolean.parseBoolean(generatedAttribute.toString()));
    }
}

