/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.globals.backend.server.util;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.kie.workbench.common.services.datamodel.backend.server.builder.util.GlobalsParser;
import org.uberfire.commons.data.Pair;

public class GlobalsParserTest {
    @Test
    public void testSimpleEntry() {
        String content = "global java.util.List myList;";
        List globals = GlobalsParser.parseGlobals((String)"global java.util.List myList;");
        Assert.assertNotNull((Object)globals);
        Assert.assertEquals((long)1L, (long)globals.size());
        Assert.assertEquals((Object)"myList", (Object)((Pair)globals.get(0)).getK1());
        Assert.assertEquals((Object)"java.util.List", (Object)((Pair)globals.get(0)).getK2());
    }

    @Test
    public void testMultipleEntries() {
        String content = "global java.util.List myList;\nglobal java.lang.String myString;";
        List globals = GlobalsParser.parseGlobals((String)"global java.util.List myList;\nglobal java.lang.String myString;");
        Assert.assertNotNull((Object)globals);
        Assert.assertEquals((long)2L, (long)globals.size());
        Assert.assertEquals((Object)"myList", (Object)((Pair)globals.get(0)).getK1());
        Assert.assertEquals((Object)"java.util.List", (Object)((Pair)globals.get(0)).getK2());
        Assert.assertEquals((Object)"myString", (Object)((Pair)globals.get(1)).getK1());
        Assert.assertEquals((Object)"java.lang.String", (Object)((Pair)globals.get(1)).getK2());
    }

    @Test
    public void testCommentedEntry() {
        String content = "global java.util.List myList;\n#global java.lang.String myString;";
        List globals = GlobalsParser.parseGlobals((String)"global java.util.List myList;\n#global java.lang.String myString;");
        Assert.assertNotNull((Object)globals);
        Assert.assertEquals((long)1L, (long)globals.size());
        Assert.assertEquals((Object)"myList", (Object)((Pair)globals.get(0)).getK1());
        Assert.assertEquals((Object)"java.util.List", (Object)((Pair)globals.get(0)).getK2());
    }

    @Test
    public void testWhiteSpace() {
        String content = "  global    java.util.List myList;\n  global   java.lang.String   myString;   ";
        List globals = GlobalsParser.parseGlobals((String)"  global    java.util.List myList;\n  global   java.lang.String   myString;   ");
        Assert.assertNotNull((Object)globals);
        Assert.assertEquals((long)2L, (long)globals.size());
        Assert.assertEquals((Object)"myList", (Object)((Pair)globals.get(0)).getK1());
        Assert.assertEquals((Object)"java.util.List", (Object)((Pair)globals.get(0)).getK2());
        Assert.assertEquals((Object)"myString", (Object)((Pair)globals.get(1)).getK1());
        Assert.assertEquals((Object)"java.lang.String", (Object)((Pair)globals.get(1)).getK2());
    }
}

