/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.globals.backend.server.indexing;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.search.Query;
import org.drools.workbench.screens.globals.backend.server.indexing.TestGlobalsFileIndexer;
import org.drools.workbench.screens.globals.type.GlobalResourceTypeDefinition;
import org.hamcrest.Matcher;
import org.junit.Test;
import org.kie.workbench.common.services.refactoring.backend.server.BaseIndexingTest;
import org.kie.workbench.common.services.refactoring.backend.server.TestIndexer;
import org.kie.workbench.common.services.refactoring.backend.server.query.builder.SingleTermQueryBuilder;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueReferenceIndexTerm;
import org.kie.workbench.common.services.refactoring.service.ResourceType;
import org.mockito.ArgumentMatcher;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.slf4j.LoggerFactory;
import org.uberfire.ext.metadata.io.KObjectUtil;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;

public class IndexGlobalsInvalidDrlTest
extends BaseIndexingTest<GlobalResourceTypeDefinition> {
    @Test
    public void testIndexGlobalsInvalidDrl() throws IOException, InterruptedException {
        Logger root = (Logger)LoggerFactory.getLogger((String)"ROOT");
        Appender mockAppender = (Appender)Mockito.mock(Appender.class);
        Mockito.when((Object)mockAppender.getName()).thenReturn((Object)"MOCK");
        root.addAppender(mockAppender);
        Path path = this.basePath.resolve("bz1269366.gdrl");
        String drl = this.loadText("bz1269366.gdrl");
        this.ioService().write(path, drl, new OpenOption[0]);
        Thread.sleep(5000L);
        List<String> index = Arrays.asList(KObjectUtil.toKCluster((FileSystem)this.basePath.getFileSystem()).getClusterId());
        Query query = new SingleTermQueryBuilder((ValueIndexTerm)new ValueReferenceIndexTerm("java.util.ArrayList", ResourceType.JAVA)).build();
        this.searchFor(index, query, 0, new Path[0]);
        ((Appender)Mockito.verify((Object)mockAppender)).doAppend(Matchers.argThat((Matcher)new ArgumentMatcher<ILoggingEvent>(){

            public boolean matches(Object argument) {
                return ((ILoggingEvent)argument).getMessage().startsWith("Unable to parse DRL");
            }
        }));
    }

    protected TestIndexer getIndexer() {
        return new TestGlobalsFileIndexer();
    }

    protected GlobalResourceTypeDefinition getResourceTypeDefinition() {
        return new GlobalResourceTypeDefinition();
    }

    protected String getRepositoryName() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }
}

