/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.globals.backend.server.indexing;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.search.Query;
import org.drools.workbench.screens.globals.backend.server.indexing.TestGlobalsFileIndexer;
import org.drools.workbench.screens.globals.type.GlobalResourceTypeDefinition;
import org.junit.Test;
import org.kie.workbench.common.services.refactoring.backend.server.BaseIndexingTest;
import org.kie.workbench.common.services.refactoring.backend.server.TestIndexer;
import org.kie.workbench.common.services.refactoring.backend.server.query.builder.SingleTermQueryBuilder;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueReferenceIndexTerm;
import org.kie.workbench.common.services.refactoring.service.ResourceType;
import org.uberfire.ext.metadata.io.KObjectUtil;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;

public class IndexGlobalsTest
extends BaseIndexingTest<GlobalResourceTypeDefinition> {
    @Test
    public void testIndexGlobals() throws IOException, InterruptedException {
        Path path1 = this.basePath.resolve("global1.gdrl");
        String drl1 = this.loadText("global1.gdrl");
        this.ioService().write(path1, drl1, new OpenOption[0]);
        Path path2 = this.basePath.resolve("global2.gdrl");
        String drl2 = this.loadText("global2.gdrl");
        this.ioService().write(path2, drl2, new OpenOption[0]);
        Thread.sleep(5000L);
        List<String> index = Arrays.asList(KObjectUtil.toKCluster((FileSystem)this.basePath.getFileSystem()).getClusterId());
        Query query = new SingleTermQueryBuilder((ValueIndexTerm)new ValueReferenceIndexTerm("java.util.ArrayList", ResourceType.JAVA)).build();
        this.searchFor(index, query, 2, new Path[]{path1, path2});
    }

    protected TestIndexer getIndexer() {
        return new TestGlobalsFileIndexer();
    }

    protected GlobalResourceTypeDefinition getResourceTypeDefinition() {
        return new GlobalResourceTypeDefinition();
    }

    protected String getRepositoryName() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }
}

