/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.globals.backend.server.util;

import org.drools.workbench.screens.globals.backend.server.util.GlobalsPersistence;
import org.drools.workbench.screens.globals.model.Global;
import org.drools.workbench.screens.globals.model.GlobalsModel;
import org.junit.Assert;
import org.junit.Test;

public class GlobalsPersistenceTest {
    @Test
    public void testMarshalling() {
        GlobalsModel model = new GlobalsModel();
        String expected = "global java.lang.String myString;\n";
        model.getGlobals().add(new Global("myString", "java.lang.String"));
        String actual = GlobalsPersistence.getInstance().marshal(model);
        Assert.assertNotNull((Object)actual);
        Assert.assertEquals((Object)"global java.lang.String myString;\n", (Object)actual);
    }

    @Test
    public void testUnmarshalling() {
        String content = "global java.lang.String myString;\n";
        GlobalsModel model = GlobalsPersistence.getInstance().unmarshal("global java.lang.String myString;\n");
        Assert.assertNotNull((Object)model);
        Assert.assertEquals((long)1L, (long)model.getGlobals().size());
        Assert.assertEquals((Object)"java.lang.String", (Object)((Global)model.getGlobals().get(0)).getClassName());
        Assert.assertEquals((Object)"myString", (Object)((Global)model.getGlobals().get(0)).getAlias());
    }
}

