/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.globals.backend.server;

import java.util.HashMap;
import java.util.Map;
import org.drools.workbench.screens.globals.backend.server.GlobalsEditorServiceImpl;
import org.drools.workbench.screens.globals.model.GlobalsModel;
import org.drools.workbench.screens.globals.service.GlobalsEditorService;
import org.guvnor.common.services.backend.metadata.MetadataServerSideService;
import org.guvnor.common.services.backend.util.CommentedOptionFactory;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.services.shared.project.KieModuleService;
import org.mockito.ArgumentCaptor;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.ext.editor.commons.backend.service.SaveAndRenameServiceImpl;
import org.uberfire.ext.editor.commons.service.support.SupportsSaveAndRename;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;

@RunWith(value=MockitoJUnitRunner.class)
public class GlobalsEditorServiceTest {
    @Mock
    private KieModuleService kieModuleService;
    @Mock
    private IOService ioService;
    @Mock
    private CommentedOptionFactory commentedOptionFactory;
    @Mock
    private MetadataServerSideService metadataService;
    @Mock
    private SaveAndRenameServiceImpl<GlobalsModel, Metadata> saveAndRenameService;
    @InjectMocks
    private GlobalsEditorService globalsEditorService = new GlobalsEditorServiceImpl(){
        {
            this.moduleService = GlobalsEditorServiceTest.this.kieModuleService;
            this.ioService = GlobalsEditorServiceTest.this.ioService;
            this.commentedOptionFactory = GlobalsEditorServiceTest.this.commentedOptionFactory;
            this.metadataService = GlobalsEditorServiceTest.this.metadataService;
        }
    };

    @Test
    public void save() {
        org.uberfire.backend.vfs.Path path = PathFactory.newPath((String)"test", (String)"file:///test");
        GlobalsModel globalsModel = (GlobalsModel)Mockito.mock(GlobalsModel.class);
        Mockito.when((Object)this.ioService.exists((Path)Matchers.any(Path.class))).thenReturn((Object)false);
        this.globalsEditorService.create(path, "test", (Object)globalsModel, "comment");
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.times((int)1))).write((Path)Matchers.any(Path.class), Matchers.anyString(), (OpenOption[])Matchers.any());
    }

    @Test
    public void generate() {
        org.uberfire.backend.vfs.Path path = PathFactory.newPath((String)"test", (String)"file:///test");
        GlobalsModel globalsModel = (GlobalsModel)Mockito.mock(GlobalsModel.class);
        Mockito.when((Object)this.ioService.exists((Path)Matchers.any(Path.class))).thenReturn((Object)false);
        HashMap<String, Object> metadataMap = new HashMap<String, Object>(){
            {
                this.put("generated.generated", true);
            }
        };
        Mockito.when((Object)this.metadataService.configAttrs(Mockito.anyMapOf(String.class, Object.class), (Metadata)Matchers.any(Metadata.class))).thenReturn((Object)metadataMap);
        this.globalsEditorService.generate(path, "test", globalsModel, "comment");
        ArgumentCaptor mapArgumentCaptor = ArgumentCaptor.forClass(Map.class);
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.times((int)1))).write((Path)Matchers.any(Path.class), Matchers.anyString(), (Map)mapArgumentCaptor.capture(), (OpenOption[])Matchers.any());
        Map capturedMap = (Map)mapArgumentCaptor.getValue();
        Assert.assertEquals((Object)metadataMap, (Object)capturedMap);
        Object generatedAttribute = capturedMap.get("generated.generated");
        Assert.assertNotNull(generatedAttribute);
        Assert.assertTrue((boolean)Boolean.parseBoolean(generatedAttribute.toString()));
    }

    @Test
    public void testInit() throws Exception {
        GlobalsEditorServiceImpl service = (GlobalsEditorServiceImpl)this.globalsEditorService;
        service.init();
        ((SaveAndRenameServiceImpl)Mockito.verify(this.saveAndRenameService)).init((SupportsSaveAndRename)service);
    }

    @Test
    public void testSaveAndRename() throws Exception {
        GlobalsEditorServiceImpl service = (GlobalsEditorServiceImpl)this.globalsEditorService;
        org.uberfire.backend.vfs.Path path = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        String newFileName = "newFileName";
        Metadata metadata = (Metadata)Mockito.mock(Metadata.class);
        GlobalsModel content = (GlobalsModel)Mockito.mock(GlobalsModel.class);
        String comment = "comment";
        service.saveAndRename(path, "newFileName", metadata, content, "comment");
        ((SaveAndRenameServiceImpl)Mockito.verify(this.saveAndRenameService)).saveAndRename(path, "newFileName", (Object)metadata, (Object)content, "comment");
    }
}

